/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.ByteRangeSpec;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Objects;
import java.util.function.UnaryOperator;

abstract class HttpContentRange {
    private final boolean finalizing;

    private HttpContentRange(boolean finalizing) {
        this.finalizing = finalizing;
    }

    public abstract String getHeaderValue();

    public abstract boolean endOffsetEquals(long var1);

    public boolean isFinalizing() {
        return this.finalizing;
    }

    static Total of(ByteRangeSpec spec, long size) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size must be >= 0");
        Preconditions.checkArgument((size >= spec.endOffsetInclusive() ? 1 : 0) != 0, (Object)"size must be >= end");
        return new Total(spec, size);
    }

    static Incomplete of(ByteRangeSpec spec) {
        return new Incomplete(spec);
    }

    static Size of(long size) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size must be >= 0");
        return new Size(size);
    }

    static Query query() {
        return Query.INSTANCE;
    }

    static HttpContentRange parse(String string) {
        if ("bytes */*".equals(string)) {
            return HttpContentRange.query();
        }
        if (string.startsWith("bytes */")) {
            return HttpContentRange.of(Long.parseLong(string.substring(8)));
        }
        int idxDash = string.indexOf(45);
        int idxSlash = string.indexOf(47);
        String beginS = string.substring(6, idxDash);
        String endS = string.substring(idxDash + 1, idxSlash);
        long begin = Long.parseLong(beginS);
        long end = Long.parseLong(endS);
        if (string.endsWith("/*")) {
            return HttpContentRange.of(ByteRangeSpec.explicitClosed(begin, end));
        }
        String sizeS = string.substring(idxSlash + 1);
        long size = Long.parseLong(sizeS);
        return HttpContentRange.of(ByteRangeSpec.explicitClosed(begin, end), size);
    }

    static final class Total
    extends HttpContentRange
    implements HasRange<Total>,
    HasSize {
        private final ByteRangeSpec spec;
        private final long size;

        private Total(ByteRangeSpec spec, long size) {
            super(true);
            this.spec = spec;
            this.size = size;
        }

        @Override
        public String getHeaderValue() {
            return String.format(Locale.US, "bytes %d-%d/%d", this.spec.beginOffset(), this.spec.endOffsetInclusive(), this.size);
        }

        @Override
        public boolean endOffsetEquals(long e) {
            return e == this.spec.endOffset();
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public ByteRangeSpec range() {
            return this.spec;
        }

        @Override
        public Total map(UnaryOperator<ByteRangeSpec> f) {
            return new Total((ByteRangeSpec)f.apply(this.spec), this.size);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Total)) {
                return false;
            }
            Total total = (Total)o;
            return this.size == total.size && Objects.equals(this.spec, total.spec);
        }

        public int hashCode() {
            return Objects.hash(this.spec, this.size);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("spec", (Object)this.spec).add("size", this.size).toString();
        }
    }

    static final class Incomplete
    extends HttpContentRange
    implements HasRange<Incomplete> {
        private final ByteRangeSpec spec;

        private Incomplete(ByteRangeSpec spec) {
            super(false);
            this.spec = spec;
        }

        @Override
        public String getHeaderValue() {
            return String.format(Locale.US, "bytes %d-%d/*", this.spec.beginOffset(), this.spec.endOffsetInclusive());
        }

        @Override
        public boolean endOffsetEquals(long e) {
            return e == this.spec.endOffset();
        }

        @Override
        public ByteRangeSpec range() {
            return this.spec;
        }

        @Override
        public Incomplete map(UnaryOperator<ByteRangeSpec> f) {
            return new Incomplete((ByteRangeSpec)f.apply(this.spec));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Incomplete)) {
                return false;
            }
            Incomplete that = (Incomplete)o;
            return Objects.equals(this.spec, that.spec);
        }

        public int hashCode() {
            return Objects.hash(this.spec);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("spec", (Object)this.spec).toString();
        }
    }

    static final class Size
    extends HttpContentRange
    implements HasSize {
        private final long size;

        private Size(long size) {
            super(true);
            this.size = size;
        }

        @Override
        public String getHeaderValue() {
            return String.format(Locale.US, "bytes */%d", this.size);
        }

        @Override
        public boolean endOffsetEquals(long e) {
            return false;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Size)) {
                return false;
            }
            Size size1 = (Size)o;
            return this.size == size1.size;
        }

        public int hashCode() {
            return Objects.hash(this.size);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("size", this.size).toString();
        }
    }

    static final class Query
    extends HttpContentRange {
        private static final Query INSTANCE = new Query();

        private Query() {
            super(false);
        }

        @Override
        public boolean endOffsetEquals(long e) {
            return false;
        }

        @Override
        public String getHeaderValue() {
            return "bytes */*";
        }
    }

    static interface HasSize {
        public long getSize();
    }

    static interface HasRange<T extends HttpContentRange> {
        public ByteRangeSpec range();

        public T map(UnaryOperator<ByteRangeSpec> var1);
    }
}

