/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class AttachmentProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, AttachmentProcessor> {
    @Nonnull
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    @Nullable
    private final Long indexedChars;
    @Nullable
    private final String indexedCharsField;
    @Nonnull
    private final List<String> properties;
    @Nullable
    private final String resourceName;
    @Nullable
    private final String targetField;
    public static final JsonpDeserializer<AttachmentProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AttachmentProcessor::setupAttachmentProcessorDeserializer);

    private AttachmentProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.indexedChars = builder.indexedChars;
        this.indexedCharsField = builder.indexedCharsField;
        this.properties = ApiTypeHelper.unmodifiable(builder.properties);
        this.resourceName = builder.resourceName;
        this.targetField = builder.targetField;
    }

    public static AttachmentProcessor of(Function<Builder, ObjectBuilder<AttachmentProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Attachment;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nullable
    public final Long indexedChars() {
        return this.indexedChars;
    }

    @Nullable
    public final String indexedCharsField() {
        return this.indexedCharsField;
    }

    @Nonnull
    public final List<String> properties() {
        return this.properties;
    }

    @Nullable
    public final String resourceName() {
        return this.resourceName;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (this.indexedChars != null) {
            generator.writeKey("indexed_chars");
            generator.write(this.indexedChars.longValue());
        }
        if (this.indexedCharsField != null) {
            generator.writeKey("indexed_chars_field");
            generator.write(this.indexedCharsField);
        }
        if (ApiTypeHelper.isDefined(this.properties)) {
            generator.writeKey("properties");
            generator.writeStartArray();
            for (String item0 : this.properties) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.resourceName != null) {
            generator.writeKey("resource_name");
            generator.write(this.resourceName);
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupAttachmentProcessorDeserializer(ObjectDeserializer<Builder> op) {
        AttachmentProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::indexedChars, JsonpDeserializer.longDeserializer(), "indexed_chars");
        op.add(Builder::indexedCharsField, JsonpDeserializer.stringDeserializer(), "indexed_chars_field");
        op.add(Builder::properties, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "properties");
        op.add(Builder::resourceName, JsonpDeserializer.stringDeserializer(), "resource_name");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreMissing);
        result = 31 * result + Objects.hashCode(this.indexedChars);
        result = 31 * result + Objects.hashCode(this.indexedCharsField);
        result = 31 * result + Objects.hashCode(this.properties);
        result = 31 * result + Objects.hashCode(this.resourceName);
        result = 31 * result + Objects.hashCode(this.targetField);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentProcessor other = (AttachmentProcessor)o;
        return this.field.equals(other.field) && Objects.equals(this.ignoreMissing, other.ignoreMissing) && Objects.equals(this.indexedChars, other.indexedChars) && Objects.equals(this.indexedCharsField, other.indexedCharsField) && Objects.equals(this.properties, other.properties) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.targetField, other.targetField);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, AttachmentProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private Long indexedChars;
        @Nullable
        private String indexedCharsField;
        @Nullable
        private List<String> properties;
        @Nullable
        private String resourceName;
        @Nullable
        private String targetField;

        public Builder() {
        }

        private Builder(AttachmentProcessor o) {
            super(o);
            this.field = o.field;
            this.ignoreMissing = o.ignoreMissing;
            this.indexedChars = o.indexedChars;
            this.indexedCharsField = o.indexedCharsField;
            this.properties = Builder._listCopy(o.properties);
            this.resourceName = o.resourceName;
            this.targetField = o.targetField;
        }

        private Builder(Builder o) {
            super(o);
            this.field = o.field;
            this.ignoreMissing = o.ignoreMissing;
            this.indexedChars = o.indexedChars;
            this.indexedCharsField = o.indexedCharsField;
            this.properties = Builder._listCopy(o.properties);
            this.resourceName = o.resourceName;
            this.targetField = o.targetField;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Nonnull
        public final Builder indexedChars(@Nullable Long value) {
            this.indexedChars = value;
            return this;
        }

        @Nonnull
        public final Builder indexedCharsField(@Nullable String value) {
            this.indexedCharsField = value;
            return this;
        }

        @Nonnull
        public final Builder properties(List<String> list) {
            this.properties = Builder._listAddAll(this.properties, list);
            return this;
        }

        @Nonnull
        public final Builder properties(String value, String ... values) {
            this.properties = Builder._listAdd(this.properties, value, values);
            return this;
        }

        @Nonnull
        public final Builder resourceName(@Nullable String value) {
            this.resourceName = value;
            return this;
        }

        @Nonnull
        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Override
        @Nonnull
        public AttachmentProcessor build() {
            this._checkSingleUse();
            return new AttachmentProcessor(this);
        }
    }
}

