/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest.simulate;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Ingest
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Ingest> {
    @Nullable
    private final String pipeline;
    @Nonnull
    private final String timestamp;
    public static final JsonpDeserializer<Ingest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Ingest::setupIngestDeserializer);

    private Ingest(Builder builder) {
        this.pipeline = builder.pipeline;
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
    }

    public static Ingest of(Function<Builder, ObjectBuilder<Ingest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String pipeline() {
        return this.pipeline;
    }

    @Nonnull
    public final String timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.pipeline != null) {
            generator.writeKey("pipeline");
            generator.write(this.pipeline);
        }
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIngestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::pipeline, JsonpDeserializer.stringDeserializer(), "pipeline");
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.pipeline);
        result = 31 * result + this.timestamp.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ingest other = (Ingest)o;
        return Objects.equals(this.pipeline, other.pipeline) && this.timestamp.equals(other.timestamp);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Ingest> {
        @Nullable
        private String pipeline;
        private String timestamp;

        public Builder() {
        }

        private Builder(Ingest o) {
            this.pipeline = o.pipeline;
            this.timestamp = o.timestamp;
        }

        private Builder(Builder o) {
            this.pipeline = o.pipeline;
            this.timestamp = o.timestamp;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder pipeline(@Nullable String value) {
            this.pipeline = value;
            return this;
        }

        @Nonnull
        public final Builder timestamp(String value) {
            this.timestamp = value;
            return this;
        }

        @Override
        @Nonnull
        public Ingest build() {
            this._checkSingleUse();
            return new Ingest(this);
        }
    }
}

