/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar.extractors;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tribuo.data.columnar.extractors.SimpleFieldExtractor;

public class OffsetDateTimeExtractor
extends SimpleFieldExtractor<OffsetDateTime> {
    private static final Logger logger = Logger.getLogger(OffsetDateTimeExtractor.class.getName());
    @Config(mandatory=true, description="The expected date format.")
    private String dateTimeFormat;
    private DateTimeFormatter formatter;
    @Config(mandatory=false, description="The locale language.")
    private String localeLanguage = null;
    @Config(mandatory=false, description="The locale country.")
    private String localeCountry = null;

    private OffsetDateTimeExtractor() {
    }

    public OffsetDateTimeExtractor(String fieldName, String metadataName, String dateTimeFormat) {
        this(fieldName, metadataName, dateTimeFormat, null, null);
    }

    public OffsetDateTimeExtractor(String fieldName, String metadataName, String dateTimeFormat, String localeLanguage, String localeCountry) {
        super(fieldName, metadataName);
        this.dateTimeFormat = dateTimeFormat;
        this.localeCountry = localeCountry;
        this.localeLanguage = localeLanguage;
        this.postConfig();
    }

    @Override
    public void postConfig() {
        Locale locale;
        super.postConfig();
        if (this.localeLanguage == null && this.localeCountry == null) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        } else {
            if (this.localeLanguage == null) {
                throw new PropertyException("", "localeLanguage", "Must supply both localeLanguage and localeCountry when setting the locale.");
            }
            if (this.localeCountry == null) {
                throw new PropertyException("", "localeCountry", "Must supply both localeLanguage and localeCountry when setting the locale.");
            }
            locale = new Locale(this.localeLanguage, this.localeCountry);
        }
        if (this.dateTimeFormat != null) {
            try {
                this.formatter = DateTimeFormatter.ofPattern(this.dateTimeFormat, locale);
            }
            catch (IllegalArgumentException e) {
                throw new PropertyException((Throwable)e, "", "dateTimeFormat", "dateTimeFormat could not be parsed by DateTimeFormatter");
            }
        } else {
            throw new PropertyException("", "dateTimeFormat", "Invalid Date/Time format string supplied");
        }
    }

    @Override
    public Class<OffsetDateTime> getValueType() {
        return OffsetDateTime.class;
    }

    @Override
    protected Optional<OffsetDateTime> extractField(String s) {
        try {
            return Optional.of(OffsetDateTime.parse(s, this.formatter));
        }
        catch (DateTimeParseException e) {
            logger.log(Level.WARNING, e.getParsedString());
            logger.log(Level.WARNING, String.format("Unable to parse date/time %s with formatter %s", s, this.dateTimeFormat));
            return Optional.empty();
        }
    }

    @Override
    public String toString() {
        return "OffsetDateTimeExtractor(fieldName='" + this.fieldName + '\'' + ", metadataName='" + this.metadataName + '\'' + ", dateTimeFormat='" + this.dateTimeFormat + '\'' + ", localeLanguage='" + this.localeLanguage + '\'' + ", localeCountry='" + this.localeCountry + '\'' + ')';
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "FieldExtractor");
    }
}

