/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.CellManifestCurrentRevision;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.CellManifestDataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataElement;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.IntermediateNodeObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupDataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.RevisionManifestDataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.RevisionManifestObjectGroupReferences;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.RevisionManifestRootDeclare;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageIndexCellMapping;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageIndexDataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageIndexManifestMapping;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageIndexRevisionMapping;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageManifestDataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageManifestRootDeclare;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageManifestSchemaGUID;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BasicObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.CellID;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.DataElementType;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGuid;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.SerialNumber;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.GuidUtil;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.SequenceNumberGenerator;

public class DataElementUtils {
    public static final UUID RootExGuid = UUID.fromString("84DEFAB9-AAA3-4A0D-A3A8-520C77AC7073");
    public static final UUID CellSecondExGuid = UUID.fromString("6F2A4665-42C8-46C7-BAB4-E28FDCE1E32B");
    public static final UUID SchemaGuid = UUID.fromString("0EB93394-571D-41E9-AAD3-880D92D31955");

    public static List<DataElement> buildDataElements(byte[] fileContent, AtomicReference<ExGuid> storageIndexExGuid) throws TikaException, IOException {
        ArrayList<ExGuid> objectDataExGuidList = new ArrayList<ExGuid>();
        AtomicReference<ExGuid> rootNodeObjectExGuid = new AtomicReference<ExGuid>();
        List<DataElement> dataElementList = DataElementUtils.createObjectGroupDataElement(fileContent, rootNodeObjectExGuid, objectDataExGuidList);
        ExGuid baseRevisionID = new ExGuid(0, GuidUtil.emptyGuid());
        HashMap<ExGuid, ExGuid> revisionMapping = new HashMap<ExGuid, ExGuid>();
        AtomicReference<ExGuid> currentRevisionID = new AtomicReference<ExGuid>();
        dataElementList.add(DataElementUtils.createRevisionManifestDataElement(rootNodeObjectExGuid.get(), baseRevisionID, objectDataExGuidList, revisionMapping, currentRevisionID));
        HashMap<CellID, ExGuid> cellIDMapping = new HashMap<CellID, ExGuid>();
        dataElementList.add(DataElementUtils.createCellMainifestDataElement(currentRevisionID.get(), cellIDMapping));
        dataElementList.add(DataElementUtils.createStorageManifestDataElement(cellIDMapping));
        dataElementList.add(DataElementUtils.createStorageIndexDataElement(dataElementList.get((int)(dataElementList.size() - 1)).dataElementExGuid, cellIDMapping, revisionMapping));
        storageIndexExGuid.set(dataElementList.get((int)(dataElementList.size() - 1)).dataElementExGuid);
        return dataElementList;
    }

    public static List<DataElement> createObjectGroupDataElement(byte[] fileContent, AtomicReference<ExGuid> rootNodeExGuid, List<ExGuid> objectDataExGuidList) throws TikaException, IOException {
        IntermediateNodeObject rootNode = new IntermediateNodeObject.RootNodeObjectBuilder().Build(fileContent);
        rootNodeExGuid.set(new ExGuid(rootNode.exGuid));
        List<DataElement> elements = new ObjectGroupDataElementData.Builder().build(rootNode);
        elements.stream().filter(element -> element.dataElementType == DataElementType.ObjectGroupDataElementData).forEach(element -> objectDataExGuidList.add(element.dataElementExGuid));
        return elements;
    }

    public static DataElement createRevisionManifestDataElement(ExGuid rootObjectExGuid, ExGuid baseRevisionID, List<ExGuid> refferenceObjectDataExGuidList, Map<ExGuid, ExGuid> revisionMapping, AtomicReference<ExGuid> currentRevisionID) {
        RevisionManifestDataElementData data = new RevisionManifestDataElementData();
        data.revisionManifest.revisionID = new ExGuid(1, UUID.randomUUID());
        data.revisionManifest.baseRevisionID = new ExGuid(baseRevisionID);
        RevisionManifestRootDeclare revisionManifestRootDeclare = new RevisionManifestRootDeclare();
        revisionManifestRootDeclare.rootExGuid = new ExGuid(2, RootExGuid);
        revisionManifestRootDeclare.objectExGuid = new ExGuid(rootObjectExGuid);
        data.revisionManifestRootDeclareList.add(revisionManifestRootDeclare);
        if (refferenceObjectDataExGuidList != null) {
            for (ExGuid dataGuid : refferenceObjectDataExGuidList) {
                data.revisionManifestObjectGroupReferences.add(new RevisionManifestObjectGroupReferences(dataGuid));
            }
        }
        DataElement dataElement = new DataElement(DataElementType.RevisionManifestDataElementData, data);
        revisionMapping.put(data.revisionManifest.revisionID, dataElement.dataElementExGuid);
        currentRevisionID.set(data.revisionManifest.revisionID);
        return dataElement;
    }

    public static DataElement createCellMainifestDataElement(ExGuid revisionId, Map<CellID, ExGuid> cellIDMapping) {
        CellManifestDataElementData data = new CellManifestDataElementData();
        data.cellManifestCurrentRevision = new CellManifestCurrentRevision();
        data.cellManifestCurrentRevision.cellManifestCurrentRevisionExGuid = new ExGuid(revisionId);
        DataElement dataElement = new DataElement(DataElementType.CellManifestDataElementData, data);
        CellID cellID = new CellID(new ExGuid(1, RootExGuid), new ExGuid(1, CellSecondExGuid));
        cellIDMapping.put(cellID, dataElement.dataElementExGuid);
        return dataElement;
    }

    public static DataElement createStorageManifestDataElement(Map<CellID, ExGuid> cellIDMapping) {
        StorageManifestDataElementData data = new StorageManifestDataElementData();
        data.storageManifestSchemaGUID = new StorageManifestSchemaGUID();
        data.storageManifestSchemaGUID.guid = SchemaGuid;
        for (Map.Entry<CellID, ExGuid> kv : cellIDMapping.entrySet()) {
            StorageManifestRootDeclare manifestRootDeclare = new StorageManifestRootDeclare();
            manifestRootDeclare.rootExGUID = new ExGuid(2, RootExGuid);
            manifestRootDeclare.cellID = new CellID(kv.getKey());
            data.storageManifestRootDeclareList.add(manifestRootDeclare);
        }
        return new DataElement(DataElementType.StorageManifestDataElementData, data);
    }

    public static DataElement createStorageIndexDataElement(ExGuid manifestExGuid, Map<CellID, ExGuid> cellIDMappings, Map<ExGuid, ExGuid> revisionIDMappings) {
        StorageIndexDataElementData data = new StorageIndexDataElementData();
        data.storageIndexManifestMapping = new StorageIndexManifestMapping();
        data.storageIndexManifestMapping.manifestMappingExGuid = new ExGuid(manifestExGuid);
        data.storageIndexManifestMapping.manifestMappingSerialNumber = new SerialNumber(UUID.randomUUID(), SequenceNumberGenerator.GetCurrentSerialNumber());
        for (Map.Entry<CellID, ExGuid> entry : cellIDMappings.entrySet()) {
            StorageIndexCellMapping cellMapping = new StorageIndexCellMapping();
            cellMapping.cellID = entry.getKey();
            cellMapping.cellMappingExGuid = entry.getValue();
            cellMapping.cellMappingSerialNumber = new SerialNumber(UUID.randomUUID(), SequenceNumberGenerator.GetCurrentSerialNumber());
            data.storageIndexCellMappingList.add(cellMapping);
        }
        for (Map.Entry<BasicObject, ExGuid> entry : revisionIDMappings.entrySet()) {
            StorageIndexRevisionMapping revisionMapping = new StorageIndexRevisionMapping();
            revisionMapping.revisionExGuid = (ExGuid)entry.getKey();
            revisionMapping.revisionMappingExGuid = entry.getValue();
            revisionMapping.revisionMappingSerialNumber = new SerialNumber(UUID.randomUUID(), SequenceNumberGenerator.GetCurrentSerialNumber());
            data.storageIndexRevisionMappingList.add(revisionMapping);
        }
        return new DataElement(DataElementType.StorageIndexDataElementData, data);
    }

    public static List<ObjectGroupDataElementData> getDataObjectDataElementData(List<DataElement> dataElements, ExGuid storageIndexExGuid, AtomicReference<ExGuid> rootExGuid) throws TikaException {
        AtomicReference<ExGuid> manifestMappingGuid = new AtomicReference<ExGuid>();
        AtomicReference<HashMap<CellID, ExGuid>> cellIDMappings = new AtomicReference<HashMap<CellID, ExGuid>>();
        AtomicReference<HashMap<ExGuid, ExGuid>> revisionIDMappings = new AtomicReference<HashMap<ExGuid, ExGuid>>();
        DataElementUtils.analyzeStorageIndexDataElement(dataElements, storageIndexExGuid, manifestMappingGuid, cellIDMappings, revisionIDMappings);
        StorageManifestDataElementData manifestData = DataElementUtils.getStorageManifestDataElementData(dataElements, manifestMappingGuid.get());
        if (manifestData == null) {
            throw new InvalidOperationException("Cannot find the storage manifest data element with ExGuid " + manifestMappingGuid.get().guid.toString());
        }
        CellManifestDataElementData cellData = DataElementUtils.getCellManifestDataElementData(dataElements, manifestData, cellIDMappings.get());
        RevisionManifestDataElementData revisionData = DataElementUtils.getRevisionManifestDataElementData(dataElements, cellData, revisionIDMappings.get());
        return DataElementUtils.getDataObjectDataElementData(dataElements, revisionData, rootExGuid);
    }

    public static boolean tryAnalyzeWhetherFullDataElementList(List<DataElement> dataElements, ExGuid storageIndexExGuid) throws TikaException {
        AtomicReference<ExGuid> manifestMappingGuid = new AtomicReference<ExGuid>();
        AtomicReference<HashMap<CellID, ExGuid>> cellIDMappings = new AtomicReference<HashMap<CellID, ExGuid>>();
        AtomicReference<HashMap<ExGuid, ExGuid>> revisionIDMappings = new AtomicReference<HashMap<ExGuid, ExGuid>>();
        if (!DataElementUtils.analyzeStorageIndexDataElement(dataElements, storageIndexExGuid, manifestMappingGuid, cellIDMappings, revisionIDMappings)) {
            return false;
        }
        if (cellIDMappings.get().size() == 0) {
            return false;
        }
        if (revisionIDMappings.get().size() == 0) {
            return false;
        }
        StorageManifestDataElementData manifestData = DataElementUtils.getStorageManifestDataElementData(dataElements, manifestMappingGuid.get());
        if (manifestData == null) {
            return false;
        }
        for (StorageManifestRootDeclare kv : manifestData.storageManifestRootDeclareList) {
            if (!cellIDMappings.get().containsKey(kv.cellID)) {
                throw new InvalidOperationException(String.format(Locale.US, "Cannot find the Cell ID %s in the cell id mapping", kv.cellID.toString()));
            }
            ExGuid cellMappingID = cellIDMappings.get().get(kv.cellID);
            DataElement dataElement = dataElements.stream().filter(element -> element.dataElementExGuid.equals(cellMappingID)).findAny().orElse(null);
            if (dataElement == null) {
                return false;
            }
            CellManifestDataElementData cellData = dataElement.getData(CellManifestDataElementData.class);
            ExGuid currentRevisionExGuid = cellData.cellManifestCurrentRevision.cellManifestCurrentRevisionExGuid;
            if (!revisionIDMappings.get().containsKey(currentRevisionExGuid)) {
                throw new InvalidOperationException(String.format(Locale.US, "Cannot find the revision id %s in the revisionMapping", currentRevisionExGuid.toString()));
            }
            ExGuid revisionMapping = revisionIDMappings.get().get(currentRevisionExGuid);
            dataElement = dataElements.stream().filter(element -> element.dataElementExGuid.equals(revisionMapping)).findAny().orElse(null);
            if (dataElement == null) {
                return false;
            }
            RevisionManifestDataElementData revisionData = dataElement.getData(RevisionManifestDataElementData.class);
            for (RevisionManifestObjectGroupReferences reference : revisionData.revisionManifestObjectGroupReferences) {
                dataElement = dataElements.stream().filter(element -> element.dataElementExGuid.equals(reference.objectGroupExtendedGUID)).findAny().orElse(null);
                if (dataElement != null) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean tryAnalyzeWhetherConfirmSchema(List<DataElement> dataElements, ExGuid storageIndexExGuid) throws TikaException {
        DataElement storageIndexDataElement = dataElements.stream().filter(element -> element.dataElementExGuid.equals(storageIndexExGuid)).findAny().orElse(null);
        if (storageIndexExGuid == null) {
            return false;
        }
        StorageIndexDataElementData storageIndexData = storageIndexDataElement.getData(StorageIndexDataElementData.class);
        ExGuid manifestMappingGuid = storageIndexData.storageIndexManifestMapping.manifestMappingExGuid;
        DataElement storageManifestDataElement = dataElements.stream().filter(element -> element.dataElementExGuid.equals(manifestMappingGuid)).findAny().orElse(null);
        if (storageManifestDataElement == null) {
            return false;
        }
        return SchemaGuid.equals(storageManifestDataElement.getData(StorageManifestDataElementData.class).storageManifestSchemaGUID.guid);
    }

    public static boolean analyzeStorageIndexDataElement(List<DataElement> dataElements, ExGuid storageIndexExGuid, AtomicReference<ExGuid> manifestMappingGuid, AtomicReference<HashMap<CellID, ExGuid>> cellIDMappings, AtomicReference<HashMap<ExGuid, ExGuid>> revisionIDMappings) throws TikaException {
        manifestMappingGuid.set(null);
        cellIDMappings.set(null);
        revisionIDMappings.set(null);
        if (storageIndexExGuid == null) {
            return false;
        }
        DataElement storageIndexDataElement = dataElements.stream().filter(element -> element.dataElementExGuid.equals(storageIndexExGuid)).findAny().orElse(null);
        StorageIndexDataElementData storageIndexData = storageIndexDataElement.getData(StorageIndexDataElementData.class);
        manifestMappingGuid.set(storageIndexData.storageIndexManifestMapping.manifestMappingExGuid);
        cellIDMappings.set(new HashMap());
        for (StorageIndexCellMapping storageIndexCellMapping : storageIndexData.storageIndexCellMappingList) {
            cellIDMappings.get().put(storageIndexCellMapping.cellID, storageIndexCellMapping.cellMappingExGuid);
        }
        revisionIDMappings.set(new HashMap());
        for (StorageIndexRevisionMapping storageIndexRevisionMapping : storageIndexData.storageIndexRevisionMappingList) {
            revisionIDMappings.get().put(storageIndexRevisionMapping.revisionExGuid, storageIndexRevisionMapping.revisionMappingExGuid);
        }
        return true;
    }

    public static StorageManifestDataElementData getStorageManifestDataElementData(List<DataElement> dataElements, ExGuid manifestMapping) throws TikaException {
        DataElement storageManifestDataElement = dataElements.stream().filter(element -> element.dataElementExGuid.equals(manifestMapping)).findAny().orElse(null);
        if (storageManifestDataElement == null) {
            return null;
        }
        return storageManifestDataElement.getData(StorageManifestDataElementData.class);
    }

    public static CellManifestDataElementData getCellManifestDataElementData(List<DataElement> dataElements, StorageManifestDataElementData manifestDataElementData, HashMap<CellID, ExGuid> cellIDMappings) throws TikaException {
        CellID cellID = new CellID(new ExGuid(1, RootExGuid), new ExGuid(1, CellSecondExGuid));
        for (StorageManifestRootDeclare kv : manifestDataElementData.storageManifestRootDeclareList) {
            if (!kv.rootExGUID.equals(new ExGuid(2, RootExGuid)) || !kv.cellID.equals(cellID)) continue;
            if (!cellIDMappings.containsKey(kv.cellID)) {
                throw new InvalidOperationException(String.format(Locale.US, "Cannot fin the Cell ID %s in the cell id mapping", cellID));
            }
            ExGuid cellMappingID = cellIDMappings.get(kv.cellID);
            DataElement dataElement = dataElements.stream().filter(element -> element.dataElementExGuid.equals(cellMappingID)).findAny().orElse(null);
            if (dataElement == null) {
                throw new InvalidOperationException("Cannot find the  cell data element with ExGuid " + cellMappingID.guid.toString());
            }
            return dataElement.getData(CellManifestDataElementData.class);
        }
        throw new InvalidOperationException("Cannot find the CellManifestDataElement");
    }

    public static RevisionManifestDataElementData getRevisionManifestDataElementData(List<DataElement> dataElements, CellManifestDataElementData cellData, HashMap<ExGuid, ExGuid> revisionIDMappings) throws TikaException {
        ExGuid currentRevisionExGuid = cellData.cellManifestCurrentRevision.cellManifestCurrentRevisionExGuid;
        if (!revisionIDMappings.containsKey(currentRevisionExGuid)) {
            throw new InvalidOperationException(String.format(Locale.US, "Cannot find the revision id %s in the revisionMapping", currentRevisionExGuid.toString()));
        }
        ExGuid revisionMapping = revisionIDMappings.get(currentRevisionExGuid);
        DataElement dataElement = dataElements.stream().filter(element -> element.dataElementExGuid.equals(revisionMapping)).findAny().orElse(null);
        if (dataElement == null) {
            throw new InvalidOperationException("Cannot find the revision data element with ExGuid " + revisionMapping.guid);
        }
        return dataElement.getData(RevisionManifestDataElementData.class);
    }

    public static List<ObjectGroupDataElementData> getDataObjectDataElementData(List<DataElement> dataElements, RevisionManifestDataElementData revisionData, AtomicReference<ExGuid> rootExGuid) throws TikaException {
        rootExGuid = null;
        for (RevisionManifestRootDeclare kv : revisionData.revisionManifestRootDeclareList) {
            if (!kv.rootExGuid.equals(new ExGuid(2, RootExGuid))) continue;
            rootExGuid.set(kv.objectExGuid);
            break;
        }
        ArrayList<ObjectGroupDataElementData> dataList = new ArrayList<ObjectGroupDataElementData>();
        for (RevisionManifestObjectGroupReferences kv : revisionData.revisionManifestObjectGroupReferences) {
            DataElement dataElement = dataElements.stream().filter(element -> element.dataElementExGuid.equals(kv.objectGroupExtendedGUID)).findAny().orElse(null);
            if (dataElement == null) {
                throw new InvalidOperationException("Cannot find the object group data element with ExGuid " + kv.objectGroupExtendedGUID.guid.toString());
            }
            dataList.add(dataElement.getData(ObjectGroupDataElementData.class));
        }
        return dataList;
    }
}

