import gettext
import locale
import signal
from pathlib import Path
from typing import Literal, cast

import gi

gi.require_versions(
    {
        "Gtk": "4.0",
        "Adw": "1",
    }
)

from gi.repository import Gio

APP_ID = "garden.jamie.Morphosis"
PREFIX = "/garden/jamie/Morphosis"
PROFILE = cast(Literal["release", "development"], "release")
VERSION = "49.0"

_RESOURCES = ("data", "ui")
_LOCALEDIR = "/usr/share/locale"
_PKGDATADIR = "/usr/share/morphosis"

signal.signal(signal.SIGINT, signal.SIG_DFL)

locale.bindtextdomain("morphosis", _LOCALEDIR)
locale.textdomain("morphosis")
gettext.bindtextdomain("morphosis", _LOCALEDIR)
gettext.textdomain("morphosis")

for name in _RESOURCES:
    path = Path(_PKGDATADIR, f"{name}.gresource")
    resource = Gio.Resource.load(str(path))
    Gio.resources_register(resource)

PANDOC_DEFAULTS_FILE = Path(_PKGDATADIR, "defaults.yaml")
