/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.io.IOException;
import java.io.OutputStream;
import org.infinispan.client.hotrod.impl.protocol.ChannelOutputStreamListener;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;

public class ChannelOutputStream
extends OutputStream
implements GenericFutureListener<Future<? super Void>> {
    private static final int BUFFER_SIZE = 8192;
    private final Channel channel;
    private final ChannelOutputStreamListener listener;
    private ByteBuf buf;

    public ChannelOutputStream(Channel channel, ChannelOutputStreamListener listener) {
        this.channel = channel;
        this.listener = listener;
    }

    private void alloc() {
        this.buf = this.channel.alloc().buffer(8192);
    }

    private ChannelPromise writePromise() {
        DefaultChannelPromise promise = new DefaultChannelPromise(this.channel, (EventExecutor)ImmediateEventExecutor.INSTANCE);
        promise.addListener((GenericFutureListener)this);
        return promise;
    }

    @Override
    public void write(int b) {
        if (this.buf == null) {
            this.alloc();
        } else if (!this.buf.isWritable()) {
            this.channel.write((Object)this.vIntBuffer(this.buf.writerIndex()), this.writePromise());
            this.channel.write((Object)this.buf, this.writePromise());
            this.alloc();
        }
        this.buf.writeByte(b);
    }

    private ByteBuf vIntBuffer(int value) {
        ByteBuf buffer = this.channel.alloc().buffer(ByteBufUtil.estimateVIntSize(value));
        ByteBufUtil.writeVInt(buffer, value);
        return buffer;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.buf == null) {
            if (len > 8192) {
                this.channel.write((Object)this.vIntBuffer(len), this.writePromise());
                this.channel.write((Object)Unpooled.wrappedBuffer((byte[])b, (int)off, (int)len), this.writePromise());
            } else {
                this.alloc();
                this.buf.writeBytes(b, off, len);
            }
            return;
        }
        if (len > this.buf.capacity()) {
            this.channel.write((Object)this.vIntBuffer(this.buf.writerIndex()), this.writePromise());
            this.channel.write((Object)this.buf, this.writePromise());
            this.buf = null;
            this.channel.write((Object)this.vIntBuffer(len), this.writePromise());
            this.channel.write((Object)Unpooled.wrappedBuffer((byte[])b, (int)off, (int)len), this.writePromise());
            return;
        }
        if (len > this.buf.writableBytes()) {
            int numWritten = this.buf.writableBytes();
            this.buf.writeBytes(b, off, numWritten);
            off += numWritten;
            len -= numWritten;
            this.channel.write((Object)this.vIntBuffer(this.buf.writerIndex()), this.writePromise());
            this.channel.write((Object)this.buf, this.writePromise());
            this.alloc();
        }
        this.buf.writeBytes(b, off, len);
    }

    @Override
    public void flush() {
        if (this.buf != null && this.buf.writerIndex() > 0) {
            this.channel.write((Object)this.vIntBuffer(this.buf.writerIndex()), this.writePromise());
            this.channel.writeAndFlush((Object)this.buf, this.writePromise());
            this.buf = null;
        } else {
            this.channel.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        ByteBuf terminal = this.channel.alloc().buffer(1);
        terminal.writeByte(0);
        this.channel.writeAndFlush((Object)terminal, this.writePromise());
        this.listener.onClose(this.channel);
    }

    public void operationComplete(Future<? super Void> future) {
        if (!future.isSuccess()) {
            this.listener.onError(this.channel, future.cause());
        }
    }
}

