/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.inchi;

import java.util.List;
import java.util.Map;
import javajs.util.BS;
import javajs.util.PT;
import org.iupac.InChIStructureProvider;
import org.iupac.InchiUtils;
import org.jmol.inchi.InchiJmol;
import org.jmol.viewer.Viewer;

public class InChIJS
extends InchiJmol {
    private String json;
    List<Map<String, Object>> atoms;
    List<Map<String, Object>> bonds;
    List<Map<String, Object>> stereo0d;
    private Map<String, Object> thisAtom;
    private Map<String, Object> thisBond;
    private Map<String, Object> thisStereo;

    @Override
    public String getInchi(Viewer vwr, BS atoms, Object molData, String options) {
        String ret = "";
        try {
            if (options.equals("version")) {
                // empty if block
            }
            if ((options = this.setParameters(options, molData, atoms, vwr)) == null) {
                return "";
            }
            if ((options = PT.rep(PT.rep(options.replace('-', ' '), "  ", " ").trim(), " ", " -").toLowerCase()).length() > 0) {
                options = "-" + options;
            }
            if (molData == null) {
                molData = vwr.getModelExtract(atoms, false, false, "MOL");
            }
            if (this.inputInChI) {
                if (this.doGetSmiles || this.getInchiModel) {
                    return this.doGetSmiles ? this.getSmiles(vwr, this.smilesOptions) : this.json;
                }
            } else {
                boolean haveKey;
                boolean bl = haveKey = options.indexOf("key") >= 0;
                if (haveKey) {
                    options = options.replace("inchikey", "key");
                }
            }
        }
        catch (Throwable e) {
            System.err.println("InChIJS exception: " + e);
        }
        return ret;
    }

    public void initializeModelForSmiles() {
    }

    public int getNumAtoms() {
        return 0;
    }

    public InChIStructureProvider setAtom(int i) {
        return this;
    }

    public String getElementType() {
        return this.getString(this.thisAtom, "elname", "");
    }

    public double getX() {
        return this.getDouble(this.thisAtom, "x", 0.0);
    }

    public double getY() {
        return this.getDouble(this.thisAtom, "y", 0.0);
    }

    public double getZ() {
        return this.getDouble(this.thisAtom, "z", 0.0);
    }

    public int getCharge() {
        return this.getInt(this.thisAtom, "charge", 0);
    }

    public int getImplicitH() {
        return this.getInt(this.thisAtom, "implicitH", 0);
    }

    public int getIsotopicMass() {
        String sym = this.getElementType();
        int mass = 0;
        return InchiUtils.getActualMass((String)sym, (int)mass);
    }

    public int getNumBonds() {
        return 0;
    }

    public InChIStructureProvider setBond(int i) {
        return this;
    }

    public int getIndexOriginAtom() {
        return this.getInt(this.thisBond, "originAtom", 0);
    }

    public int getIndexTargetAtom() {
        return this.getInt(this.thisBond, "targetAtom", 0);
    }

    public String getInchiBondType() {
        return this.getString(this.thisBond, "type", "");
    }

    public int getNumStereo0D() {
        return 0;
    }

    public InChIStructureProvider setStereo0D(int i) {
        return this;
    }

    public String getParity() {
        return this.getString(this.thisStereo, "parity", "");
    }

    public String getStereoType() {
        return this.getString(this.thisStereo, "type", "");
    }

    public int getCenterAtom() {
        return this.getInt(this.thisStereo, "centralAtom", -1);
    }

    public int[] getNeighbors() {
        return null;
    }

    private int getInt(Map<String, Object> map, String name, int defaultValue) {
        return defaultValue;
    }

    private double getDouble(Map<String, Object> map, String name, double defaultValue) {
        return defaultValue;
    }

    private String getString(Map<String, Object> map, String name, String defaultValue) {
        return defaultValue;
    }
}

