/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.forcefield.Calculation;

class MMFFSBCalc
extends Calculation {
    MMFFSBCalc() {
    }

    void setData(Lst<Object[]> calc, MinAngle angle) {
        if (this.calcs.isLinear(angle.data[1])) {
            return;
        }
        double[] data = (double[])this.calcs.getParameter(angle.sbKey);
        double[] datakat0 = (double[])this.calcs.getParameterObj(angle);
        double[] dataij = (double[])this.calcs.getParameter(this.calcs.minBonds[angle.data[3]]);
        double[] datajk = (double[])this.calcs.getParameter(this.calcs.minBonds[angle.data[4]]);
        if (data == null || datakat0 == null || dataij == null || datajk == null) {
            return;
        }
        double theta0 = datakat0[1];
        double r0ij = dataij[1];
        double r0jk = datajk[1];
        calc.addLast(new Object[]{angle.data, new double[]{data[0], theta0, r0ij}, angle.sbKey});
        calc.addLast(new Object[]{new int[]{angle.data[2], angle.data[1], angle.data[0]}, new double[]{data[1], theta0, r0jk}, angle.sbKey});
    }

    @Override
    double compute(Object[] dataIn) {
        this.key = (Integer)dataIn[2];
        this.getPointers(dataIn);
        double k = 2.5121 * this.dData[0];
        double t0 = this.dData[1];
        double r0_ab = this.dData[2];
        this.calcs.setPairVariables(this);
        this.calcs.setAngleVariables(this);
        double dr_ab = this.rab - r0_ab;
        this.delta = this.theta * 57.29577951308232 - t0;
        this.energy = k * dr_ab * this.delta;
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(3, this));
        }
        if (this.calcs.gradients) {
            this.dE = k * dr_ab;
            this.calcs.addForces(this, 3);
            this.calcs.setPairVariables(this);
            this.dE = k * this.delta;
            this.calcs.addForces(this, 2);
        }
        return this.energy;
    }
}

