/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This filter sharpens an image using a Laplacian. LaplacianSharpening
highlights regions of rapid intensity change and therefore highlights
or enhances the edges. The result is an image that appears more in
focus.


The LaplacianSharpening at each pixel location is computed by
convolution with the itk::LaplacianOperator .
Inputs and Outputs
The input to this filter is a scalar-valued itk::Image of arbitrary dimension. The output is a scalar-valued itk::Image .

See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

 LaplacianOperator

 itk::simple::LaplacianSharpening for the procedural interface

 itk::LaplacianSharpeningImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLaplacianSharpeningImageFilter.h
*/
public class LaplacianSharpeningImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LaplacianSharpeningImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LaplacianSharpeningImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LaplacianSharpeningImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LaplacianSharpeningImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LaplacianSharpeningImageFilter::~LaplacianSharpeningImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LaplacianSharpeningImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LaplacianSharpeningImageFilter::LaplacianSharpeningImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LaplacianSharpeningImageFilter() {
    this(SimpleITKJNI.new_LaplacianSharpeningImageFilter(), true);
  }

  /**
Self&amp; itk::simple::LaplacianSharpeningImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get whether or not the filter will use the spacing information of
the input image in its calculations. Use this option if derivatives
are required in physical space.

*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.LaplacianSharpeningImageFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::LaplacianSharpeningImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.LaplacianSharpeningImageFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LaplacianSharpeningImageFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.LaplacianSharpeningImageFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::LaplacianSharpeningImageFilter::GetUseImageSpacing() const

Set/Get whether or not the filter will use the spacing information of
the input image in its calculations. Use this option if derivatives
are required in physical space.

*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.LaplacianSharpeningImageFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
std::string itk::simple::LaplacianSharpeningImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LaplacianSharpeningImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LaplacianSharpeningImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LaplacianSharpeningImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::LaplacianSharpeningImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.LaplacianSharpeningImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
