#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 snap-core
version:              1.0.5.1
visibility:           public
id:                   snap-core-1.0.5.1-BP8n8ku8DOJ5UoUzZWrCtv
key:                  snap-core-1.0.5.1-BP8n8ku8DOJ5UoUzZWrCtv
license:              BSD-3-Clause
maintainer:           snap@snapframework.com
author:               Snap Framework Authors (see CONTRIBUTORS)
homepage:             http://snapframework.com/
synopsis:             Snap: A Haskell Web Framework (core interfaces and types)
description:
    Snap is a simple and fast web development framework and server written in
    Haskell. For more information or to download the latest version, you can
    visit the Snap project website at <http://snapframework.com/>.

    This library contains the core definitions and types for the Snap framework,
    including:

    1. Primitive types and functions for HTTP (requests, responses, cookies,
    post/query parameters, etc)

    2. A monad for programming web handlers called \"Snap\", which allows:

    * Stateful access to the HTTP request and response objects

    * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
    to handle requests and chaining handlers together

    * Early termination of the computation if you know early what you want
    to return and want to prevent further monadic processing

    /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core".

category:             Web, Snap, IO-Streams
abi:                  fc58097ae4629ea56ebaf107066597fb
exposed:              True
exposed-modules:
    Snap.Core Snap.Internal.Core Snap.Internal.Debug
    Snap.Internal.Http.Types Snap.Internal.Parsing
    Snap.Internal.Util.FileServe Snap.Test Snap.Types.Headers
    Snap.Util.CORS Snap.Util.FileServe Snap.Util.FileUploads
    Snap.Util.GZip Snap.Util.Proxy

hidden-modules:
    Snap.Internal.Instances Snap.Internal.Routing
    Snap.Internal.Test.RequestBuilder Snap.Internal.Test.Assertions
    Snap.Internal.Util.FileUploads

import-dirs:          /usr/lib/ghc-9.6.6/site-local/snap-core-1.0.5.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/snap-core-1.0.5.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/snap-core-1.0.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-snap-core
hs-libraries:         HSsnap-core-1.0.5.1-BP8n8ku8DOJ5UoUzZWrCtv
depends:
    HUnit-1.6.2.0-DydRkK1Ty562EFYgxreweA
    attoparsec-0.14.4-FIfeiNzOKYm3sEc1QPF51Z base-4.18.2.1
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-HFTLAepm1u61gRs0sAANH
    containers-0.6.7 directory-1.3.8.5 filepath-1.4.300.1
    hashable-1.4.7.0-LE3bCdm1Wgy6IgVYkRoAlQ
    io-streams-1.5.2.2-Fu0yXFNFykK48vHTxDZPZi
    lifted-base-0.2.3.12-2iTkngyrdjxFbaCyw0Ft3U
    monad-control-1.0.3.1-Cu2gag9g9XfDkjDNf9i6xZ mtl-2.3.1
    network-3.1.4.0-LsWsY6caX6uCNLTGwySDR3
    network-uri-2.6.4.2-3U0FvLc2coZ6tqjF5PGDly
    old-locale-1.0.0.7-Gunit3UBy5P9OGDVFY5MhC
    random-1.2.1.3-HzFGhfPSv5b3eeTVe0g48p
    readable-0.3.1-OTyE2OgXqD6GxjciePDxk
    regex-posix-0.96.0.2-LsCmj8tXKerCmkZ6TKO5qF text-2.0.2 time-1.12.2
    transformers-0.6.1.0 transformers-base-0.4.6-EvxeInxseF6GyjY0h0BJce
    unix-compat-0.7.4.1-DqDzbwuaouv1yXLtKQLq3q
    unordered-containers-0.2.20.1-I6eyTXb69D2BhxejMtPouo
    vector-0.13.2.0-KFVS0U8K6eML5O0P7tVbRi

haddock-interfaces:   /usr/share/doc/haskell-snap-core/html/snap-core.haddock
haddock-html:         /usr/share/doc/haskell-snap-core/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

