/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Supplier;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.enterprise.GradleEnterprisePluginCheckInResult;
import org.gradle.internal.enterprise.GradleEnterprisePluginCheckInService;
import org.gradle.internal.enterprise.GradleEnterprisePluginMetadata;
import org.gradle.internal.enterprise.GradleEnterprisePluginServiceFactory;
import org.gradle.internal.enterprise.GradleEnterprisePluginServiceRef;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginAdapter;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginManager;
import org.gradle.internal.enterprise.impl.DefaultGradleEnterprisePluginAdapter;
import org.gradle.internal.enterprise.impl.DefaultGradleEnterprisePluginAdapterFactory;
import org.gradle.internal.enterprise.impl.legacy.DevelocityPluginCompatibility;
import org.gradle.util.internal.VersionNumber;
import org.jspecify.annotations.Nullable;

public class DefaultGradleEnterprisePluginCheckInService
implements GradleEnterprisePluginCheckInService {
    private final GradleEnterprisePluginManager manager;
    private final DefaultGradleEnterprisePluginAdapterFactory pluginAdapterFactory;
    private final boolean isConfigurationCacheEnabled;
    private final boolean isIsolatedProjectsEnabled;
    @VisibleForTesting
    public static final String UNSUPPORTED_TOGGLE = "org.gradle.internal.unsupported-develocity-plugin";
    @VisibleForTesting
    public static final String UNSUPPORTED_TOGGLE_MESSAGE = "Develocity plugin unsupported due to secret toggle";
    private static final String DISABLE_TEST_ACCELERATION_PROPERTY = "gradle.internal.testacceleration.disableImplicitApplication";
    private static final VersionNumber AUTO_DISABLE_TEST_ACCELERATION_SINCE_VERSION = VersionNumber.parse((String)"3.14");

    public DefaultGradleEnterprisePluginCheckInService(BuildModelParameters buildModelParameters, GradleEnterprisePluginManager manager, DefaultGradleEnterprisePluginAdapterFactory pluginAdapterFactory) {
        this.manager = manager;
        this.pluginAdapterFactory = pluginAdapterFactory;
        this.isConfigurationCacheEnabled = buildModelParameters.isConfigurationCache();
        this.isIsolatedProjectsEnabled = buildModelParameters.isIsolatedProjects();
    }

    @Override
    public GradleEnterprisePluginCheckInResult checkIn(GradleEnterprisePluginMetadata pluginMetadata, GradleEnterprisePluginServiceFactory serviceFactory) {
        String pluginVersion = pluginMetadata.getVersion();
        VersionNumber pluginBaseVersion = VersionNumber.parse((String)pluginVersion).getBaseVersion();
        if (Boolean.getBoolean(UNSUPPORTED_TOGGLE)) {
            return this.checkInUnsupportedResult(pluginBaseVersion, UNSUPPORTED_TOGGLE_MESSAGE);
        }
        if (DevelocityPluginCompatibility.isUnsupportedPluginVersion(pluginBaseVersion)) {
            return this.checkInUnsupportedResult(pluginBaseVersion, DevelocityPluginCompatibility.getUnsupportedPluginMessage(pluginVersion));
        }
        if (this.isIsolatedProjectsEnabled && DevelocityPluginCompatibility.isUnsupportedWithIsolatedProjects(pluginBaseVersion)) {
            return this.checkInUnsupportedResult(pluginBaseVersion, DevelocityPluginCompatibility.getUnsupportedWithIsolatedProjectsMessage(pluginVersion));
        }
        DefaultGradleEnterprisePluginAdapter adapter = this.pluginAdapterFactory.create(serviceFactory);
        GradleEnterprisePluginServiceRef ref = adapter.getPluginServiceRef();
        this.manager.registerAdapter((GradleEnterprisePluginAdapter)adapter);
        return DefaultGradleEnterprisePluginCheckInService.checkInResult(null, () -> ref);
    }

    private GradleEnterprisePluginCheckInResult checkInUnsupportedResult(VersionNumber pluginBaseVersion, String unsupportedMessage) {
        if (this.isConfigurationCacheEnabled && !DefaultGradleEnterprisePluginCheckInService.supportsAutoDisableTestAcceleration(pluginBaseVersion)) {
            System.setProperty(DISABLE_TEST_ACCELERATION_PROPERTY, "true");
        }
        this.manager.unsupported();
        return DefaultGradleEnterprisePluginCheckInService.checkInResult(unsupportedMessage, () -> {
            throw new IllegalStateException();
        });
    }

    private static boolean supportsAutoDisableTestAcceleration(VersionNumber pluginBaseVersion) {
        return AUTO_DISABLE_TEST_ACCELERATION_SINCE_VERSION.compareTo(pluginBaseVersion) <= 0;
    }

    private static GradleEnterprisePluginCheckInResult checkInResult(final @Nullable String unsupportedMessage, final Supplier<GradleEnterprisePluginServiceRef> pluginServiceRefSupplier) {
        return new GradleEnterprisePluginCheckInResult(){

            @Override
            public @Nullable String getUnsupportedMessage() {
                return unsupportedMessage;
            }

            @Override
            public GradleEnterprisePluginServiceRef getPluginServiceRef() {
                return (GradleEnterprisePluginServiceRef)pluginServiceRefSupplier.get();
            }
        };
    }
}

