/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.LongFunction;
import javax.inject.Inject;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.tasks.testing.DefaultRootTestEventReporter;
import org.gradle.api.internal.tasks.testing.DefaultTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.GroupTestEventReporterInternal;
import org.gradle.api.internal.tasks.testing.LifecycleTrackingGroupTestEventReporter;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestEventReporterFactoryInternal;
import org.gradle.api.internal.tasks.testing.TestReportGenerator;
import org.gradle.api.internal.tasks.testing.logging.SimpleTestEventLogger;
import org.gradle.api.internal.tasks.testing.logging.TestEventProgressListener;
import org.gradle.api.internal.tasks.testing.report.generic.GenericHtmlTestReportGenerator;
import org.gradle.api.internal.tasks.testing.results.TestExecutionResultsListener;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResultStore;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.testing.GroupTestEventReporter;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.event.AnonymousListenerBroadcast;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class DefaultTestEventReporterFactory
implements TestEventReporterFactoryInternal {
    private final ListenerManager listenerManager;
    private final StyledTextOutputFactory textOutputFactory;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final ObjectFactory objectFactory;

    @Inject
    public DefaultTestEventReporterFactory(ListenerManager listenerManager, StyledTextOutputFactory textOutputFactory, ProgressLoggerFactory progressLoggerFactory, ObjectFactory objectFactory) {
        this.listenerManager = listenerManager;
        this.textOutputFactory = textOutputFactory;
        this.progressLoggerFactory = progressLoggerFactory;
        this.objectFactory = objectFactory;
    }

    @Override
    public GroupTestEventReporter createTestEventReporter(String rootName, Directory binaryResultsDirectory, Directory htmlReportDirectory, boolean closeThrowsOnTestFailures) {
        AnonymousListenerBroadcast testListenerInternalBroadcaster = this.listenerManager.createAnonymousBroadcaster(TestListenerInternal.class);
        testListenerInternalBroadcaster.add((Object)new SimpleTestEventLogger(this.textOutputFactory));
        testListenerInternalBroadcaster.add((Object)new TestEventProgressListener(this.progressLoggerFactory));
        GenericHtmlTestReportGenerator reportGenerator = (GenericHtmlTestReportGenerator)this.objectFactory.newInstance(GenericHtmlTestReportGenerator.class, new Object[]{htmlReportDirectory.getAsFile().toPath()});
        return this.createInternalTestEventReporter(id -> new DefaultTestSuiteDescriptor((Object)id, rootName), binaryResultsDirectory, reportGenerator, (ListenerBroadcast<TestListenerInternal>)testListenerInternalBroadcaster, 0, closeThrowsOnTestFailures, true);
    }

    @Override
    public GroupTestEventReporterInternal createInternalTestEventReporter(LongFunction<TestDescriptorInternal> rootDescriptorFactory, Directory binaryResultsDirectory, @Nullable TestReportGenerator reportGenerator, ListenerBroadcast<TestListenerInternal> testListenerInternalBroadcaster, int diskSkipLevels, boolean closeThrowsOnTestFailures, boolean addToAggregateReports) {
        SerializableTestResultStore.Writer resultsSerializingListener;
        Path binaryResultsDir = binaryResultsDirectory.getAsFile().toPath();
        try {
            resultsSerializingListener = new SerializableTestResultStore(binaryResultsDir).openWriter(diskSkipLevels);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        testListenerInternalBroadcaster.add((Object)resultsSerializingListener);
        TestListenerInternal testListenerBroadcaster = (TestListenerInternal)testListenerInternalBroadcaster.getSource();
        TestExecutionResultsListener executionResultsListenerBroadcaster = (TestExecutionResultsListener)this.listenerManager.getBroadcaster(TestExecutionResultsListener.class);
        return new LifecycleTrackingGroupTestEventReporter(new DefaultRootTestEventReporter(rootDescriptorFactory, testListenerBroadcaster, (IdGenerator<Long>)new LongIdGenerator(), binaryResultsDir, resultsSerializingListener, reportGenerator, executionResultsListenerBroadcaster, closeThrowsOnTestFailures, addToAggregateReports));
    }
}

