/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.javaclass.format.attributes.AnnotationElementValuePair;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class AnnotationJava
implements StructConverter {
    private short typeIndex;
    private short numberOfElementValuePairs;
    private AnnotationElementValuePair[] elementValuePairs;

    public AnnotationJava(BinaryReader reader) throws IOException {
        this.typeIndex = reader.readNextShort();
        this.numberOfElementValuePairs = reader.readNextShort();
        this.elementValuePairs = new AnnotationElementValuePair[this.getNumberOfElementValuePairs()];
        for (int i = 0; i < this.getNumberOfElementValuePairs(); ++i) {
            this.elementValuePairs[i] = new AnnotationElementValuePair(reader);
        }
    }

    public int getTypeIndex() {
        return this.typeIndex & 0xFFFF;
    }

    public int getNumberOfElementValuePairs() {
        return this.numberOfElementValuePairs & 0xFFFF;
    }

    public AnnotationElementValuePair[] getElementValuePairs() {
        return this.elementValuePairs;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "annotation|" + this.numberOfElementValuePairs + "|";
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add(WORD, "type_index", null);
        structure.add(WORD, "num_element_value_pairs", null);
        for (int i = 0; i < this.elementValuePairs.length; ++i) {
            structure.add(this.elementValuePairs[i].toDataType(), "element_value_pair_" + i, null);
        }
        return structure;
    }
}

