/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.hover.DecompilerHoverService;
import ghidra.app.plugin.core.hover.AbstractScalarOperandHover;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.util.ProgramLocation;
import javax.swing.JComponent;

public class ScalarValueDecompilerHover
extends AbstractScalarOperandHover
implements DecompilerHoverService {
    private static final int PRIORITY = 30;
    private static final String NAME = "Scalar Operand Display";
    private static final String DESCRIPTION = "Scalars are shown as 1-, 2-, 4-, and 8-byte values, each in decimal, hexadecimal, and as ASCII character sequences.";

    public ScalarValueDecompilerHover(PluginTool tool) {
        super(tool, 30);
    }

    protected String getName() {
        return NAME;
    }

    protected String getDescription() {
        return DESCRIPTION;
    }

    protected String getOptionsCategory() {
        return "Decompiler Popups";
    }

    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        if (!this.enabled) {
            return null;
        }
        if (!(field instanceof ClangTextField)) {
            return null;
        }
        ClangToken token = ((ClangTextField)field).getToken(fieldLocation);
        Scalar scalar = token.getScalar();
        if (scalar == null) {
            return null;
        }
        Address addr = token.getMinAddress();
        String formatted = this.formatScalar(program, addr, scalar);
        return this.createTooltipComponent(formatted);
    }
}

