/*
 * Decompiled with CFR 0.152.
 */
package ghidra.net;

import ghidra.net.DefaultSSLContextInitializer;
import ghidra.util.Msg;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class DefaultSSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory socketFactory;

    public DefaultSSLSocketFactory() {
        SSLSocketFactory factory = null;
        try {
            if (DefaultSSLContextInitializer.initialize()) {
                factory = SSLContext.getDefault().getSocketFactory();
            }
        }
        catch (NoSuchAlgorithmException e) {
            Msg.error((Object)this, (Object)("Failed to employ default SSLContext: " + e.toString()), (Throwable)e);
        }
        this.socketFactory = factory != null ? factory : (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.socketFactory.createSocket(s, host, port, autoClose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.socketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.socketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.socketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.socketFactory.createSocket(address, port, localAddress, localPort);
    }
}

