/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.session;

import docking.wizard.WizardModel;
import docking.wizard.WizardStep;
import ghidra.feature.vt.gui.wizard.session.NewSessionData;
import ghidra.feature.vt.gui.wizard.session.PreconditionsPanel;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import javax.swing.JComponent;

public class PreconditionsStep
extends WizardStep<NewSessionData> {
    private PreconditionsPanel preconditionsPanel;

    protected PreconditionsStep(WizardModel<NewSessionData> model) {
        super(model, "Precondition Checklist", new HelpLocation("VersionTrackingPlugin", "Preconditions_Panel"));
        this.preconditionsPanel = new PreconditionsPanel(model, () -> this.notifyStatusChanged());
    }

    public void initialize(NewSessionData data) {
        if (!data.hasPerformedPreconditionChecks()) {
            Program sourceProgram = data.getSourceProgram();
            Program destinationProgram = data.getDestinationProgram();
            this.preconditionsPanel.initializeTests(sourceProgram, destinationProgram);
        }
    }

    public boolean isValid() {
        boolean hasRunTests = this.preconditionsPanel.hasRunTests();
        return hasRunTests;
    }

    public void populateData(NewSessionData data) {
        data.setPerformedPreconditionChecks(true);
    }

    public boolean apply(NewSessionData data) {
        return true;
    }

    public boolean canFinish(NewSessionData data) {
        return data.hasPerformedPreconditionChecks();
    }

    public JComponent getComponent() {
        return this.preconditionsPanel;
    }

    protected void dispose(NewSessionData data) {
        this.preconditionsPanel.dispose();
    }
}

