/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.ContextSpecificAction;
import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.framework.main.datatable.ProjectTreeContext;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.LinkFileInfo;
import ghidra.framework.model.LinkedDomainFolder;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import javax.swing.Icon;

public class ProjectDataNewFolderAction<T extends ProjectTreeContext>
extends ContextSpecificAction<T> {
    private static final Icon ICON = new GIcon("icon.projectdata.new.folder");

    public ProjectDataNewFolderAction(String owner, String group, Class<T> contextClass) {
        super("New Folder", owner, contextClass);
        this.setPopupMenuData(new MenuData(new String[]{"New Folder"}, ICON, group));
        this.markHelpUnnecessary();
    }

    protected void actionPerformed(T context) {
        this.createNewFolder(context);
    }

    protected boolean isEnabledForContext(T context) {
        try {
            return this.getFolder(context).isInWritableProject();
        }
        catch (IOException e) {
            return false;
        }
    }

    private void createNewFolder(T context) {
        DomainFolder newFolder = this.createNewFolderWithDefaultName(context);
        GTreeNode parent = this.getParentNode(context);
        DataTree tree = context.getTree();
        tree.setEditable(true);
        tree.startEditing(parent, newFolder.getName());
    }

    private DomainFolder createNewFolderWithDefaultName(T context) {
        Object errName = "";
        try {
            DomainFolder parentFolder = this.getFolder(context);
            String name = this.getNewFolderName(parentFolder);
            errName = ": " + name;
            return parentFolder.createFolder(name);
        }
        catch (InvalidNameException | IOException e) {
            throw new AssertException("Unexpected Error creating new folder" + (String)errName, e);
        }
    }

    private String getNewFolderName(DomainFolder parent) {
        String baseName = "NewFolder";
        Object name = baseName;
        int suffix = 1;
        while (parent.getFolder((String)name) != null) {
            name = baseName + ++suffix;
        }
        return name;
    }

    private DomainFolder getFolder(T context) throws IOException {
        DomainFolder folder = null;
        if (context.getFolderCount() == 1 && context.getFileCount() == 0) {
            folder = context.getSelectedFolders().get(0);
        } else if (context.getFileCount() == 1 && context.getFolderCount() == 0) {
            DomainFile file = context.getSelectedFiles().get(0);
            LinkFileInfo linkInfo = file.getLinkInfo();
            folder = linkInfo != null && linkInfo.isFolderLink() ? linkInfo.getLinkedFolder() : file.getParent();
        }
        if (folder instanceof LinkedDomainFolder) {
            LinkedDomainFolder linkedFolder = (LinkedDomainFolder)folder;
            folder = linkedFolder.getRealFolder();
        }
        if (folder == null) {
            DomainFolderNode rootNode = (DomainFolderNode)context.getTree().getModelRoot();
            folder = rootNode.getDomainFolder();
        }
        return folder;
    }

    private GTreeNode getParentNode(T context) {
        DomainFileNode fileNode;
        GTreeNode node = context.getContextNode();
        if (node == null) {
            return context.getTree().getModelRoot();
        }
        if (node instanceof DomainFileNode && !(fileNode = (DomainFileNode)node).isFolderLink()) {
            return node.getParent();
        }
        return node;
    }
}

