/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.ingest;

import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.features.bsim.query.BSimClientFactory;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.ingest.BulkSignatures;
import ghidra.features.bsim.query.ingest.HeadlessBSimApplicationConfiguration;
import ghidra.features.bsim.query.protocol.ExeSpecifier;
import ghidra.features.bsim.query.protocol.QueryName;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.HeadlessGhidraApplicationConfiguration;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.HeadlessClientAuthenticator;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.protocol.ghidra.Handler;
import ghidra.net.DefaultSSLContextInitializer;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;
import utility.application.ApplicationLayout;

public class BSimLaunchable
implements GhidraLaunchable {
    private static final String BSIM_LOGGING_CONFIGURATION_FILE = "bsim.log4j.xml";
    private static final int DEFAULT_LIST_EXE_LIMIT = 20;
    private static final Set<String> COMMAND_SET = new HashSet<String>();
    private static final String COMMAND_CREATE_DATABASE = BSimLaunchable.defineCommand("createdatabase");
    private static final String COMMAND_SET_METADATA = BSimLaunchable.defineCommand("setmetadata");
    private static final String COMMAND_GET_METADATA = BSimLaunchable.defineCommand("getmetadata");
    private static final String COMMAND_ADD_EXE_CATEGORY = BSimLaunchable.defineCommand("addexecategory");
    private static final String COMMAND_ADD_FUNCTION_TAG = BSimLaunchable.defineCommand("addfunctiontag");
    private static final String COMMAND_DROP_INDEX = BSimLaunchable.defineCommand("dropindex");
    private static final String COMMAND_REBUILD_INDEX = BSimLaunchable.defineCommand("rebuildindex");
    private static final String COMMAND_PREWARM = BSimLaunchable.defineCommand("prewarm");
    private static final String COMMAND_GENERATE_SIGS = BSimLaunchable.defineCommand("generatesigs");
    private static final String COMMAND_COMMIT_SIGS = BSimLaunchable.defineCommand("commitsigs");
    private static final String COMMAND_GENERATE_UPDATES = BSimLaunchable.defineCommand("generateupdates");
    private static final String COMMAND_COMMIT_UPDATES = BSimLaunchable.defineCommand("commitupdates");
    private static final String COMMAND_DELETE = BSimLaunchable.defineCommand("delete");
    private static final String COMMAND_LIST_FUNCTIONS = BSimLaunchable.defineCommand("listfuncs");
    private static final String COMMAND_LIST_EXES = BSimLaunchable.defineCommand("listexes");
    private static final String COMMAND_GET_EXE_COUNT = BSimLaunchable.defineCommand("getexecount");
    private static final String COMMAND_DUMP_SIGS = BSimLaunchable.defineCommand("dumpsigs");
    private static Set<String> COMMANDS_WITH_REPO_ACCESS = Set.of(COMMAND_GENERATE_SIGS, COMMAND_GENERATE_UPDATES);
    private static final String BSIM_URL_OPTION = "--bsim";
    private static final String NAME_OPTION = "--name";
    private static final String OWNER_OPTION = "--owner";
    private static final String DESCRIPTION_OPTION = "--description";
    private static final String OVERRIDE_OPTION = "--override";
    private static final String CONFIG_OPTION = "--config";
    private static final String MD5_OPTION = "--md5";
    private static final String MAX_FUNC_OPTION = "--maxfunc";
    private static final String ARCH_OPTION = "--arch";
    private static final String COMPILER_OPTION = "--compiler";
    private static final String LIMIT_OPTION = "--limit";
    private static final String SORT_COL_OPTION = "--sortcol";
    private static final String USER_OPTION = "--user";
    private static final String CERT_OPTION = "--cert";
    private static final Set<String> VALUE_OPTIONS = Set.of("--user", "--cert", "--bsim", "--name", "--owner", "--description", "--override", "--config", "--md5", "--maxfunc", "--arch", "--compiler", "--limit", "--sortcol");
    private static final Set<String> GLOBAL_OPTIONS = Set.of("--cert", "--user");
    private static final String COMMIT_OPTION = "--commit";
    private static final String CATEGORY_DATE_OPTION = "--date";
    private static final String NO_CALLGRAPH_OPTION = "--nocallgraph";
    private static final String OVERWRITE_OPTION = "--overwrite";
    private static final String INCLUDE_LIBS_OPTION = "--includelibs";
    private static final String PRINT_SELF_SIGNIFICANCE_OPTION = "--printselfsig";
    private static final String CALL_GRAPH_OPTION = "--callgraph";
    private static final String PRINT_JUST_EXE_OPTION = "--printjustexe";
    private static final Map<String, String> SHORTCUT_OPTION_MAP = new HashMap<String, String>();
    private static final Set<String> CREATE_DATABASE_OPTIONS;
    private static final Set<String> COMMIT_SIGS_OPTIONS;
    private static final Set<String> COMMIT_UPDATES_OPTIONS;
    private static final Set<String> DELETE_OPTIONS;
    private static final Set<String> DROP_INDEX_OPTIONS;
    private static final Set<String> REBUILD_INDEX_OPTIONS;
    private static final Set<String> PREWARM_OPTIONS;
    private static final Set<String> SET_METADATA_OPTIONS;
    private static final Set<String> GET_METADATA_OPTIONS;
    private static final Set<String> ADD_EXE_CATEGORY_OPTIONS;
    private static final Set<String> ADD_FUNCTION_TAG_OPTIONS;
    private static final Set<String> DUMP_SIGS_OPTIONS;
    private static final Set<String> GENERATE_SIGS_OPTIONS;
    private static final Set<String> GENERATE_UPDATES_OPTIONS;
    private static final Set<String> LIST_FUNCTIONS_OPTIONS;
    private static final Set<String> GET_EXECUTABLES_OPTIONS;
    private static final Set<String> GET_EXECUTABLES_COUNT_OPTIONS;
    private static final Map<String, Set<String>> ALLOWED_OPTION_MAP;
    private URL ghidraURL;
    private URL bsimURL;
    private Map<String, String> optionValueMap = new HashMap<String, String>();
    private Set<String> booleanOptions = new HashSet<String>();
    private GhidraApplicationLayout layout;

    private static String defineCommand(String command) {
        COMMAND_SET.add(command);
        return command;
    }

    private void clearParams() {
        this.ghidraURL = null;
        this.bsimURL = null;
        this.booleanOptions.clear();
        this.optionValueMap.clear();
    }

    private BulkSignatures getBulkSignatures() throws IllegalArgumentException, MalformedURLException {
        BSimServerInfo serverInfo = null;
        if (this.bsimURL != null) {
            serverInfo = new BSimServerInfo(this.bsimURL);
        }
        String connectingUserName = this.optionValueMap.get(USER_OPTION);
        return new BulkSignatures(serverInfo, connectingUserName);
    }

    private void setupGhidraURL(String ghidraURLString) throws MalformedURLException {
        if (ghidraURLString == null) {
            return;
        }
        if (!GhidraURL.isGhidraURL((String)ghidraURLString)) {
            throw new MalformedURLException("URL is not ghidra protocol: " + ghidraURLString);
        }
        this.ghidraURL = new URL(ghidraURLString);
        if (!GhidraURL.isServerRepositoryURL((URL)this.ghidraURL) && !GhidraURL.isLocalProjectURL((URL)this.ghidraURL)) {
            throw new MalformedURLException("Invalid repository URL: " + ghidraURLString);
        }
    }

    private void setupURLs(String ghidraURLString, String bsimURLString) throws MalformedURLException {
        if (ghidraURLString != null) {
            this.setupGhidraURL((String)ghidraURLString);
        }
        if (bsimURLString != null) {
            this.bsimURL = BSimClientFactory.deriveBSimURL(bsimURLString);
            if (this.ghidraURL == null) {
                if ("file".equals(this.bsimURL.getProtocol())) {
                    throw new IllegalArgumentException("Unable to infer ghidra URL from BSim file DB URL");
                }
                ghidraURLString = "ghidra://" + this.bsimURL.getHost() + this.bsimURL.getPath();
                this.setupGhidraURL((String)ghidraURLString);
            }
        } else if (ghidraURLString != null) {
            this.bsimURL = BSimClientFactory.deriveBSimURL((String)ghidraURLString);
        }
    }

    private List<String> readOptions(String command, String[] params, int discard) {
        boolean sawOptions = false;
        Set<String> allowedParams = ALLOWED_OPTION_MAP.get(command);
        if (allowedParams == null) {
            throw new IllegalArgumentException("Unsupported command: " + command);
        }
        ArrayList<String> subParams = new ArrayList<String>();
        for (int i = discard; i < params.length; ++i) {
            int ix;
            String optionName = params[i];
            String value = null;
            if (optionName.startsWith("-") && (ix = optionName.indexOf("=")) > 1) {
                value = optionName.substring(ix + 1);
                optionName = optionName.substring(0, ix);
            }
            String option = optionName;
            if (optionName.startsWith("-") && !optionName.startsWith("--") && (option = SHORTCUT_OPTION_MAP.get(optionName)) == null) {
                throw new IllegalArgumentException("Unsupported option use: " + optionName);
            }
            if (!option.startsWith("--")) {
                if (sawOptions) {
                    throw new IllegalArgumentException("Unexpected argument: " + option);
                }
                subParams.add(params[i]);
                continue;
            }
            sawOptions = true;
            if (!GLOBAL_OPTIONS.contains(option) && !allowedParams.contains(option)) {
                throw new IllegalArgumentException("Unsupported option use: " + optionName);
            }
            if (!VALUE_OPTIONS.contains(option)) {
                if (value != null) {
                    throw new IllegalArgumentException("Unsupported option specification: " + optionName + "=");
                }
                this.booleanOptions.add(option);
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)value)) {
                this.optionValueMap.put(option, value);
                continue;
            }
            if (++i == params.length) {
                throw new IllegalArgumentException("Missing option value: " + optionName);
            }
            this.optionValueMap.put(option, params[i]);
        }
        return subParams;
    }

    private void checkRequiredParam(String[] params, int index, String name) {
        if (params.length <= index) {
            throw new IllegalArgumentException("Missing required parameter: " + name);
        }
        String p = params[index];
        if (p.startsWith("--") || p.contains("=")) {
            throw new IllegalArgumentException("Missing required parameter (" + name + ") before specified option: " + p);
        }
    }

    private Integer parsePositiveIntegerOption(String option) {
        String optionValue = this.optionValueMap.get(option);
        if (optionValue == null) {
            return null;
        }
        try {
            int value = Integer.valueOf(optionValue);
            if (value < 0) {
                throw new IllegalArgumentException("Negative value not permitted for " + option);
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid integer value specified for " + option);
        }
    }

    public void run(String[] params, TaskMonitor monitor) throws Exception, CancelledException {
        this.clearParams();
        this.checkRequiredParam(params, 0, "command");
        String command = params[0];
        if (!COMMAND_SET.contains(command)) {
            throw new IllegalArgumentException("Missing or invalid command specified");
        }
        this.checkRequiredParam(params, 1, "URL");
        String urlstring = params[1];
        monitor.setCancelEnabled(true);
        List<String> subParams = this.readOptions(command, params, 2);
        this.initializeApplication(command);
        if (COMMAND_CREATE_DATABASE.equals(command)) {
            this.bsimURL = BSimClientFactory.deriveBSimURL(urlstring);
            this.doCreateDatabase(subParams);
        } else if (COMMAND_SET_METADATA.equals(command)) {
            this.bsimURL = BSimClientFactory.deriveBSimURL(urlstring);
            this.doInstallMetadata(subParams);
        } else if (COMMAND_GET_METADATA.equals(command)) {
            this.bsimURL = BSimClientFactory.deriveBSimURL(urlstring);
            this.doPrintMetadata(subParams);
        } else if (COMMAND_ADD_EXE_CATEGORY.equals(command)) {
            this.bsimURL = BSimClientFactory.deriveBSimURL(urlstring);
            this.doInstallCategory(subParams);
        } else if (COMMAND_ADD_FUNCTION_TAG.equals(command)) {
            this.bsimURL = BSimClientFactory.deriveBSimURL(urlstring);
            this.doInstallTags(subParams);
        } else if (COMMAND_DROP_INDEX.equals(command)) {
            this.bsimURL = BSimClientFactory.deriveBSimURL(urlstring);
            this.doDropIndex(subParams);
        } else if (COMMAND_REBUILD_INDEX.equals(command)) {
            this.bsimURL = BSimClientFactory.deriveBSimURL(urlstring);
            this.doRebuildIndex(subParams);
        } else if (COMMAND_PREWARM.equals(command)) {
            this.bsimURL = BSimClientFactory.deriveBSimURL(urlstring);
            this.doPrewarm(subParams);
        } else if (COMMAND_GENERATE_SIGS.equals(command)) {
            this.processSigAndUpdateOptions(urlstring);
            this.doGenerateSigs(subParams, monitor);
        } else if (COMMAND_COMMIT_SIGS.equals(command)) {
            String ghidraURLOverride = this.optionValueMap.get(OVERRIDE_OPTION);
            if (ghidraURLOverride != null) {
                this.setupURLs(ghidraURLOverride, urlstring);
            } else {
                this.bsimURL = BSimClientFactory.deriveBSimURL(urlstring);
            }
            this.doCommitSigs(subParams, monitor);
        } else if (COMMAND_GENERATE_UPDATES.equals(command)) {
            this.processSigAndUpdateOptions(urlstring);
            this.doGenerateUpdates(subParams, monitor);
        } else if (COMMAND_COMMIT_UPDATES.equals(command)) {
            this.bsimURL = BSimClientFactory.deriveBSimURL(urlstring);
            this.doCommitUpdates(subParams);
        } else if (COMMAND_DELETE.equals(command)) {
            this.bsimURL = BSimClientFactory.deriveBSimURL(urlstring);
            this.doDeleteExecutable(subParams);
        } else if (COMMAND_LIST_FUNCTIONS.equals(command)) {
            this.bsimURL = BSimClientFactory.deriveBSimURL(urlstring);
            this.doListFunctions(subParams);
        } else if (COMMAND_LIST_EXES.equals(command)) {
            this.bsimURL = BSimClientFactory.deriveBSimURL(urlstring);
            this.doListExes(subParams);
        } else if (COMMAND_GET_EXE_COUNT.equals(command)) {
            this.bsimURL = BSimClientFactory.deriveBSimURL(urlstring);
            this.doGetCount(subParams);
        } else if (COMMAND_DUMP_SIGS.equals(command)) {
            this.bsimURL = BSimClientFactory.deriveBSimURL(urlstring);
            this.doDumpSigs(subParams);
        } else {
            throw new IllegalArgumentException("Unknown command: " + command);
        }
    }

    private void processSigAndUpdateOptions(String urlstring) throws MalformedURLException {
        String bsimURLOption = this.optionValueMap.get(BSIM_URL_OPTION);
        String configOption = this.optionValueMap.get(CONFIG_OPTION);
        if (configOption != null) {
            if (bsimURLOption != null) {
                throw new IllegalArgumentException("--bsim and --config options may not both be present");
            }
            this.setupGhidraURL(urlstring);
        } else if (bsimURLOption != null) {
            this.setupURLs(urlstring, bsimURLOption);
        } else {
            throw new IllegalArgumentException("Must specify either --bsim or --config option");
        }
    }

    public void run(String[] params) throws Exception {
        this.run(params, TaskMonitor.DUMMY);
    }

    private void doCreateDatabase(List<String> params) throws IOException {
        if (params.isEmpty()) {
            throw new IllegalArgumentException("Missing database template");
        }
        if (params.size() > 1) {
            throw new IllegalArgumentException("Unexpected parameter: " + params.get(1));
        }
        String configTemplate = params.get(0);
        boolean noTrackCallGraph = this.booleanOptions.contains(NO_CALLGRAPH_OPTION);
        String nameOption = this.optionValueMap.get(NAME_OPTION);
        String ownerOption = this.optionValueMap.get(OWNER_OPTION);
        String descOption = this.optionValueMap.get(DESCRIPTION_OPTION);
        try (BulkSignatures bsim = this.getBulkSignatures();){
            bsim.createDatabase(configTemplate, nameOption, ownerOption, descOption, !noTrackCallGraph);
        }
    }

    private void doGenerateSigs(List<String> params, TaskMonitor monitor) throws Exception, CancelledException {
        if (params.size() > 1) {
            throw new IllegalArgumentException("Invalid generatesigs parameter use!");
        }
        boolean commitOption = this.booleanOptions.contains(COMMIT_OPTION);
        boolean overwriteOption = this.booleanOptions.contains(OVERWRITE_OPTION);
        String configOption = this.optionValueMap.get(CONFIG_OPTION);
        String xmlDirectory = null;
        if (params.size() == 1) {
            xmlDirectory = params.get(0);
            if (configOption != null && commitOption) {
                throw new IllegalArgumentException("Invalid option use with --config option: --commit");
            }
        } else {
            if (overwriteOption) {
                throw new IllegalArgumentException("Invalid option use: --overwrite");
            }
            commitOption = true;
        }
        try (BulkSignatures bsim = this.getBulkSignatures();){
            if (commitOption) {
                bsim.signatureRepo(this.ghidraURL, xmlDirectory, overwriteOption, monitor);
            } else {
                bsim.generateSignaturesFromServer(this.ghidraURL, xmlDirectory, overwriteOption, configOption, monitor);
            }
        }
    }

    private void doGenerateUpdates(List<String> params, TaskMonitor monitor) throws Exception, CancelledException {
        if (params.size() > 1) {
            throw new IllegalArgumentException("Invalid generateupdates parameter use!");
        }
        boolean commitOption = this.booleanOptions.contains(COMMIT_OPTION);
        boolean overwriteOption = this.booleanOptions.contains(OVERWRITE_OPTION);
        String configOption = this.optionValueMap.get(CONFIG_OPTION);
        String xmlDirectory = null;
        if (params.size() == 1) {
            xmlDirectory = params.get(0);
            if (configOption != null && commitOption) {
                throw new IllegalArgumentException("Invalid option use with --config option: --commit");
            }
        } else {
            if (overwriteOption) {
                throw new IllegalArgumentException("Invalid option use: --overwrite");
            }
            commitOption = true;
        }
        try (BulkSignatures bsim = this.getBulkSignatures();){
            if (commitOption) {
                bsim.updateRepoSignatures(this.ghidraURL, xmlDirectory, overwriteOption, monitor);
            } else {
                bsim.generateUpdatesFromServer(this.ghidraURL, xmlDirectory, overwriteOption, configOption, monitor);
            }
        }
    }

    private File checkDirectory(String dirPath) throws IOException {
        File dir = new File(dirPath);
        if (!dir.exists()) {
            throw new IOException("Commit directory does not exist: " + dirPath);
        }
        if (!dir.isDirectory()) {
            throw new IOException(dirPath + ": is not a directory");
        }
        return dir.getCanonicalFile();
    }

    private void doCommitSigs(List<String> params, TaskMonitor monitor) throws IOException, SAXException, LSHException, CancelledException {
        if (params.size() < 1) {
            throw new IllegalArgumentException("Missing directory containing signature files");
        }
        String xmlDirectory = params.get(0);
        File dir = this.checkDirectory(xmlDirectory);
        boolean hasOverride = this.optionValueMap.containsKey(OVERRIDE_OPTION);
        String md5Filter = this.optionValueMap.get(MD5_OPTION);
        try (BulkSignatures bsim = this.getBulkSignatures();){
            bsim.sendXmlToQueryServer(dir, hasOverride ? this.ghidraURL : null, md5Filter, monitor);
        }
    }

    private void doCommitUpdates(List<String> params) throws IOException, SAXException, LSHException {
        if (params.size() < 1) {
            throw new IllegalArgumentException("Missing directory containing update files");
        }
        String xmlDirectory = params.get(0);
        File dir = this.checkDirectory(xmlDirectory);
        try (BulkSignatures bsim = this.getBulkSignatures();){
            bsim.sendUpdateToServer(dir);
        }
    }

    private boolean isAllNull(String ... strings) {
        for (String s : strings) {
            if (s == null) continue;
            return false;
        }
        return true;
    }

    private void fillinSingleExeSpecifier(ExeSpecifier spec) throws IllegalArgumentException {
        String md5Option = this.optionValueMap.get(MD5_OPTION);
        String nameOption = this.optionValueMap.get(NAME_OPTION);
        String archOption = this.optionValueMap.get(ARCH_OPTION);
        String compOption = this.optionValueMap.get(COMPILER_OPTION);
        if (md5Option != null) {
            if (!this.isAllNull(nameOption, archOption, compOption)) {
                throw new IllegalArgumentException("The --name, --arch, --compiler options are not valid when --md5 option is specified.");
            }
            spec.exemd5 = md5Option;
        } else if (nameOption != null) {
            spec.exename = nameOption;
            spec.arch = archOption;
            spec.execompname = compOption;
        } else {
            throw new IllegalArgumentException("Must specify either --md5 or --name option");
        }
    }

    private void doListFunctions(List<String> params) throws IOException, LSHException {
        Integer maxFunc = this.parsePositiveIntegerOption(MAX_FUNC_OPTION);
        QueryName query = new QueryName();
        this.fillinSingleExeSpecifier(query.spec);
        if (maxFunc != null) {
            query.maxfunc = maxFunc;
        }
        if (this.booleanOptions.contains(PRINT_SELF_SIGNIFICANCE_OPTION)) {
            query.printselfsig = true;
        }
        if (this.booleanOptions.contains(CALL_GRAPH_OPTION)) {
            query.fillinCallgraph = true;
        }
        if (this.booleanOptions.contains(PRINT_JUST_EXE_OPTION)) {
            query.printjustexe = true;
        }
        try (BulkSignatures bsim = this.getBulkSignatures();){
            bsim.printFunctions(query, System.out);
        }
    }

    private void doDeleteExecutable(List<String> params) throws IOException, LSHException {
        ExeSpecifier spec = new ExeSpecifier();
        this.fillinSingleExeSpecifier(spec);
        try (BulkSignatures bsim = this.getBulkSignatures();){
            bsim.deleteExecutables(spec);
        }
    }

    private void doDropIndex(List<String> params) throws IOException, LSHException {
        try (BulkSignatures bsim = this.getBulkSignatures();){
            bsim.dropIndex();
        }
    }

    private void doRebuildIndex(List<String> params) throws IOException, LSHException {
        try (BulkSignatures bsim = this.getBulkSignatures();){
            bsim.rebuildIndex();
        }
    }

    private void doPrewarm(List<String> params) throws IOException, LSHException {
        try (BulkSignatures bsim = this.getBulkSignatures();){
            bsim.prewarm();
        }
    }

    private void doListExes(List<String> params) throws IOException, LSHException {
        int limit = 20;
        Integer limitOption = this.parsePositiveIntegerOption(LIMIT_OPTION);
        if (limitOption != null) {
            limit = limitOption;
        }
        boolean includeLibs = this.booleanOptions.contains(INCLUDE_LIBS_OPTION);
        String md5Option = this.optionValueMap.get(MD5_OPTION);
        String nameOption = this.optionValueMap.get(NAME_OPTION);
        String archOption = this.optionValueMap.get(ARCH_OPTION);
        String compOption = this.optionValueMap.get(COMPILER_OPTION);
        String sortColumnOption = this.optionValueMap.get(SORT_COL_OPTION);
        try (BulkSignatures bsim = this.getBulkSignatures();){
            List<ExecutableRecord> exeList = bsim.getExes(limit, md5Option, nameOption, archOption, compOption, sortColumnOption, includeLibs);
            for (ExecutableRecord exeRec : exeList) {
                Msg.info((Object)this, (Object)exeRec.printRaw());
            }
            String summary = exeList.size() + " executables found";
            if (limit > 0 && limit == exeList.size()) {
                summary = summary + " (results limit reached)";
            }
            Msg.info((Object)this, (Object)summary);
        }
    }

    private void doGetCount(List<String> params) throws IOException, LSHException {
        boolean includeFakes = this.booleanOptions.contains(INCLUDE_LIBS_OPTION);
        String md5Option = this.optionValueMap.get(MD5_OPTION);
        String nameOption = this.optionValueMap.get(NAME_OPTION);
        String archOption = this.optionValueMap.get(ARCH_OPTION);
        String compOption = this.optionValueMap.get(COMPILER_OPTION);
        try (BulkSignatures bsim = this.getBulkSignatures();){
            int count = bsim.getCount(md5Option, nameOption, archOption, compOption, includeFakes);
            System.out.println("Matching executable count: " + count);
        }
    }

    private void doInstallMetadata(List<String> params) throws IOException, LSHException {
        String nameOption = this.optionValueMap.get(NAME_OPTION);
        String ownerOption = this.optionValueMap.get(OWNER_OPTION);
        String descOption = this.optionValueMap.get(DESCRIPTION_OPTION);
        if (this.isAllNull(nameOption, ownerOption, descOption)) {
            throw new IllegalArgumentException("Missing one or more metadata options: --name, --owner, --description");
        }
        try (BulkSignatures bsim = this.getBulkSignatures();){
            bsim.installMetadata(nameOption, ownerOption, descOption);
        }
    }

    private void doPrintMetadata(List<String> params) throws IOException, LSHException {
        try (BulkSignatures bsim = this.getBulkSignatures();){
            bsim.printMetadata();
        }
    }

    private void doInstallCategory(List<String> params) throws IOException, LSHException {
        if (params.size() < 1) {
            throw new IllegalArgumentException("Missing name of new category");
        }
        boolean dateOption = this.booleanOptions.contains(CATEGORY_DATE_OPTION);
        String categoryName = params.get(0);
        if (params.size() > 1) {
            throw new IllegalArgumentException("Unexpected parameter: " + params.get(1));
        }
        try (BulkSignatures bsim = this.getBulkSignatures();){
            bsim.installCategory(categoryName, dateOption);
        }
    }

    private void doInstallTags(List<String> params) throws IOException, LSHException {
        if (params.size() < 1) {
            throw new IllegalArgumentException("Missing name of new function tag");
        }
        if (params.size() > 1) {
            throw new IllegalArgumentException("Unknown option: " + params.get(1));
        }
        String functionTag = params.get(0);
        try (BulkSignatures bsim = this.getBulkSignatures();){
            bsim.installTags(functionTag);
        }
    }

    private void doDumpSigs(List<String> params) throws IOException, LSHException {
        if (params.size() < 1) {
            throw new IllegalArgumentException("Must specify an output directory");
        }
        File resultFolder = new File(params.get(0));
        QueryName query = new QueryName();
        this.fillinSingleExeSpecifier(query.spec);
        query.maxfunc = 0;
        try (BulkSignatures bsim = this.getBulkSignatures();){
            bsim.doDumpSigs(resultFolder, query);
        }
    }

    private static void printMaxMemory() {
        String maxMemStr;
        long maxMemoryBytes = Runtime.getRuntime().maxMemory();
        float maxMem = maxMemoryBytes / 0x100000L;
        String units = " MBytes";
        if (maxMem >= 1024.0f) {
            maxMem /= 1024.0f;
            units = " GBytes";
        }
        if ((maxMemStr = String.format("%.1f", Float.valueOf(maxMem))).endsWith(".0")) {
            maxMemStr = maxMemStr.substring(0, maxMemStr.length() - 2);
        }
        System.out.println("Max-Memory: " + maxMemStr + units);
    }

    private static void printUsage() {
        System.err.println("\nUSAGE: bsim [command]       required-args... [OPTIONS...]\n            createdatabase  <bsimURL> <config_template> [--name|-n \"<name>\"] [--owner|-o \"<owner>\"] [--description|-d \"<text>\"] [--nocallgraph]\n            setmetadata     <bsimURL> [--name|-n \"<name>\"] [--owner|-o \"<owner>\"] [--description|-d \"<text>\"]\n            getmetadata     <bsimURL>\n            addexecategory  <bsimURL> <category_name> [--date]\n            addfunctiontag  <bsimURL> <tag_name>\n            dropindex       <bsimURL>\n            rebuildindex    <bsimURL>\n            prewarm         <bsimURL>\n            generatesigs    <ghidraURL> </xmldirectory> --config|-c <config_template> [--overwrite]\n            generatesigs    <ghidraURL> </xmldirectory> --bsim|-b <bsimURL> [--commit] [--overwrite]\n            generatesigs    <ghidraURL> --bsim|-b <bsimURL>\n            commitsigs      <bsimURL> </xmldirectory> [--md5|-m <hash>] [--override <ghidraURL>]\n            generateupdates <ghidraURL> </xmldirectory> --config|-c <config_template> [--overwrite]\n            generateupdates <ghidraURL> </xmldirectory> --bsim|-b <bsimURL> [--commit] [--overwrite]\n            generateupdates <ghidraURL> --bsim|-b <bsimURL>\n            commitupdates   <bsimURL> </xmldirectory>\n            listexes        <bsimURL> [--md5|-m <hash>] [--name|-n <exe_name>] [--arch|-a <languageID>] [--compiler <cspecID>] [--sortcol|-s md5|name] [--limit|-l <exe_count>] [--includelibs]\n            getexecount     <bsimURL> [--md5|-m <hash>] [--name|-n <exe_name>] [--arch|-a <languageID>] [--compiler <cspecID>] [--includelibs]\n            delete          <bsimURL> [--md5|-m <hash>] [--name|-n <exe_name> [--arch|-a <languageID>] [--compiler <cspecID>]]\n            listfuncs       <bsimURL> [--md5|-m <hash>] [--name|-n <exe_name> [--arch|-a <languageID>] [--compiler <cspecID>]] [--printselfsig] [--callgraph] [--printjustexe] [--maxfunc <max_count>]\n            dumpsigs        <bsimURL> </xmldirectory> [--md5|-m <hash>] [--name|-n <exe_name> [--arch|-a <languageID>] [--compiler <cspecID>]]\n\nGlobal options:\n    --user|-u <username>\n    --cert </certfile-path>\n\nEnumerated Options:\n    <config_template> - large_32 | medium_32 | medium_64 | medium_cpool | medium_nosize \n\nBSim URL Forms (bsimURL):\n    postgresql://[username@]<hostname>[:<port>]/<dbname>\n    elastic://[username@]<hostname>[:<port>]/<dbname>\n    https://[username@]<hostname>[:<port>]/<dbname>\n    file:/[<local-dirpath>/]<dbname>\n\nGhidra URL Forms (ghidraURL):\n    ghidra://<hostname>[:<port>]/<repo-name>[/<folder-path>]\n    ghidra:/[<local-dirpath>/]<project-name>[?/<folder-path>]\n\nNOTE: Options with values may also be specified using the form: --option=value\n");
    }

    public void launch(GhidraApplicationLayout ghidraLayout, String[] params) {
        BSimLaunchable.printMaxMemory();
        if (params.length == 0) {
            BSimLaunchable.printUsage();
            return;
        }
        this.layout = ghidraLayout;
        try {
            this.run(params);
        }
        catch (MalformedURLException e) {
            String msg = e.getMessage();
            if (msg == null) {
                e.printStackTrace();
            } else {
                Msg.error((Object)this, (Object)("Invalid URL specified: " + msg));
            }
            System.exit(22);
        }
        catch (IllegalArgumentException e) {
            Msg.error((Object)this, (Object)e.getMessage());
            System.out.println("Execute \"bsim\" without arguments to display usage details");
            System.exit(22);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                e.printStackTrace();
            } else {
                Msg.error((Object)this, (Object)msg);
            }
            System.exit(1);
        }
    }

    private void initializeApplication(String command) throws IOException {
        int initType;
        int n = initType = COMMANDS_WITH_REPO_ACCESS.contains(command) ? 2 : 1;
        if (this.layout != null) {
            String connectingUserName = this.optionValueMap.get(USER_OPTION);
            String certOption = this.optionValueMap.get(CERT_OPTION);
            BSimLaunchable.initializeApplication((ApplicationLayout)this.layout, initType, connectingUserName, certOption);
        }
    }

    public static void initializeApplication(ApplicationLayout layout, int type, String connectingUserName, String certPath) throws IOException {
        if (Application.isInitialized()) {
            return;
        }
        System.setProperty("SystemUtilities.isHeadless", Boolean.TRUE.toString());
        System.setProperty("log4j.configurationFile", BSIM_LOGGING_CONFIGURATION_FILE);
        Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)(switch (type) {
            case 2 -> new HeadlessGhidraApplicationConfiguration();
            case 1 -> new HeadlessBSimApplicationConfiguration();
            default -> new ApplicationConfiguration();
        }));
        DefaultSSLContextInitializer.initialize();
        Handler.registerHandler();
        ghidra.features.bsim.query.postgresql.Handler.registerHandler();
        if (connectingUserName == null) {
            connectingUserName = ClientUtil.getUserName();
        }
        HeadlessClientAuthenticator.installHeadlessClientAuthenticator((String)connectingUserName, (String)certPath, (boolean)true);
    }

    static {
        SHORTCUT_OPTION_MAP.put("-a", ARCH_OPTION);
        SHORTCUT_OPTION_MAP.put("-b", BSIM_URL_OPTION);
        SHORTCUT_OPTION_MAP.put("-c", CONFIG_OPTION);
        SHORTCUT_OPTION_MAP.put("-d", DESCRIPTION_OPTION);
        SHORTCUT_OPTION_MAP.put("-l", LIMIT_OPTION);
        SHORTCUT_OPTION_MAP.put("-m", MD5_OPTION);
        SHORTCUT_OPTION_MAP.put("-n", NAME_OPTION);
        SHORTCUT_OPTION_MAP.put("-o", OWNER_OPTION);
        SHORTCUT_OPTION_MAP.put("-s", SORT_COL_OPTION);
        SHORTCUT_OPTION_MAP.put("-u", USER_OPTION);
        CREATE_DATABASE_OPTIONS = Set.of(NAME_OPTION, OWNER_OPTION, DESCRIPTION_OPTION, NO_CALLGRAPH_OPTION);
        COMMIT_SIGS_OPTIONS = Set.of(OVERRIDE_OPTION, MD5_OPTION);
        COMMIT_UPDATES_OPTIONS = Set.of();
        DELETE_OPTIONS = Set.of(MD5_OPTION, NAME_OPTION, ARCH_OPTION, COMPILER_OPTION);
        DROP_INDEX_OPTIONS = Set.of();
        REBUILD_INDEX_OPTIONS = Set.of();
        PREWARM_OPTIONS = Set.of();
        SET_METADATA_OPTIONS = Set.of(NAME_OPTION, OWNER_OPTION, DESCRIPTION_OPTION);
        GET_METADATA_OPTIONS = Set.of();
        ADD_EXE_CATEGORY_OPTIONS = Set.of(CATEGORY_DATE_OPTION);
        ADD_FUNCTION_TAG_OPTIONS = Set.of();
        DUMP_SIGS_OPTIONS = Set.of(MD5_OPTION, NAME_OPTION, ARCH_OPTION, COMPILER_OPTION);
        GENERATE_SIGS_OPTIONS = Set.of(CONFIG_OPTION, BSIM_URL_OPTION, OVERWRITE_OPTION, COMMIT_OPTION);
        GENERATE_UPDATES_OPTIONS = Set.of(CONFIG_OPTION, BSIM_URL_OPTION, OVERWRITE_OPTION, COMMIT_OPTION);
        LIST_FUNCTIONS_OPTIONS = Set.of(MD5_OPTION, NAME_OPTION, ARCH_OPTION, COMPILER_OPTION, PRINT_SELF_SIGNIFICANCE_OPTION, CALL_GRAPH_OPTION, PRINT_JUST_EXE_OPTION, MAX_FUNC_OPTION);
        GET_EXECUTABLES_OPTIONS = Set.of(MD5_OPTION, NAME_OPTION, ARCH_OPTION, COMPILER_OPTION, SORT_COL_OPTION, LIMIT_OPTION, INCLUDE_LIBS_OPTION);
        GET_EXECUTABLES_COUNT_OPTIONS = Set.of(MD5_OPTION, NAME_OPTION, ARCH_OPTION, COMPILER_OPTION, INCLUDE_LIBS_OPTION);
        ALLOWED_OPTION_MAP = new HashMap<String, Set<String>>();
        ALLOWED_OPTION_MAP.put(COMMAND_CREATE_DATABASE, CREATE_DATABASE_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_SET_METADATA, SET_METADATA_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_GET_METADATA, GET_METADATA_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_ADD_EXE_CATEGORY, ADD_EXE_CATEGORY_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_ADD_FUNCTION_TAG, ADD_FUNCTION_TAG_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_DROP_INDEX, DROP_INDEX_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_REBUILD_INDEX, REBUILD_INDEX_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_PREWARM, PREWARM_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_GENERATE_SIGS, GENERATE_SIGS_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_COMMIT_SIGS, COMMIT_SIGS_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_GENERATE_UPDATES, GENERATE_UPDATES_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_COMMIT_UPDATES, COMMIT_UPDATES_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_DELETE, DELETE_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_LIST_FUNCTIONS, LIST_FUNCTIONS_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_LIST_EXES, GET_EXECUTABLES_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_GET_EXE_COUNT, GET_EXECUTABLES_COUNT_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_DUMP_SIGS, DUMP_SIGS_OPTIONS);
    }
}

