/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.art.ArtHeader;
import ghidra.file.formats.android.art.ArtImageSections;
import ghidra.file.formats.android.art.image_sections.ImageSections_Marshmallow;
import ghidra.file.formats.android.art.image_sections.ImageSections_Nougat;
import ghidra.file.formats.android.art.image_sections.ImageSections_NougatMR2Pixel;
import ghidra.file.formats.android.art.image_sections.ImageSections_Oreo;
import ghidra.file.formats.android.art.image_sections.ImageSections_OreoMR1;
import ghidra.file.formats.android.art.image_sections.ImageSections_Pie;
import ghidra.file.formats.android.art.image_sections.ImageSections_Q_R;
import ghidra.file.formats.android.art.image_sections.ImageSections_S_T;
import java.io.IOException;

public final class ArtImageSectionsFactory {
    public static ArtImageSections getArtImageSections(BinaryReader reader, ArtHeader artHeader) throws IOException {
        switch (artHeader.getVersion()) {
            case "017": {
                return new ImageSections_Marshmallow(reader, artHeader);
            }
            case "029": {
                return new ImageSections_Nougat(reader, artHeader);
            }
            case "030": {
                return new ImageSections_NougatMR2Pixel(reader, artHeader);
            }
            case "043": 
            case "044": {
                return new ImageSections_Oreo(reader, artHeader);
            }
            case "046": {
                return new ImageSections_OreoMR1(reader, artHeader);
            }
            case "056": {
                return new ImageSections_Pie(reader, artHeader);
            }
            case "074": 
            case "085": {
                return new ImageSections_Q_R(reader, artHeader);
            }
            case "099": 
            case "106": {
                return new ImageSections_S_T(reader, artHeader);
            }
        }
        throw new IOException("Unsupported ART version for ImageSections: " + artHeader.getVersion());
    }
}

