/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.pcode;

import ghidra.app.plugin.core.debug.gui.pcode.DebuggerPcodeStepperProvider;
import ghidra.app.plugin.core.debug.gui.pcode.PcodeRow;
import ghidra.docking.settings.SettingsImpl;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.mem.ByteMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.NumericUtilities;
import java.math.BigInteger;
import java.util.stream.Stream;

public class UniqueRow {
    protected final DebuggerPcodeStepperProvider provider;
    protected final Language language;
    protected final ConcretizedState<?> state;
    protected final Varnode vn;
    protected DataType dataType;

    public <T> UniqueRow(DebuggerPcodeStepperProvider provider, Language language, PcodeExecutorState<T> state, PcodeArithmetic<T> arithmetic, Varnode vn) {
        if (!vn.isUnique()) {
            throw new AssertionError((Object)"Only uniques allowed in unique table");
        }
        this.provider = provider;
        this.language = language;
        this.state = new ConcretizedState<T>(state, arithmetic);
        this.vn = vn;
    }

    protected static AddressRange rangeOf(Varnode vn) {
        try {
            return new AddressRangeImpl(vn.getAddress(), (long)vn.getSize());
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected static boolean overlap(Varnode vn1, Varnode vn2) {
        return UniqueRow.rangeOf(vn1).intersects(UniqueRow.rangeOf(vn2));
    }

    public RefType getRefType() {
        if (this.provider.pcodeTable.getSelectedRowCount() != 1) {
            return RefType.NONE;
        }
        int index = this.provider.pcodeTable.getSelectedRow();
        if (index == -1) {
            return RefType.NONE;
        }
        PcodeRow row = (PcodeRow)this.provider.pcodeTableModel.getRowObject(index);
        PcodeOp op = row.getOp();
        if (op == null) {
            return RefType.NONE;
        }
        boolean isRead = Stream.of(op.getInputs()).anyMatch(in -> UniqueRow.overlap(in, this.vn));
        Varnode out = op.getOutput();
        boolean isWrite = out != null && UniqueRow.overlap(out, this.vn);
        return RefType.fromRW(isRead, isWrite);
    }

    public String getName() {
        return String.format("$U%x:%d", this.vn.getOffset(), this.vn.getSize());
    }

    public String getBytes() {
        byte[] bytes;
        try {
            bytes = this.state.getBytes(this.vn);
        }
        catch (UnsupportedOperationException e) {
            return "(not concrete)";
        }
        if (bytes == null) {
            return "??";
        }
        if (bytes.length > 20) {
            return NumericUtilities.convertBytesToString((byte[])bytes, (int)0, (int)20, (String)" ") + " ...";
        }
        return NumericUtilities.convertBytesToString((byte[])bytes, (String)" ");
    }

    public BigInteger getValue() {
        try {
            return this.state.getValue(this.vn);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public String getValueRepresentation() {
        if (this.dataType == null) {
            return "";
        }
        byte[] bytes = this.state.getBytes(this.vn);
        if (bytes == null) {
            return "??";
        }
        ByteMemBufferImpl buffer = new ByteMemBufferImpl(this.vn.getAddress(), bytes, this.language.isBigEndian());
        return this.dataType.getRepresentation((MemBuffer)buffer, SettingsImpl.NO_SETTINGS, bytes.length);
    }

    public static class ConcretizedState<T> {
        private final PcodeExecutorState<T> state;
        private final PcodeArithmetic<T> arithmetic;

        public ConcretizedState(PcodeExecutorState<T> state, PcodeArithmetic<T> arithmetic) {
            this.state = state;
            this.arithmetic = arithmetic;
        }

        public byte[] getBytes(Varnode vn) {
            return this.arithmetic.toConcrete(this.state.getVar(vn, PcodeExecutorStatePiece.Reason.INSPECT), PcodeArithmetic.Purpose.INSPECT);
        }

        public BigInteger getValue(Varnode vn) {
            return this.arithmetic.toBigInteger(this.state.getVar(vn, PcodeExecutorStatePiece.Reason.INSPECT), PcodeArithmetic.Purpose.INSPECT);
        }
    }

    public static enum RefType {
        NONE,
        READ,
        WRITE,
        READ_WRITE;


        static RefType fromRW(boolean isRead, boolean isWrite) {
            if (isRead) {
                if (isWrite) {
                    return READ_WRITE;
                }
                return READ;
            }
            if (isWrite) {
                return WRITE;
            }
            return NONE;
        }
    }
}

