/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.util.Msg;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.function.BiConsumer;

public class FaultTolerantInputStream
extends InputStream {
    private InputStream delegate;
    private long currentPosition;
    private long totalLength;
    private Throwable error;
    private long faultPosition;
    private long faultByteCount;
    private BiConsumer<String, Throwable> errorConsumer;

    public FaultTolerantInputStream(InputStream delegate, long length, BiConsumer<String, Throwable> errorConsumer) {
        this.delegate = delegate;
        this.totalLength = length;
        this.errorConsumer = errorConsumer != null ? errorConsumer : this::defaultErrorHandler;
    }

    @Override
    public void close() throws IOException {
        FSUtilities.uncheckedClose(this.delegate, null);
        if (this.error != null) {
            this.errorConsumer.accept("Errors encountered when reading at position %d, %d bytes faulted, replaced with 0's".formatted(this.faultPosition, this.faultByteCount), this.error);
        }
    }

    private void defaultErrorHandler(String msg, Throwable th) {
        Msg.error((Object)this, (Object)msg, (Throwable)th);
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int bytesRead = this.read(buffer, 0, 1);
        return bytesRead == 1 ? Byte.toUnsignedInt(buffer[0]) : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long remaining;
        if (this.error == null) {
            try {
                int bytesRead = this.delegate.read(b, off, len);
                this.currentPosition += (long)bytesRead;
                return bytesRead;
            }
            catch (IOException e) {
                this.faultPosition = this.currentPosition;
                this.error = e;
            }
        }
        if ((remaining = this.totalLength - this.currentPosition) <= 0L) {
            return 0;
        }
        len = (int)Math.min((long)len, remaining);
        Arrays.fill(b, off, off + len, (byte)0);
        this.currentPosition += (long)len;
        this.faultByteCount += (long)len;
        return len;
    }
}

