/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions.associate;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeState;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypeSynchronizer;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.archive.BuiltInSourceArchive;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.HTMLUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.TaskBuilder;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.tree.TreePath;

public class DisassociateDataTypeAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public DisassociateDataTypeAction(DataTypeManagerPlugin plugin) {
        super("Disassociate From Archive", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Disassociate From Archive"}, null, "Sync"));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        DataTypesActionContext dtContext = (DataTypesActionContext)context;
        List<DataTypeNode> nodes = dtContext.getDisassociatableNodes();
        return !nodes.isEmpty();
    }

    private List<DataTypeNode> getDisassociatableNodes(TreePath[] paths) {
        ArrayList<DataTypeNode> nodes = new ArrayList<DataTypeNode>();
        for (TreePath treePath : paths) {
            DataTypeNode node = this.getDisassociatableNode(treePath);
            if (node == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private DataTypeNode getDisassociatableNode(TreePath path) {
        GTreeNode node = (GTreeNode)path.getLastPathComponent();
        if (!(node instanceof DataTypeNode)) {
            return null;
        }
        DataTypeNode dataTypeNode = (DataTypeNode)node;
        DataType dataType = dataTypeNode.getDataType();
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        SourceArchive sourceArchive = dataType.getSourceArchive();
        if (sourceArchive == null || dataTypeManager == null || sourceArchive.equals((Object)BuiltInSourceArchive.INSTANCE) || sourceArchive.getSourceArchiveID().equals((Object)dataTypeManager.getUniversalID())) {
            return null;
        }
        return dataTypeNode;
    }

    public void actionPerformed(ActionContext context) {
        Object contextObject = context.getContextObject();
        GTree gTree = (GTree)contextObject;
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        List<DataTypeNode> nodes = this.getDisassociatableNodes(selectionPaths);
        Optional<DataTypeManager> unmodifiableDtm = nodes.stream().map(node -> {
            DataType dataType = node.getDataType();
            DataTypeManager dtm = dataType.getDataTypeManager();
            return dtm;
        }).filter(dtm -> !dtm.isUpdatable()).findAny();
        if (unmodifiableDtm.isPresent()) {
            DataTypeManager dtm2 = unmodifiableDtm.get();
            DataTypeUtils.showUnmodifiableArchiveErrorMessage((Component)gTree, "Disassociate Failed", dtm2);
            return;
        }
        if (!this.confirmOperation(nodes)) {
            return;
        }
        MonitoredRunnable r = monitor -> this.doDisassociate(nodes, monitor);
        new TaskBuilder("Disassociate From Archive", r).setStatusTextAlignment(10).launchModal();
    }

    private boolean confirmOperation(List<DataTypeNode> nodes) {
        String message = "This will <b>permanently</b> disassociate these datatypes from the archive.<br><br>Are you sure you want to <b><u>disassociate</u></b> " + nodes.size() + " datatype(s)?";
        String asHtml = HTMLUtilities.wrapAsHTML((String)message);
        int result = OptionDialog.showYesNoDialog((Component)this.plugin.getTool().getToolFrame(), (String)"Confirm Disassociate", (String)asHtml);
        return result == 1;
    }

    private void collapseArchiveNodes(DataTypeArchiveGTree tree) {
        GTreeNode root = tree.getViewRoot();
        List archives = root.getChildren();
        archives.forEach(archive -> tree.collapseAll((GTreeNode)archive));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDisassociate(List<DataTypeNode> nodes, TaskMonitor monitor) {
        List<DataType> dataTypes = nodes.stream().map(node -> node.getDataType()).collect(Collectors.toList());
        DataTypesProvider provider = this.plugin.getProvider();
        DataTypeArchiveGTree tree = provider.getGTree();
        GTreeState treeState = tree.getTreeState();
        this.collapseArchiveNodes(tree);
        try {
            this.disassociateTypes(dataTypes, monitor);
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            tree.restoreTreeState(treeState);
        }
    }

    private void disassociateTypes(List<DataType> dataTypes, TaskMonitor monitor) throws CancelledException {
        monitor.initialize((long)dataTypes.size());
        Map<DataTypeManager, List<DataType>> managersToTypes = dataTypes.stream().collect(Collectors.groupingBy(dt -> dt.getDataTypeManager()));
        for (Map.Entry<DataTypeManager, List<DataType>> entry : managersToTypes.entrySet()) {
            DataTypeManager dtm = entry.getKey();
            List<DataType> types = entry.getValue();
            this.disassociateManagersTypes(dtm, types, monitor);
        }
    }

    private void disassociateManagersTypes(DataTypeManager dtm, List<DataType> dataTypes, TaskMonitor monitor) throws CancelledException {
        Map<SourceArchive, List<DataType>> sourceToTypes = dataTypes.stream().collect(Collectors.groupingBy(dt -> dt.getSourceArchive()));
        monitor.setMessage("Disassociating types from " + dtm.getName());
        monitor.initialize((long)dataTypes.size());
        DataTypeManagerHandler handler = this.plugin.getDataTypeManagerHandler();
        for (Map.Entry<SourceArchive, List<DataType>> entry : sourceToTypes.entrySet()) {
            SourceArchive source = entry.getKey();
            List<DataType> types = entry.getValue();
            DataTypeSynchronizer synchronizer = new DataTypeSynchronizer(handler, dtm, source);
            this.disassociate(synchronizer, dtm, types, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disassociate(DataTypeSynchronizer synchronizer, DataTypeManager dtm, List<DataType> types, TaskMonitor monitor) throws CancelledException {
        int txId = dtm.startTransaction(this.getName());
        try {
            for (DataType dt : types) {
                monitor.checkCancelled();
                monitor.setMessage("Disassociating " + dt.getName());
                dtm.disassociate(dt);
                monitor.incrementProgress(1L);
            }
            synchronizer.reSyncOutOfSyncInTimeOnlyDataTypes();
        }
        finally {
            dtm.endTransaction(txId, true);
        }
    }
}

