/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.assembler;

import docking.EmptyBorderToggleButton;
import docking.widgets.autocomplete.AutocompletionEvent;
import docking.widgets.autocomplete.AutocompletionListener;
import docking.widgets.autocomplete.AutocompletionModel;
import docking.widgets.autocomplete.TextFieldAutocompleter;
import docking.widgets.label.GDLabel;
import docking.widgets.textfield.TextFieldLinker;
import generic.theme.GColor;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.app.plugin.assembler.Assembler;
import ghidra.app.plugin.assembler.Assemblers;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseErrorResult;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseResult;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolutionResults;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.processors.sleigh.SleighInstructionPrototype;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.SleighLanguageProvider;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.DisassemblerContextAdapter;
import ghidra.program.model.lang.InsufficientBytesException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.ByteMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import utility.application.ApplicationLayout;

public class AssemblyDualTextField {
    private static final String FONT_ID = "font.plugin.assembly.dual.text.field";
    private static final Color FG_PREFERENCE_MOST = new GColor("color.fg.plugin.assembler.completion.most");
    private static final Color FG_PREFERENCE_MIDDLE = new GColor("color.fg.plugin.assembler.completion.middle");
    private static final Color FG_PREFERENCE_LEAST = new GColor("color.fg.plugin.assembler.completion.least");
    protected final TextFieldLinker linker = new TextFieldLinker();
    protected final JTextField mnemonic = new JTextField();
    protected final JTextField operands = new JTextField();
    protected final JTextField assembly = new JTextField();
    protected final AssemblyAutocompletionModel model = new AssemblyAutocompletionModel();
    protected final AssemblyAutocompleter auto = new AssemblyAutocompleter(this.model);
    protected Assembler assembler;
    protected Address address;
    protected Instruction existing;
    protected boolean exhaustUndefined = false;

    public AssemblyDualTextField() {
        EnterKeyListener kl = new EnterKeyListener();
        this.linker.linkField(this.mnemonic, "\\s+", " ");
        this.auto.attachTo(this.mnemonic);
        this.mnemonic.addKeyListener(kl);
        this.configureField(this.mnemonic);
        this.mnemonic.setName("AssemblerMnemonic");
        this.linker.linkLastField(this.operands);
        this.auto.attachTo(this.operands);
        this.operands.addKeyListener(kl);
        this.configureField(this.operands);
        this.operands.setName("AssemblerOperands");
        this.operands.setFocusTraversalKeysEnabled(false);
        this.auto.attachTo(this.assembly);
        this.assembly.addKeyListener(kl);
        this.configureField(this.assembly);
        this.assembly.setName("AssemblerSingleField");
        this.assembly.setFocusTraversalKeysEnabled(false);
    }

    void dispose() {
        this.auto.dispose();
    }

    public void setAssembler(Assembler assembler) {
        this.assembler = Objects.requireNonNull(assembler);
    }

    public void setAddress(Address address) {
        this.address = Objects.requireNonNull(address);
        this.existing = null;
    }

    public void setExisting(Instruction existing) {
        this.existing = existing;
    }

    public JTextField getMnemonicField() {
        return this.mnemonic;
    }

    public JTextField getOperandsField() {
        return this.operands;
    }

    public JButton getExhaustButton() {
        return this.auto.button;
    }

    public JTextField getAssemblyField() {
        return this.assembly;
    }

    public TextFieldAutocompleter<AssemblyCompletion> getAutocompleter() {
        return this.auto;
    }

    public void clear() {
        this.linker.clear();
        this.assembly.setText("");
    }

    public void setVisible(VisibilityMode visibility) {
        switch (visibility.ordinal()) {
            case 0: {
                this.linker.setVisible(false);
                this.assembly.setVisible(false);
                break;
            }
            case 1: {
                this.linker.setVisible(true);
                this.assembly.setVisible(false);
                break;
            }
            case 2: {
                this.linker.setVisible(false);
                this.assembly.setVisible(true);
            }
        }
    }

    public VisibilityMode getVisible() {
        if (this.linker.isVisible()) {
            if (this.assembly.isVisible()) {
                throw new AssertionError();
            }
            return VisibilityMode.DUAL_VISIBLE;
        }
        if (this.assembly.isVisible()) {
            return VisibilityMode.SINGLE_VISIBLE;
        }
        return VisibilityMode.INVISIBLE;
    }

    public void setFont(Font font) {
        this.linker.setFont(font);
        this.assembly.setFont(font);
    }

    public void addFocusListener(FocusListener listener) {
        this.linker.addFocusListener(listener);
        this.assembly.addFocusListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.mnemonic.addKeyListener(listener);
        this.operands.addKeyListener(listener);
        this.assembly.addKeyListener(listener);
    }

    public String getText() {
        if (this.assembly.isVisible()) {
            return this.assembly.getText();
        }
        return this.linker.getText();
    }

    public void setText(String text) {
        if (this.assembly.isVisible()) {
            this.assembly.setText(text);
        } else {
            this.linker.setText(text);
        }
    }

    public void setCaretPosition(int pos) {
        block4: {
            try {
                if (this.assembly.isVisible()) {
                    this.assembly.setCaretPosition(pos);
                } else {
                    this.linker.setCaretPosition(pos);
                }
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    protected void configureField(JTextField field) {
        Gui.registerFont((Component)field, (String)FONT_ID);
    }

    protected String formatSuggestion(String prefix, String suggestion, String bufferleft) {
        String extra = suggestion.substring(bufferleft.length());
        String before = prefix.substring(0, prefix.length() - bufferleft.length());
        return String.format("<html><b>%s%s</b>%s</html>", before, bufferleft, extra);
    }

    protected int computePreference(AssemblyResolvedPatterns rc) {
        if (this.existing == null) {
            return 0;
        }
        String myTree = rc.dumpConstructorTree();
        String exTree = ((SleighInstructionPrototype)this.existing.getPrototype()).dumpConstructorTree();
        for (int i = 0; i < myTree.length(); ++i) {
            if (myTree.startsWith(exTree.substring(0, i))) continue;
            return rc.getInstructionLength() == this.existing.getLength() ? 5000 : i;
        }
        return 10000;
    }

    protected Collection<AssemblyCompletion> computeCompletions(String text) {
        AssemblyPatternBlock ctx = Objects.requireNonNull(this.getContext());
        TreeSet<AssemblyCompletion> result = new TreeSet<AssemblyCompletion>();
        Collection parses = this.assembler.parseLine(text);
        for (AssemblyParseResult parse : parses) {
            if (!parse.isError()) continue;
            AssemblyParseErrorResult err = (AssemblyParseErrorResult)parse;
            String buffer = err.getBuffer();
            for (String s : err.getSuggestions()) {
                if (!s.startsWith(buffer)) continue;
                result.add(new AssemblySuggestion(s.substring(buffer.length()), this.formatSuggestion(text, s, buffer)));
            }
        }
        Program program = this.assembler.getProgram();
        Language language = this.assembler.getLanguage();
        Register ctxReg = language.getContextBaseRegister();
        RegisterValue ctxVal = new RegisterValue(ctxReg, ctx.toBigInteger(ctxReg.getNumBytes()));
        String fullText = this.getText();
        parses = this.assembler.parseLine(fullText);
        for (AssemblyParseResult parse : parses) {
            if (parse.isError()) continue;
            AssemblyResolutionResults sems = this.assembler.resolveTree(parse, this.address, ctx);
            block3: for (AssemblyResolution ar : sems) {
                if (ar.isError()) continue;
                AssemblyResolvedPatterns rc = (AssemblyResolvedPatterns)ar;
                for (byte[] ins : rc.possibleInsVals(ctx)) {
                    AssemblyInstruction ai = new AssemblyInstruction(program, language, this.address, text, Arrays.copyOf(ins, ins.length), ctxVal, this.computePreference(rc));
                    result.add(ai);
                    if (this.exhaustUndefined) continue;
                    continue block3;
                }
            }
        }
        if (result.isEmpty()) {
            result.add(new AssemblyError("", "Invalid instruction and/or prefix"));
        }
        return result;
    }

    protected AssemblyPatternBlock getContext() {
        return this.assembler.getContextAt(this.address).fillMask();
    }

    class AssemblyAutocompletionModel
    implements AutocompletionModel<AssemblyCompletion> {
        AssemblyAutocompletionModel() {
        }

        public Collection<AssemblyCompletion> computeCompletions(String text) {
            return AssemblyDualTextField.this.computeCompletions(text);
        }
    }

    class AssemblyAutocompleter
    extends TextFieldAutocompleter<AssemblyCompletion>
    implements AutocompletionListener<AssemblyCompletion> {
        private static final String CMD_EXHAUST = "Exhaust undefined bits";
        private static final String CMD_ZERO = "Zero undefined bits";
        private JLabel hints;
        private EmptyBorderToggleButton button;

        public AssemblyAutocompleter(AutocompletionModel<AssemblyCompletion> model) {
            super(model);
        }

        void fakeFocusGained(JTextField field) {
            this.listener.fakeFocusGained(field);
        }

        protected String getPrefix(JTextField field) {
            if (field == AssemblyDualTextField.this.assembly) {
                return field.getText().substring(0, field.getCaretPosition());
            }
            return AssemblyDualTextField.this.linker.getTextBeforeCursor(field);
        }

        protected String getCompletionDisplay(AssemblyCompletion sel) {
            return sel.getDisplay();
        }

        protected Color getCompletionForeground(AssemblyCompletion sel, boolean isSelected, boolean cellHasFocus) {
            if (!isSelected) {
                return sel.getColor();
            }
            return null;
        }

        protected String getCompletionText(AssemblyCompletion sel) {
            return sel.getText();
        }

        protected boolean getCompletionCanDefault(AssemblyCompletion sel) {
            return sel.getCanDefault();
        }

        protected Point getCompletionWindowPosition() {
            if (AssemblyDualTextField.this.assembly.isVisible()) {
                Point p = new Point(0, AssemblyDualTextField.this.assembly.getHeight());
                SwingUtilities.convertPointToScreen(p, AssemblyDualTextField.this.assembly);
                return p;
            }
            Point p = new Point(0, 0);
            SwingUtilities.convertPointToScreen(p, AssemblyDualTextField.this.mnemonic);
            Point q = new Point(0, AssemblyDualTextField.this.linker.getFocusedField().getHeight());
            SwingUtilities.convertPointToScreen(q, AssemblyDualTextField.this.linker.getFocusedField());
            p.y = q.y;
            return p;
        }

        protected Dimension getDefaultCompletionWindowDimension() {
            int width = 0;
            if (AssemblyDualTextField.this.assembly.isVisible()) {
                width = AssemblyDualTextField.this.assembly.getWidth();
            } else {
                Point p = new Point(0, 0);
                SwingUtilities.convertPointToScreen(p, AssemblyDualTextField.this.mnemonic);
                Point q = new Point(AssemblyDualTextField.this.operands.getWidth(), 0);
                SwingUtilities.convertPointToScreen(q, AssemblyDualTextField.this.operands);
                width = q.x - p.x;
            }
            return new Dimension(width, -1);
        }

        protected void addContent(JPanel content) {
            JPanel panel = new JPanel(new BorderLayout());
            Box controls = Box.createHorizontalBox();
            GIcon icon = new GIcon("icon.plugin.assembler.question");
            this.button = new EmptyBorderToggleButton((Icon)icon);
            this.button.setToolTipText("Exhaust unspecified bits, otherwise zero them");
            this.button.addActionListener(e -> {
                AssemblyDualTextField.this.exhaustUndefined = CMD_EXHAUST.equals(e.getActionCommand());
                if (AssemblyDualTextField.this.exhaustUndefined) {
                    this.button.setActionCommand(CMD_ZERO);
                } else {
                    this.button.setActionCommand(CMD_EXHAUST);
                }
                AssemblyDualTextField.this.auto.updateDisplayContents();
            });
            this.button.setActionCommand(CMD_EXHAUST);
            controls.add((Component)this.button);
            panel.add((Component)controls, "South");
            this.hints = new JLabel();
            panel.add(this.hints);
            content.add((Component)panel, "South");
            this.addAutocompletionListener(this);
        }

        public void completionSelected(AutocompletionEvent<AssemblyCompletion> ev) {
            Object object = ev.getSelection();
            if (!(object instanceof AssemblyInstruction)) {
                this.hints.setText("");
                return;
            }
            AssemblyInstruction ai = (AssemblyInstruction)object;
            Program program = AssemblyDualTextField.this.assembler.getProgram();
            if (program == null) {
                this.hints.setText("");
                return;
            }
            ProgramContext ctx = program.getProgramContext();
            Register ctxReg = ctx.getBaseContextRegister();
            StringBuilder sb = new StringBuilder("<html><style>\nul.addresses {\n  margin: 0;\n  padding: 0;\n}\nul.addresses > li {\n  margin: 0;\n  padding: 0;\n  list-style-type: none;\n}\nul.context {\n  font-family: monospaced;\n  margin: 0 0 0 20px;\n}\nspan.addr {\n  font-family: monospaced;\n}\n</style><body width=\"300px\"><ul class=\"addresses\">\n".formatted(ListingColors.REGISTER.toHexString()));
            boolean displayedAny = false;
            for (Map.Entry<Address, RegisterValue> ent : ai.contextChanges.contextsOut.entrySet()) {
                RegisterValue defVal = ctx.getDefaultDisassemblyContext();
                RegisterValue newVal = defVal.combineValues(ent.getValue());
                RegisterValue curVal = defVal.combineValues(ctx.getRegisterValue(ctxReg, ent.getKey()));
                boolean displayedAddress = false;
                for (Register sub : ctxReg.getChildRegisters()) {
                    BigInteger newSubVal = newVal.getRegisterValue(sub).getUnsignedValueIgnoreMask();
                    BigInteger curSubVal = curVal.getRegisterValue(sub).getUnsignedValueIgnoreMask();
                    if (Objects.equals(curSubVal, newSubVal)) continue;
                    if (!displayedAddress) {
                        sb.append("<li>At <span class=\"addr\">%s</span></li>\n<ul class=\"context\">\n".formatted(ent.getKey()));
                        displayedAddress = true;
                    }
                    sb.append("<li>%s := 0x%s</li>\n".formatted(sub.getName(), newSubVal.toString(16)));
                    displayedAny = true;
                }
                if (!displayedAddress) continue;
                sb.append("</ul>\n");
            }
            if (!displayedAny) {
                this.hints.setText("");
            }
            sb.append("</ul></body></html>\n");
            this.hints.setText(sb.toString());
        }

        public void completionActivated(AutocompletionEvent<AssemblyCompletion> e) {
        }
    }

    class EnterKeyListener
    implements KeyListener {
        EnterKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() != '\u001b') {
                AssemblyDualTextField.this.auto.setCompletionListVisible(true);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (e.getKeyCode() == 10 && !AssemblyDualTextField.this.auto.isCompletionListVisible()) {
                AssemblyDualTextField.this.auto.startCompletion((JTextField)e.getComponent());
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    public static enum VisibilityMode {
        INVISIBLE,
        DUAL_VISIBLE,
        SINGLE_VISIBLE;

    }

    static class AssemblySuggestion
    extends AssemblyCompletion {
        public AssemblySuggestion(String text, String display) {
            super(text, display, null, 1);
        }

        @Override
        public boolean getCanDefault() {
            return true;
        }
    }

    static class AssemblyInstruction
    extends AssemblyCompletion {
        private final byte[] data;
        private final ContextChanges contextChanges;

        public AssemblyInstruction(Program program, Language language, Address at, String text, byte[] data, RegisterValue ctxVal, int preference) {
            super("", NumericUtilities.convertBytesToString((byte[])data, (String)" "), preference == 10000 ? FG_PREFERENCE_MOST : (preference == 5000 ? FG_PREFERENCE_MIDDLE : FG_PREFERENCE_LEAST), -preference);
            this.data = data;
            this.contextChanges = new ContextChanges(ctxVal);
            try {
                if (program != null) {
                    this.contextChanges.addFlow(program.getProgramContext(), at.addWrap((long)data.length));
                    language.parse((MemBuffer)new ByteMemBufferImpl(at, data, language.isBigEndian()), (ProcessorContext)this.contextChanges, false);
                }
            }
            catch (InsufficientBytesException | UnknownInstructionException e) {
                Msg.error((Object)this, (Object)("Cannot disassembly just-assembled instruction?: " + NumericUtilities.convertBytesToString((byte[])data)));
            }
            this.adjustOrderByContextChanges(program);
        }

        private void adjustOrderByContextChanges(Program program) {
            if (program == null) {
                return;
            }
            ProgramContext ctx = program.getProgramContext();
            Register ctxReg = ctx.getBaseContextRegister();
            for (Map.Entry<Address, RegisterValue> ent : this.contextChanges.contextsOut.entrySet()) {
                RegisterValue defVal = ctx.getDefaultDisassemblyContext();
                RegisterValue newVal = defVal.combineValues(ent.getValue());
                RegisterValue curVal = defVal.combineValues(ctx.getRegisterValue(ctxReg, ent.getKey()));
                BigInteger changed = newVal.getUnsignedValueIgnoreMask().xor(curVal.getUnsignedValueIgnoreMask());
                this.order += changed.bitCount();
            }
        }

        public byte[] getData() {
            return this.data;
        }

        @Override
        public int compareTo(AssemblyCompletion ac) {
            if (this.order != ac.order) {
                return this.order - ac.order;
            }
            if (!(ac instanceof AssemblyInstruction)) {
                return super.compareTo(ac);
            }
            AssemblyInstruction that = (AssemblyInstruction)ac;
            if (this.data.length != that.data.length) {
                return this.data.length - that.data.length;
            }
            return super.compareTo(ac);
        }
    }

    static class AssemblyError
    extends AssemblyCompletion {
        private String text;

        public AssemblyError(String text, String desc) {
            super(text, desc, (Color)GThemeDefaults.Colors.ERROR, 1);
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }

    public class AssemblyDualTextFieldDemo
    implements GhidraLaunchable {
        public final LanguageID DEMO_LANG_ID = new LanguageID("x86:LE:64:default");
        public final String ADDR_FORMAT = "@%08x:";
        Address curAddr;

        public AssemblyDualTextFieldDemo(AssemblyDualTextField this$0) {
        }

        public void launch(GhidraApplicationLayout layout, String[] args) throws Exception {
            Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)new ApplicationConfiguration());
            final JDialog dialog = new JDialog((Window)null, "Assembly Autocompleter Demo");
            dialog.setLayout(new BorderLayout());
            Box hbox = Box.createHorizontalBox();
            dialog.add((Component)hbox, "North");
            GDLabel addrlabel = new GDLabel(String.format("@%08x:", this.curAddr));
            hbox.add((Component)addrlabel);
            final AssemblyDualTextField input = new AssemblyDualTextField();
            SleighLanguageProvider provider = SleighLanguageProvider.getSleighLanguageProvider();
            SleighLanguage lang = (SleighLanguage)provider.getLanguage(this.DEMO_LANG_ID);
            this.curAddr = lang.getDefaultSpace().getAddress(0L);
            input.setAssembler(Assemblers.getAssembler((Language)lang));
            input.setAddress(this.curAddr);
            hbox.add(input.getAssemblyField());
            hbox.add(input.getMnemonicField());
            hbox.add(Box.createHorizontalStrut(10));
            hbox.add(input.getOperandsField());
            JTextArea asm = new JTextArea();
            asm.setEditable(false);
            asm.setLineWrap(true);
            asm.setWrapStyleWord(false);
            dialog.add((Component)asm, "Center");
            input.getAutocompleter().addAutocompletionListener(arg_0 -> this.lambda$launch$0(asm, input, (JLabel)addrlabel, arg_0));
            final AtomicReference<VisibilityMode> vis = new AtomicReference<VisibilityMode>(VisibilityMode.DUAL_VISIBLE);
            input.setVisible(vis.get());
            KeyListener l = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.isAltDown() && e.isShiftDown() && e.getKeyChar() == 'D') {
                        if (vis.get() == VisibilityMode.DUAL_VISIBLE) {
                            vis.set(VisibilityMode.SINGLE_VISIBLE);
                        } else {
                            vis.set(VisibilityMode.DUAL_VISIBLE);
                        }
                        input.setVisible((VisibilityMode)((Object)vis.get()));
                        dialog.validate();
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            };
            input.addKeyListener(l);
            asm.setVisible(true);
            dialog.setBounds(2560, 500, 400, 200);
            dialog.setModal(true);
            dialog.setVisible(true);
        }

        private /* synthetic */ void lambda$launch$0(JTextArea asm, AssemblyDualTextField input, JLabel addrlabel, AutocompletionEvent e) {
            if (e.getSelection() instanceof AssemblyInstruction) {
                AssemblyInstruction ins = (AssemblyInstruction)e.getSelection();
                String data = NumericUtilities.convertBytesToString((byte[])ins.getData());
                asm.setText(asm.getText() + data);
                input.clear();
                this.curAddr = this.curAddr.addWrap((long)ins.getData().length);
                input.setAddress(this.curAddr);
                addrlabel.setText(String.format("@%08x:", this.curAddr));
            }
        }
    }

    static class ContextChanges
    implements DisassemblerContextAdapter {
        private final RegisterValue contextIn;
        private final Map<Address, RegisterValue> contextsOut = new TreeMap<Address, RegisterValue>();

        public ContextChanges(RegisterValue contextIn) {
            this.contextIn = contextIn;
        }

        public RegisterValue getRegisterValue(Register register) {
            if (register.getBaseRegister() == this.contextIn.getRegister()) {
                return this.contextIn.getRegisterValue(register);
            }
            return null;
        }

        public void setFutureRegisterValue(Address address, RegisterValue value) {
            RegisterValue current = this.contextsOut.get(address);
            RegisterValue combined = current == null ? value : current.combineValues(value);
            this.contextsOut.put(address, combined);
        }

        public void addFlow(ProgramContext progCtx, Address after) {
            this.contextsOut.put(after, progCtx.getFlowValue(this.contextIn));
        }
    }

    public static class AssemblyCompletion
    implements Comparable<AssemblyCompletion> {
        private final String text;
        private final String display;
        private final Color color;
        protected int order;

        public AssemblyCompletion(String text, String display, Color color, int order) {
            this.text = text;
            this.display = display;
            this.color = color;
            this.order = order;
        }

        public Color getColor() {
            return this.color;
        }

        public String getDisplay() {
            return this.display;
        }

        public String getText() {
            return this.text;
        }

        public boolean getCanDefault() {
            return false;
        }

        public String toString() {
            return this.getDisplay();
        }

        public boolean equals(Object o) {
            if (!(o instanceof AssemblyCompletion)) {
                return false;
            }
            return this.toString().equals(o.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        @Override
        public int compareTo(AssemblyCompletion that) {
            if (this.order != that.order) {
                return this.order - that.order;
            }
            return this.toString().compareTo(that.toString());
        }
    }
}

