/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.cli.command;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.cli.AbstractRootCommandLineParameterHandler;
import org.jkiss.dbeaver.model.cli.CLIException;
import org.jkiss.dbeaver.model.cli.CLIProcessResult;
import org.jkiss.dbeaver.model.cli.CLIUtils;
import org.jkiss.dbeaver.model.cli.model.option.ProjectOption;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.utils.CommonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="auth-models", description={"List available database authentication models"})
public class ListAuthenticationModelParameterHandler
extends AbstractRootCommandLineParameterHandler {
    @CommandLine.Mixin
    protected ProjectOption projectOption;
    @CommandLine.Option(names={"--provider"}, description={"Filter by provider ID"})
    protected String providerId;
    @CommandLine.Option(names={"--driver"}, description={"Filter by driver ID"})
    protected String driverId;
    @CommandLine.Option(names={"--datasource"}, description={"Filter by datasource ID or name"})
    protected String datasourceId;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() throws CLIException {
        DBPDataSourceProviderRegistry dataSourceProviderRegistry = DBWorkbench.getPlatform().getDataSourceProviderRegistry();
        List<DBPAuthModelDescriptor> authModels = dataSourceProviderRegistry.getAllAuthModels();
        ArrayList<DBPDriver> applicableDrivers = new ArrayList<DBPDriver>();
        if (CommonUtils.isNotEmpty((String)this.datasourceId)) {
            DBPDataSourceContainer dataSource = CLIUtils.findDataSource(CLIUtils.findProject(this.projectOption.getProjectIdOrName(), this.context()), this.datasourceId);
            DBPDriver driver = dataSource.getDriver();
            applicableDrivers.add(driver);
            authModels = authModels.stream().filter(am -> am.isApplicableTo(driver)).toList();
        } else if (CommonUtils.isNotEmpty((String)this.driverId)) {
            DBPDriver driver = dataSourceProviderRegistry.findDriver(this.driverId);
            if (driver == null) throw new CLIException("Can't find driver '" + this.driverId + "'", 2);
            applicableDrivers.add(driver);
            authModels = authModels.stream().filter(am -> am.isApplicableTo(driver)).toList();
        } else if (CommonUtils.isNotEmpty((String)this.providerId)) {
            DBPDataSourceProviderDescriptor provider = dataSourceProviderRegistry.getDataSourceProvider(this.providerId);
            if (provider == null) throw new CLIException("Can't find provider '" + this.providerId + "'", 2);
            applicableDrivers.addAll(provider.getEnabledDrivers());
            authModels = authModels.stream().filter(am -> applicableDrivers.stream().anyMatch(arg_0 -> ((DBPAuthModelDescriptor)am).isApplicableTo(arg_0))).toList();
        }
        this.context().addResult(ListAuthenticationModelParameterHandler.getConsoleOutput((List<? extends DBPAuthModelDescriptor>)authModels, applicableDrivers));
        this.context().setPostAction(CLIProcessResult.PostAction.SHUTDOWN);
    }

    @NotNull
    private static String getConsoleOutput(List<? extends DBPAuthModelDescriptor> authModels, List<DBPDriver> applicableDrivers) {
        StringBuilder outBuilder = new StringBuilder();
        for (DBPAuthModelDescriptor dBPAuthModelDescriptor : authModels) {
            outBuilder.append(String.format("Auth Model ID: %s, Name: %s, Description: %s%n", dBPAuthModelDescriptor.getId(), dBPAuthModelDescriptor.getName(), dBPAuthModelDescriptor.getDescription()));
            String drivers = applicableDrivers.stream().filter(arg_0 -> ((DBPAuthModelDescriptor)dBPAuthModelDescriptor).isApplicableTo(arg_0)).map(DBPDriver::getFullName).collect(Collectors.joining(", "));
            if (!CommonUtils.isEmpty((String)drivers)) {
                outBuilder.append("Applicable Drivers: ").append(drivers).append("\n");
            }
            outBuilder.append("Parameters:\n");
            DBAAuthModel authModelInstance = dBPAuthModelDescriptor.getInstance();
            DBAAuthCredentials credentials = authModelInstance.createCredentials();
            PropertyCollector propertyCollector = new PropertyCollector((Object)credentials, true);
            propertyCollector.collectProperties();
            for (DBPPropertyDescriptor property : propertyCollector.getProperties()) {
                String helpText = ListAuthenticationModelParameterHandler.getHelpText(property);
                outBuilder.append(helpText);
            }
            outBuilder.append("\n");
        }
        return outBuilder.toString();
    }

    @NotNull
    private static String getHelpText(DBPPropertyDescriptor property) {
        String description;
        String displayName = property.getDisplayName();
        String helpText = CommonUtils.equalObjects((Object)displayName, (Object)(description = property.getDescription())) || CommonUtils.isEmpty((String)description) ? "  - %s = %s%n".formatted(property.getId(), CommonUtils.notEmpty((String)displayName)) : "  - %s (%s) = %s%n".formatted(property.getId(), property.getDisplayName(), property.getDescription());
        return helpText;
    }
}

