/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKeyColumn;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolTableCache;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public final class ExasolTableForeignKeyCache
extends JDBCCompositeCache<ExasolSchema, ExasolTable, ExasolTableForeignKey, ExasolTableForeignKeyColumn> {
    private static final String SQL_FK_TAB = "/*snapshot execution*/ select\r\n\t\tCONSTRAINT_NAME,CONSTRAINT_TABLE,CONSTRAINT_SCHEMA,constraint_owner,c.constraint_enabled,constraint_Type,cc.column_name,cc.ordinal_position,cc.referenced_schema,cc.referenced_table,cc.referenced_column\tfrom\r\n\t\t(SELECT * FROM \tEXA_ALL_CONSTRAINTS \t\t\twhere\r\n\t\t\t\tCONSTRAINT_SCHEMA = '%s' and\r\n\t\t\t\tCONSTRAINT_TYPE = 'FOREIGN KEY' AND CONSTRAINT_TABLE = '%s' \r\n        ORDER BY 1,2,3 \r\n        )c\r\n\t\tinner join\r\n\t\t(SELECT * FROM EXA_ALL_CONSTRAINT_COLUMNS \t\t\twhere\r\n\t\t\t\tCONSTRAINT_SCHEMA = '%s' and\r\n\t\t\t\tCONSTRAINT_TYPE = 'FOREIGN KEY' AND CONSTRAINT_TABLE = '%s' \r\n        ORDER BY 1,2,3 \r\n \t\t) cc\r\n\tusing\r\n\t\t\t(\r\n\t\t\t\tCONSTRAINT_SCHEMA, CONSTRAINT_TABLE, CONSTRAINT_NAME, CONSTRAINT_OWNER, CONSTRAINT_TYPE\r\n\t\t\t)\r\n\twhere\r\n\t\tCONSTRAINT_SCHEMA = '%s' and\r\n\t\tCONSTRAINT_TYPE = 'FOREIGN KEY' AND CONSTRAINT_TABLE = '%s' \r\n\torder by\r\n\t\tORDINAL_POSITION";
    private static final String SQL_FK_ALL = "/*snapshot execution*/ select\r\n\t\tCONSTRAINT_NAME,CONSTRAINT_TABLE,CONSTRAINT_SCHEMA,constraint_owner,c.constraint_enabled,constraint_Type,cc.column_name,cc.ordinal_position,cc.referenced_schema,cc.referenced_table,cc.referenced_column\tfrom\r\n\t\t(SELECT * FROM \tEXA_ALL_CONSTRAINTS \t\t\twhere\r\n\t\t\t\tCONSTRAINT_SCHEMA = '%s' and\r\n\t\t\t\tCONSTRAINT_TYPE = 'FOREIGN KEY'\r\n        ORDER BY 1,2,3 \r\n        )c\r\n\t\tinner join\r\n\t\t(SELECT * FROM EXA_ALL_CONSTRAINT_COLUMNS \t\t\twhere\r\n\t\t\t\tCONSTRAINT_SCHEMA = '%s' and\r\n\t\t\t\tCONSTRAINT_TYPE = 'FOREIGN KEY'  \r\n        ORDER BY 1,2,3 \r\n \t\t) cc\r\n\tusing\r\n\t\t\t(\r\n\t\t\t\tCONSTRAINT_SCHEMA, CONSTRAINT_TABLE, CONSTRAINT_NAME, CONSTRAINT_OWNER, CONSTRAINT_TYPE\r\n\t\t\t)\r\n\twhere\r\n\t\tCONSTRAINT_SCHEMA = '%s' and\r\n\t\tCONSTRAINT_TYPE = 'FOREIGN KEY' \r\n\torder by\r\n\t\tORDINAL_POSITION";

    public ExasolTableForeignKeyCache(ExasolTableCache tableCache) {
        super((JDBCStructCache)tableCache, ExasolTable.class, (Object)"CONSTRAINT_TABLE", (Object)"CONSTRAINT_NAME");
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull ExasolSchema exasolSchema, @Nullable ExasolTable forTable) throws SQLException {
        String sql = forTable != null ? String.format(SQL_FK_TAB, ExasolUtils.quoteString(exasolSchema.getName()), ExasolUtils.quoteString(forTable.getName()), ExasolUtils.quoteString(exasolSchema.getName()), ExasolUtils.quoteString(forTable.getName()), ExasolUtils.quoteString(exasolSchema.getName()), ExasolUtils.quoteString(forTable.getName())) : String.format(SQL_FK_ALL, ExasolUtils.quoteString(exasolSchema.getName()), ExasolUtils.quoteString(exasolSchema.getName()), ExasolUtils.quoteString(exasolSchema.getName()));
        JDBCStatement dbStat = session.createStatement();
        dbStat.setQueryString(sql);
        return dbStat;
    }

    @NotNull
    protected ExasolTableForeignKey fetchObject(@NotNull JDBCSession session, @NotNull ExasolSchema ExasolSchema2, @NotNull ExasolTable ExasolTable2, @NotNull String constName, @NotNull JDBCResultSet dbResult) throws DBException {
        return new ExasolTableForeignKey(session.getProgressMonitor(), ExasolTable2, (ResultSet)dbResult);
    }

    @Nullable
    protected ExasolTableForeignKeyColumn[] fetchObjectRow(@NotNull JDBCSession session, @NotNull ExasolTable table, @NotNull ExasolTableForeignKey object, @NotNull JDBCResultSet dbResult) throws DBException {
        ExasolTable refTable;
        String colName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
        ExasolTableColumn tableColumn = table.getAttribute(session.getProgressMonitor(), colName);
        if (tableColumn == null) {
            log.error((Object)("ExasolTableForeignKeyCache : Column '" + colName + "' not found in table '" + table.getFullyQualifiedName(DBPEvaluationContext.UI) + "' ??"));
            return null;
        }
        ExasolTable exasolTable = refTable = object.getReferencedConstraint() == null ? null : object.getReferencedConstraint().getTable();
        if (refTable == null) {
            log.error((Object)("ExasolTableForeignKeyCache : RefTable not found for FK '" + object.getFullyQualifiedName(DBPEvaluationContext.UI) + "' ??"));
            return null;
        }
        String refColName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REFERENCED_COLUMN");
        ExasolTableColumn refColumn = refTable.getAttribute(session.getProgressMonitor(), refColName);
        if (refColumn == null) {
            log.error((Object)("ExasolTableForeignKeyCache : RefColumn '" + refColName + "' not found in table '" + table.getFullyQualifiedName(DBPEvaluationContext.UI) + "' ??"));
            return null;
        }
        return new ExasolTableForeignKeyColumn[]{new ExasolTableForeignKeyColumn(object, tableColumn, refColumn, JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ORDINAL_POSITION"))};
    }

    protected void cacheChildren(@NotNull DBRProgressMonitor monitor, @NotNull ExasolTableForeignKey constraint, @NotNull List<ExasolTableForeignKeyColumn> rows) {
        constraint.setAttributeReferences(rows);
    }
}

