/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.evaluation.ReferenceTracingInvocationUnit;
import proguard.optimize.evaluation.ReferenceTracingValueFactory;
import proguard.util.ArrayUtil;

public class InitializationFinder
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor {
    private static final boolean DEBUG = false;
    public static final int NONE = -1;
    private final PartialEvaluator partialEvaluator;
    private final boolean runPartialEvaluator;
    private int superInitializationOffset;
    private int[] initializationOffsets = new int[8096];
    private InstructionOffsetValue[] uninitializedOffsets = new InstructionOffsetValue[8096];

    public InitializationFinder() {
        this(new ReferenceTracingValueFactory(new BasicValueFactory()));
    }

    private InitializationFinder(ReferenceTracingValueFactory referenceTracingValueFactory) {
        this(new PartialEvaluator(referenceTracingValueFactory, new ReferenceTracingInvocationUnit(new BasicInvocationUnit(referenceTracingValueFactory)), true, referenceTracingValueFactory), true);
    }

    public InitializationFinder(PartialEvaluator partialEvaluator, boolean runPartialEvaluator) {
        this.partialEvaluator = partialEvaluator;
        this.runPartialEvaluator = runPartialEvaluator;
    }

    public boolean isInitializer() {
        return this.superInitializationOffset != -1;
    }

    public int superInitializationOffset() {
        return this.superInitializationOffset;
    }

    public int creationOffset(int initializationOffset) {
        return this.creationOffsetValue(initializationOffset).instructionOffset(0);
    }

    public boolean isInitializedBefore(int offset, int stackEntryIndexBottom) {
        InstructionOffsetValue creationOffsetValue = this.creationOffsetValue(offset, stackEntryIndexBottom);
        return this.isInitializedBefore(offset, creationOffsetValue);
    }

    public boolean isInitializedBefore(int offset, InstructionOffsetValue creationOffsetValue) {
        return !this.uninitializedOffsets[offset].contains(creationOffsetValue.instructionOffset(0));
    }

    public boolean isInitializer(int offset) {
        return this.partialEvaluator.isInitializer(offset);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int codeLength = codeAttribute.u4codeLength;
        this.superInitializationOffset = -1;
        this.initializationOffsets = ArrayUtil.ensureArraySize(this.initializationOffsets, codeLength, -1);
        this.uninitializedOffsets = ArrayUtil.ensureArraySize(this.uninitializedOffsets, codeLength, null);
        if (this.runPartialEvaluator) {
            this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        }
        InstructionOffsetValue currentUninitializedOffsets = method.getName(clazz).equals("<init>") ? new InstructionOffsetValue(0x1000000) : InstructionOffsetValue.EMPTY_VALUE;
        for (int offset = 0; offset < codeLength; ++offset) {
            if (!this.partialEvaluator.isTraced(offset)) continue;
            if (this.partialEvaluator.isExceptionHandler(offset)) {
                currentUninitializedOffsets = InstructionOffsetValue.EMPTY_VALUE;
            }
            if (this.uninitializedOffsets[offset] != null) {
                currentUninitializedOffsets = this.uninitializedOffsets[offset];
            } else {
                this.uninitializedOffsets[offset] = currentUninitializedOffsets;
            }
            if (this.partialEvaluator.isCreation(offset)) {
                currentUninitializedOffsets = currentUninitializedOffsets.add(offset);
            } else if (this.partialEvaluator.isInitializer(offset)) {
                InstructionOffsetValue creationOffsetValue = this.creationOffsetValue(offset);
                int creationOffset = creationOffsetValue.instructionOffset(0);
                if (creationOffsetValue.isMethodParameter(0)) {
                    this.superInitializationOffset = offset;
                } else {
                    this.initializationOffsets[creationOffset] = offset;
                }
                currentUninitializedOffsets = currentUninitializedOffsets.remove(creationOffset);
            }
            InstructionOffsetValue branchTargets = this.partialEvaluator.branchTargets(offset);
            if (branchTargets == null) continue;
            for (int branchIndex = 0; branchIndex < branchTargets.instructionOffsetCount(); ++branchIndex) {
                int branchOffset = branchTargets.instructionOffset(branchIndex);
                if (branchOffset <= offset) continue;
                this.uninitializedOffsets[branchOffset] = currentUninitializedOffsets;
            }
            currentUninitializedOffsets = InstructionOffsetValue.EMPTY_VALUE;
        }
    }

    private InstructionOffsetValue creationOffsetValue(int initializationOffset) {
        int stackEntryIndexBottom = this.partialEvaluator.getStackAfter(initializationOffset).size();
        return this.creationOffsetValue(initializationOffset, stackEntryIndexBottom);
    }

    private InstructionOffsetValue creationOffsetValue(int instructionOffset, int stackEntryIndexBottom) {
        ReferenceValue newReferenceValue = this.partialEvaluator.getStackBefore(instructionOffset).getBottom(stackEntryIndexBottom).referenceValue();
        TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)newReferenceValue;
        return tracedReferenceValue.getTraceValue().instructionOffsetValue();
    }
}

