# coding=utf-8
# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# --------------------------------------------------------------------------------------------

from knack.help_files import helps  # pylint: disable=unused-import
# pylint: disable=line-too-long, too-many-lines

helps['maps'] = """
type: group
short-summary: Manage Azure Maps.
"""

helps['maps account'] = """
type: group
short-summary: Manage Azure Maps accounts.
"""

helps['maps account create'] = """
    type: command
    short-summary: "Create a Maps Account. A Maps Account holds the keys which allow access to the Maps REST APIs."
    parameters:
      - name: --linked-resources
        short-summary: "Sets the resources to be used for Managed Identities based operations for the Map account \
resource."
        long-summary: |
            Usage: --linked-resources unique-name=XX id=XX

            unique-name: Required. A provided name which uniquely identifies the linked resource.
            id: Required. ARM resource id in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupNa\
me}/providers/Microsoft.Storage/accounts/{storageName}'.

            Multiple actions can be specified by using more than one --linked-resources argument.
    examples:
      - name: Create Account with Managed Identities
        text: |-
               az maps account create --type "SystemAssigned, UserAssigned" --user-identities \
"{\\"/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIden\
tity/userAssignedIdentities/identityName\\":{}}" --kind "Gen2" --disable-local-auth false \
--linked-resources id="/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Mic\
rosoft.Storage/accounts/mystorageacc" unique-name="myBatchStorageAccount" --linked-resources \
id="/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Storage/acco\
unts/mystorageacc" unique-name="myBlobDataSource" --tags test="true" --account-name "myMapsAccount" \
--resource-group "myResourceGroup" --sku "S0"
      - name: Create Gen1 Account
        text: |-
               az maps account create --kind "Gen1" --disable-local-auth false --tags \
test="true" --account-name "myMapsAccount" --resource-group "myResourceGroup" --sku "S0"
      - name: Create Gen2 Account
        text: |-
               az maps account create --kind "Gen2" --disable-local-auth true --tags \
test="true" --account-name "myMapsAccount" --resource-group "myResourceGroup" --sku "S0"
"""

helps['maps account delete'] = """
    type: command
    short-summary: "Delete a Maps Account."
    examples:
      - name: DeleteAccount
        text: |-
               az maps account delete --name "myMapsAccount" --resource-group "myResourceGroup"
"""

helps['maps account keys'] = """
type: group
short-summary: Manage Azure Maps account keys.
"""

helps['maps account keys list'] = """
type: command
short-summary: List the keys to use with the Maps APIs.
long-summary: |
    A key is used to authenticate and authorize access to the Maps REST APIs. Only one key is needed at a time; two are given to provide seamless key regeneration.
examples:
  - name: List the keys to use with the Maps APIs (autogenerated)
    text: az maps account keys list --name MyMapsAccount --resource-group MyResourceGroup
    crafted: true
"""

helps['maps account keys renew'] = """
type: command
short-summary: Renew either the primary or secondary key for use with the Maps APIs.
long-summary: |
    This command immediately invalidates old API keys. Only the renewed keys can be used to connect to maps.
"""

helps['maps account list'] = """
type: command
short-summary: Show all maps accounts in a subscription or in a resource group.
"""

helps['maps account show'] = """
type: command
short-summary: Show the details of a maps account.
examples:
  - name: Show the details of a maps account. (autogenerated)
    text: az maps account show --name MyMapsAccount --resource-group MyResourceGroup
    crafted: true
"""

helps['maps account update'] = """
    type: command
    short-summary: "Updates a Maps Account. Only a subset of the parameters may be updated after creation, such as \
Sku, Tags, Properties."
    parameters:
      - name: --linked-resources
        short-summary: "Sets the resources to be used for Managed Identities based operations for the Map account \
resource."
        long-summary: |
            Usage: --linked-resources unique-name=XX id=XX

            unique-name: Required. A provided name which uniquely identifies the linked resource.
            id: Required. ARM resource id in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupNa\
me}/providers/Microsoft.Storage/accounts/{storageName}'.

            Multiple actions can be specified by using more than one --linked-resources argument.
    examples:
      - name: Update Account Managed Identities
        text: |-
               az maps account update --type "SystemAssigned, UserAssigned" --user-identities \
"{\\"/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIden\
tity/userAssignedIdentities/identityName\\":{}}" --kind "Gen2" --linked-resources id="/subscriptions/{subscriptionId}/r\
esourceGroups/{resourceGroupName}/providers/Microsoft.Storage/accounts/{storageName}" unique-name="myBatchStorageAccoun\
t" --account-name "myMapsAccount" --resource-group "myResourceGroup" --sku "S1"
      - name: Update Account Tags
        text: |-
               az maps account update --tags specialTag="true" --account-name "myMapsAccount" --resource-group \
"myResourceGroup" --sku "S0"
      - name: Update to Gen1 Account
        text: |-
               az maps account update --kind "Gen1" --account-name "myMapsAccount" --resource-group \
"myResourceGroup" --sku "S0"
      - name: Update to Gen2 Account
        text: |-
               az maps account update --kind "Gen2" --account-name "myMapsAccount" --resource-group \
"myResourceGroup" --sku "S0"
"""

helps['maps account keys list'] = """
    type: command
    short-summary: "Get the keys to use with the Maps APIs. A key is used to authenticate and authorize access to the \
Maps REST APIs. Only one key is needed at a time; two are given to provide seamless key regeneration."
    examples:
      - name: List Keys
        text: |-
               az maps account keys list --name "myMapsAccount" --resource-group "myResourceGroup"
"""

helps['maps account keys renew'] = """
    type: command
    short-summary: "Regenerate either the primary or secondary key for use with the Maps APIs. The old key will stop \
working immediately."
    examples:
      - name: Renew
        text: |-
               az maps account keys renew --name "myMapsAccount" --key "primary" --resource-group \
"myResourceGroup"
"""

helps['maps map'] = """
    type: group
    short-summary: Manage map with maps
"""

helps['maps map list-operation'] = """
    type: command
    short-summary: "List operations available for the Maps Resource Provider."
    examples:
      - name: Get Operations
        text: |-
               az maps map list-operation
"""
