﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/pipes/Pipes_EXPORTS.h>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Pipes {
namespace Model {

/**
 * <p>The parameters for using a Amazon SQS stream as a source.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/PipeSourceSqsQueueParameters">AWS
 * API Reference</a></p>
 */
class PipeSourceSqsQueueParameters {
 public:
  AWS_PIPES_API PipeSourceSqsQueueParameters() = default;
  AWS_PIPES_API PipeSourceSqsQueueParameters(Aws::Utils::Json::JsonView jsonValue);
  AWS_PIPES_API PipeSourceSqsQueueParameters& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PIPES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The maximum number of records to include in each batch.</p>
   */
  inline int GetBatchSize() const { return m_batchSize; }
  inline bool BatchSizeHasBeenSet() const { return m_batchSizeHasBeenSet; }
  inline void SetBatchSize(int value) {
    m_batchSizeHasBeenSet = true;
    m_batchSize = value;
  }
  inline PipeSourceSqsQueueParameters& WithBatchSize(int value) {
    SetBatchSize(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum length of a time to wait for events.</p>
   */
  inline int GetMaximumBatchingWindowInSeconds() const { return m_maximumBatchingWindowInSeconds; }
  inline bool MaximumBatchingWindowInSecondsHasBeenSet() const { return m_maximumBatchingWindowInSecondsHasBeenSet; }
  inline void SetMaximumBatchingWindowInSeconds(int value) {
    m_maximumBatchingWindowInSecondsHasBeenSet = true;
    m_maximumBatchingWindowInSeconds = value;
  }
  inline PipeSourceSqsQueueParameters& WithMaximumBatchingWindowInSeconds(int value) {
    SetMaximumBatchingWindowInSeconds(value);
    return *this;
  }
  ///@}
 private:
  int m_batchSize{0};

  int m_maximumBatchingWindowInSeconds{0};
  bool m_batchSizeHasBeenSet = false;
  bool m_maximumBatchingWindowInSecondsHasBeenSet = false;
};

}  // namespace Model
}  // namespace Pipes
}  // namespace Aws
