﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ivs/IVS_EXPORTS.h>
#include <aws/ivs/model/PlaybackKeyPair.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IVS {
namespace Model {
class GetPlaybackKeyPairResult {
 public:
  AWS_IVS_API GetPlaybackKeyPairResult() = default;
  AWS_IVS_API GetPlaybackKeyPairResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IVS_API GetPlaybackKeyPairResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <zonbook></zonbook><xhtml></xhtml>
   */
  inline const PlaybackKeyPair& GetKeyPair() const { return m_keyPair; }
  template <typename KeyPairT = PlaybackKeyPair>
  void SetKeyPair(KeyPairT&& value) {
    m_keyPairHasBeenSet = true;
    m_keyPair = std::forward<KeyPairT>(value);
  }
  template <typename KeyPairT = PlaybackKeyPair>
  GetPlaybackKeyPairResult& WithKeyPair(KeyPairT&& value) {
    SetKeyPair(std::forward<KeyPairT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetPlaybackKeyPairResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  PlaybackKeyPair m_keyPair;
  bool m_keyPairHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IVS
}  // namespace Aws
