/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.lang.invoke.MethodHandles;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.event.internal.AbstractFlushingEventListener;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.jboss.logging.Logger;

public class DefaultAutoFlushEventListener
extends AbstractFlushingEventListener
implements AutoFlushEventListener {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), CoreMessageLogger.class, (String)DefaultAutoFlushEventListener.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAutoFlush(AutoFlushEvent event) throws HibernateException {
        block9: {
            EventSource source = event.getSession();
            SessionEventListenerManager eventListenerManager = source.getEventListenerManager();
            EventMonitor eventMonitor = source.getEventMonitor();
            DiagnosticEvent partialFlushEvent = eventMonitor.beginPartialFlushEvent();
            try {
                eventListenerManager.partialFlushStart();
                if (!this.flushMightBeNeeded(source)) break block9;
                ActionQueue actionQueue = source.getActionQueue();
                EventSource session = event.getSession();
                PersistenceContext persistenceContext = session.getPersistenceContextInternal();
                if (!event.isSkipPreFlush()) {
                    this.preFlush(session, persistenceContext);
                }
                int oldSize = actionQueue.numberOfCollectionRemovals();
                this.flushEverythingToExecutions(event, persistenceContext, session);
                if (this.flushIsReallyNeeded(event, source)) {
                    LOG.trace("Need to execute flush");
                    event.setFlushRequired(true);
                    DiagnosticEvent flushEvent = eventMonitor.beginFlushEvent();
                    try {
                        this.performExecutions(source);
                        this.postFlush(source);
                        this.postPostFlush(source);
                    }
                    finally {
                        eventMonitor.completeFlushEvent(flushEvent, event, true);
                    }
                    StatisticsImplementor statistics = source.getFactory().getStatistics();
                    if (statistics.isStatisticsEnabled()) {
                        statistics.flush();
                    }
                    break block9;
                }
                LOG.trace("No need to execute flush");
                event.setFlushRequired(false);
                actionQueue.clearFromFlushNeededCheck(oldSize);
            }
            finally {
                eventMonitor.completePartialFlushEvent(partialFlushEvent, event);
                eventListenerManager.partialFlushEnd(event.getNumberOfEntitiesProcessed(), event.getNumberOfEntitiesProcessed());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAutoPreFlush(EventSource source) throws HibernateException {
        SessionEventListenerManager eventListenerManager = source.getEventListenerManager();
        eventListenerManager.prePartialFlushStart();
        EventMonitor eventMonitor = source.getEventMonitor();
        DiagnosticEvent diagnosticEvent = eventMonitor.beginPrePartialFlush();
        try {
            if (this.flushMightBeNeeded(source)) {
                this.preFlush(source, source.getPersistenceContextInternal());
            }
        }
        finally {
            eventMonitor.completePrePartialFlush(diagnosticEvent, source);
            eventListenerManager.prePartialFlushEnd();
        }
    }

    private boolean flushIsReallyNeeded(AutoFlushEvent event, EventSource source) {
        return source.getHibernateFlushMode() == FlushMode.ALWAYS || source.getActionQueue().areTablesToBeUpdated(event.getQuerySpaces());
    }

    private boolean flushMightBeNeeded(EventSource source) {
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        return !source.getHibernateFlushMode().lessThan(FlushMode.AUTO) && (persistenceContext.getNumberOfManagedEntities() > 0 || persistenceContext.getCollectionEntriesSize() > 0);
    }
}

