# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Update(AAZCommand):
    """Update a connection monitor.
    """

    _aaz_info = {
        "version": "2022-01-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/networkwatchers/{}/connectionmonitors/{}", "2022-01-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.connection_monitor_name = AAZStrArg(
            options=["-n", "--name", "--connection-monitor", "--connection-monitor-name"],
            help="Connection monitor name.",
            required=True,
            id_part="child_name_1",
        )
        _args_schema.watcher_name = AAZStrArg(
            options=["--watcher-name"],
            help="The name of the Network Watcher resource.",
            required=True,
            id_part="name",
        )
        _args_schema.watcher_rg = AAZResourceGroupNameArg(
            options=["-g", "--watcher-rg"],
            help="Name of resource group. You can configure the default group using `az configure --defaults group=<name>`.",
            required=True,
        )
        _args_schema.migrate = AAZStrArg(
            options=["--migrate"],
            help="Value indicating whether connection monitor V1 should be migrated to V2 format.",
        )
        _args_schema.location = AAZStrArg(
            options=["-l", "--location"],
            help="Location. Values from: `az account list-locations`. You can configure the default location using `az configure --defaults location=<location>`.",
            nullable=True,
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            help="Space-separated tags: key[=value] [key[=value] ...]. Use ''to clear existing tags.",
            nullable=True,
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg(
            nullable=True,
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.auto_start = AAZBoolArg(
            options=["--auto-start"],
            arg_group="Properties",
            help="Determines if the connection monitor will start automatically once created.",
            nullable=True,
        )
        _args_schema.destination = AAZObjectArg(
            options=["--destination"],
            arg_group="Properties",
            help="Describes the destination of connection monitor.",
            nullable=True,
        )
        _args_schema.endpoints = AAZListArg(
            options=["--endpoints"],
            arg_group="Properties",
            help="List of connection monitor endpoints.",
            nullable=True,
        )
        _args_schema.monitoring_interval_in_seconds = AAZIntArg(
            options=["--monitor-in-sec", "--monitoring-interval-in-seconds"],
            arg_group="Properties",
            help="Monitoring interval in seconds.",
            nullable=True,
            fmt=AAZIntArgFormat(
                maximum=1800,
                minimum=30,
            ),
        )
        _args_schema.outputs = AAZListArg(
            options=["--outputs"],
            arg_group="Properties",
            help="List of connection monitor outputs.",
            nullable=True,
        )
        _args_schema.source = AAZObjectArg(
            options=["--source"],
            arg_group="Properties",
            help="Describes the source of connection monitor.",
            nullable=True,
        )
        _args_schema.test_configurations = AAZListArg(
            options=["--test-configurations"],
            arg_group="Properties",
            help="List of connection monitor test configurations.",
            nullable=True,
        )
        _args_schema.test_groups = AAZListArg(
            options=["--test-groups"],
            arg_group="Properties",
            help="List of connection monitor test groups.",
            nullable=True,
        )

        destination = cls._args_schema.destination
        destination.address = AAZStrArg(
            options=["address"],
            help="Address of the connection monitor destination (IP or domain name).",
            nullable=True,
        )
        destination.port = AAZIntArg(
            options=["port"],
            help="The destination port used by connection monitor.",
            nullable=True,
            fmt=AAZIntArgFormat(
                maximum=65535,
                minimum=0,
            ),
        )
        destination.resource_id = AAZStrArg(
            options=["resource-id"],
            help="The ID of the resource used as the destination by connection monitor.",
            nullable=True,
        )

        endpoints = cls._args_schema.endpoints
        endpoints.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.endpoints.Element
        _element.address = AAZStrArg(
            options=["address"],
            help="Address of the connection monitor endpoint (IP or domain name).",
            nullable=True,
        )
        _element.coverage_level = AAZStrArg(
            options=["coverage-level"],
            help="Test coverage for the endpoint.",
            nullable=True,
            enum={"AboveAverage": "AboveAverage", "Average": "Average", "BelowAverage": "BelowAverage", "Default": "Default", "Full": "Full", "Low": "Low"},
        )
        _element.filter = AAZObjectArg(
            options=["filter"],
            help="Filter for sub-items within the endpoint.",
            nullable=True,
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the connection monitor endpoint.",
        )
        _element.resource_id = AAZStrArg(
            options=["resource-id"],
            help="Resource ID of the connection monitor endpoint.",
            nullable=True,
        )
        _element.scope = AAZObjectArg(
            options=["scope"],
            help="Endpoint scope.",
            nullable=True,
        )
        _element.type = AAZStrArg(
            options=["type"],
            help="The endpoint type.",
            nullable=True,
            enum={"AzureArcVM": "AzureArcVM", "AzureSubnet": "AzureSubnet", "AzureVM": "AzureVM", "AzureVMSS": "AzureVMSS", "AzureVNet": "AzureVNet", "ExternalAddress": "ExternalAddress", "MMAWorkspaceMachine": "MMAWorkspaceMachine", "MMAWorkspaceNetwork": "MMAWorkspaceNetwork"},
        )

        filter = cls._args_schema.endpoints.Element.filter
        filter.items = AAZListArg(
            options=["items"],
            help="List of items in the filter.",
            nullable=True,
        )
        filter.type = AAZStrArg(
            options=["type"],
            help="The behavior of the endpoint filter. Currently only 'Include' is supported.",
            nullable=True,
            enum={"Include": "Include"},
        )

        items = cls._args_schema.endpoints.Element.filter.items
        items.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.endpoints.Element.filter.items.Element
        _element.address = AAZStrArg(
            options=["address"],
            help="The address of the filter item.",
            nullable=True,
        )
        _element.type = AAZStrArg(
            options=["type"],
            help="The type of item included in the filter. Currently only 'AgentAddress' is supported.",
            nullable=True,
            enum={"AgentAddress": "AgentAddress"},
        )

        scope = cls._args_schema.endpoints.Element.scope
        scope.exclude = AAZListArg(
            options=["exclude"],
            help="List of items which needs to be excluded from the endpoint scope.",
            nullable=True,
        )
        scope.include = AAZListArg(
            options=["include"],
            help="List of items which needs to be included to the endpoint scope.",
            nullable=True,
        )

        exclude = cls._args_schema.endpoints.Element.scope.exclude
        exclude.Element = AAZObjectArg(
            nullable=True,
        )
        cls._build_args_connection_monitor_endpoint_scope_item_update(exclude.Element)

        include = cls._args_schema.endpoints.Element.scope.include
        include.Element = AAZObjectArg(
            nullable=True,
        )
        cls._build_args_connection_monitor_endpoint_scope_item_update(include.Element)

        outputs = cls._args_schema.outputs
        outputs.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.outputs.Element
        _element.type = AAZStrArg(
            options=["type"],
            help="Connection monitor output destination type. Currently, only \"Workspace\" is supported.",
            nullable=True,
            enum={"Workspace": "Workspace"},
        )
        _element.workspace_settings = AAZObjectArg(
            options=["workspace-settings"],
            help="Describes the settings for producing output into a log analytics workspace.",
            nullable=True,
        )

        workspace_settings = cls._args_schema.outputs.Element.workspace_settings
        workspace_settings.workspace_resource_id = AAZStrArg(
            options=["workspace-resource-id"],
            help="Log analytics workspace resource ID.",
            nullable=True,
        )

        source = cls._args_schema.source
        source.port = AAZIntArg(
            options=["port"],
            help="The source port used by connection monitor.",
            nullable=True,
            fmt=AAZIntArgFormat(
                maximum=65535,
                minimum=0,
            ),
        )
        source.resource_id = AAZStrArg(
            options=["resource-id"],
            help="The ID of the resource used as the source by connection monitor.",
        )

        test_configurations = cls._args_schema.test_configurations
        test_configurations.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.test_configurations.Element
        _element.http_configuration = AAZObjectArg(
            options=["http-configuration"],
            help="The parameters used to perform test evaluation over HTTP.",
            nullable=True,
        )
        _element.icmp_configuration = AAZObjectArg(
            options=["icmp-configuration"],
            help="The parameters used to perform test evaluation over ICMP.",
            nullable=True,
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the connection monitor test configuration.",
        )
        _element.preferred_ip_version = AAZStrArg(
            options=["preferred-ip-version"],
            help="The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending on other parameters.",
            nullable=True,
            enum={"IPv4": "IPv4", "IPv6": "IPv6"},
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="The protocol to use in test evaluation.",
            enum={"Http": "Http", "Icmp": "Icmp", "Tcp": "Tcp"},
        )
        _element.success_threshold = AAZObjectArg(
            options=["success-threshold"],
            help="The threshold for declaring a test successful.",
            nullable=True,
        )
        _element.tcp_configuration = AAZObjectArg(
            options=["tcp-configuration"],
            help="The parameters used to perform test evaluation over TCP.",
            nullable=True,
        )
        _element.test_frequency_sec = AAZIntArg(
            options=["test-frequency-sec"],
            help="The frequency of test evaluation, in seconds.",
            nullable=True,
        )

        http_configuration = cls._args_schema.test_configurations.Element.http_configuration
        http_configuration.method = AAZStrArg(
            options=["method"],
            help="The HTTP method to use.",
            nullable=True,
            enum={"Get": "Get", "Post": "Post"},
        )
        http_configuration.path = AAZStrArg(
            options=["path"],
            help="The path component of the URI. For instance, \"/dir1/dir2\".",
            nullable=True,
        )
        http_configuration.port = AAZIntArg(
            options=["port"],
            help="The port to connect to.",
            nullable=True,
            fmt=AAZIntArgFormat(
                maximum=65535,
                minimum=0,
            ),
        )
        http_configuration.prefer_https = AAZBoolArg(
            options=["prefer-https"],
            help="Value indicating whether HTTPS is preferred over HTTP in cases where the choice is not explicit.",
            nullable=True,
        )
        http_configuration.request_headers = AAZListArg(
            options=["request-headers"],
            help="The HTTP headers to transmit with the request.",
            nullable=True,
        )
        http_configuration.valid_status_code_ranges = AAZListArg(
            options=["valid-status-code-ranges"],
            help="HTTP status codes to consider successful. For instance, \"2xx,301-304,418\".",
            nullable=True,
        )

        request_headers = cls._args_schema.test_configurations.Element.http_configuration.request_headers
        request_headers.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.test_configurations.Element.http_configuration.request_headers.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The name in HTTP header.",
            nullable=True,
        )
        _element.value = AAZStrArg(
            options=["value"],
            help="The value in HTTP header.",
            nullable=True,
        )

        valid_status_code_ranges = cls._args_schema.test_configurations.Element.http_configuration.valid_status_code_ranges
        valid_status_code_ranges.Element = AAZStrArg(
            nullable=True,
        )

        icmp_configuration = cls._args_schema.test_configurations.Element.icmp_configuration
        icmp_configuration.disable_trace_route = AAZBoolArg(
            options=["disable-trace-route"],
            help="Value indicating whether path evaluation with trace route should be disabled.",
            nullable=True,
        )

        success_threshold = cls._args_schema.test_configurations.Element.success_threshold
        success_threshold.checks_failed_percent = AAZIntArg(
            options=["checks-failed-percent"],
            help="The maximum percentage of failed checks permitted for a test to evaluate as successful.",
            nullable=True,
        )
        success_threshold.round_trip_time_ms = AAZFloatArg(
            options=["round-trip-time-ms"],
            help="The maximum round-trip time in milliseconds permitted for a test to evaluate as successful.",
            nullable=True,
        )

        tcp_configuration = cls._args_schema.test_configurations.Element.tcp_configuration
        tcp_configuration.destination_port_behavior = AAZStrArg(
            options=["destination-port-behavior"],
            help="Destination port behavior.",
            nullable=True,
            enum={"ListenIfAvailable": "ListenIfAvailable", "None": "None"},
        )
        tcp_configuration.disable_trace_route = AAZBoolArg(
            options=["disable-trace-route"],
            help="Value indicating whether path evaluation with trace route should be disabled.",
            nullable=True,
        )
        tcp_configuration.port = AAZIntArg(
            options=["port"],
            help="The port to connect to.",
            nullable=True,
            fmt=AAZIntArgFormat(
                maximum=65535,
                minimum=0,
            ),
        )

        test_groups = cls._args_schema.test_groups
        test_groups.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.test_groups.Element
        _element.destinations = AAZListArg(
            options=["destinations"],
            help="List of destination endpoint names.",
        )
        _element.disable = AAZBoolArg(
            options=["disable"],
            help="Value indicating whether test group is disabled.",
            nullable=True,
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the connection monitor test group.",
        )
        _element.sources = AAZListArg(
            options=["sources"],
            help="List of source endpoint names.",
        )
        _element.test_configurations = AAZListArg(
            options=["test-configurations"],
            help="List of test configuration names.",
        )

        destinations = cls._args_schema.test_groups.Element.destinations
        destinations.Element = AAZStrArg(
            nullable=True,
        )

        sources = cls._args_schema.test_groups.Element.sources
        sources.Element = AAZStrArg(
            nullable=True,
        )

        test_configurations = cls._args_schema.test_groups.Element.test_configurations
        test_configurations.Element = AAZStrArg(
            nullable=True,
        )

        # define Arg Group "V2"

        _args_schema = cls._args_schema
        _args_schema.notes = AAZStrArg(
            options=["--notes"],
            arg_group="V2",
            help="Optional notes to be associated with the connection monitor.",
            nullable=True,
        )
        return cls._args_schema

    _args_connection_monitor_endpoint_scope_item_update = None

    @classmethod
    def _build_args_connection_monitor_endpoint_scope_item_update(cls, _schema):
        if cls._args_connection_monitor_endpoint_scope_item_update is not None:
            _schema.address = cls._args_connection_monitor_endpoint_scope_item_update.address
            return

        cls._args_connection_monitor_endpoint_scope_item_update = AAZObjectArg(
            nullable=True,
        )

        connection_monitor_endpoint_scope_item_update = cls._args_connection_monitor_endpoint_scope_item_update
        connection_monitor_endpoint_scope_item_update.address = AAZStrArg(
            options=["address"],
            help="The address of the endpoint item. Supported types are IPv4/IPv6 subnet mask or IPv4/IPv6 IP address.",
            nullable=True,
        )

        _schema.address = cls._args_connection_monitor_endpoint_scope_item_update.address

    def _execute_operations(self):
        self.pre_operations()
        self.ConnectionMonitorsGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.vars.instance)
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.vars.instance)
        yield self.ConnectionMonitorsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_update(self, instance):
        pass

    @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class ConnectionMonitorsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "connectionMonitorName", self.ctx.args.connection_monitor_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "networkWatcherName", self.ctx.args.watcher_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.watcher_rg,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_connection_monitor_result_read(cls._schema_on_200)

            return cls._schema_on_200

    class ConnectionMonitorsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "connectionMonitorName", self.ctx.args.connection_monitor_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "networkWatcherName", self.ctx.args.watcher_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.watcher_rg,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "migrate", self.ctx.args.migrate,
                ),
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _UpdateHelper._build_schema_connection_monitor_result_read(cls._schema_on_200_201)

            return cls._schema_on_200_201

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.vars.instance)

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("location", AAZStrType, ".location")
            _builder.set_prop("properties", AAZObjectType, ".", typ_kwargs={"flags": {"required": True, "client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("autoStart", AAZBoolType, ".auto_start")
                properties.set_prop("destination", AAZObjectType, ".destination")
                properties.set_prop("endpoints", AAZListType, ".endpoints")
                properties.set_prop("monitoringIntervalInSeconds", AAZIntType, ".monitoring_interval_in_seconds")
                properties.set_prop("notes", AAZStrType, ".notes")
                properties.set_prop("outputs", AAZListType, ".outputs")
                properties.set_prop("source", AAZObjectType, ".source")
                properties.set_prop("testConfigurations", AAZListType, ".test_configurations")
                properties.set_prop("testGroups", AAZListType, ".test_groups")

            destination = _builder.get(".properties.destination")
            if destination is not None:
                destination.set_prop("address", AAZStrType, ".address")
                destination.set_prop("port", AAZIntType, ".port")
                destination.set_prop("resourceId", AAZStrType, ".resource_id")

            endpoints = _builder.get(".properties.endpoints")
            if endpoints is not None:
                endpoints.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.endpoints[]")
            if _elements is not None:
                _elements.set_prop("address", AAZStrType, ".address")
                _elements.set_prop("coverageLevel", AAZStrType, ".coverage_level")
                _elements.set_prop("filter", AAZObjectType, ".filter")
                _elements.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("resourceId", AAZStrType, ".resource_id")
                _elements.set_prop("scope", AAZObjectType, ".scope")
                _elements.set_prop("type", AAZStrType, ".type")

            filter = _builder.get(".properties.endpoints[].filter")
            if filter is not None:
                filter.set_prop("items", AAZListType, ".items")
                filter.set_prop("type", AAZStrType, ".type")

            items = _builder.get(".properties.endpoints[].filter.items")
            if items is not None:
                items.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.endpoints[].filter.items[]")
            if _elements is not None:
                _elements.set_prop("address", AAZStrType, ".address")
                _elements.set_prop("type", AAZStrType, ".type")

            scope = _builder.get(".properties.endpoints[].scope")
            if scope is not None:
                scope.set_prop("exclude", AAZListType, ".exclude")
                scope.set_prop("include", AAZListType, ".include")

            exclude = _builder.get(".properties.endpoints[].scope.exclude")
            if exclude is not None:
                _UpdateHelper._build_schema_connection_monitor_endpoint_scope_item_update(exclude.set_elements(AAZObjectType, "."))

            include = _builder.get(".properties.endpoints[].scope.include")
            if include is not None:
                _UpdateHelper._build_schema_connection_monitor_endpoint_scope_item_update(include.set_elements(AAZObjectType, "."))

            outputs = _builder.get(".properties.outputs")
            if outputs is not None:
                outputs.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.outputs[]")
            if _elements is not None:
                _elements.set_prop("type", AAZStrType, ".type")
                _elements.set_prop("workspaceSettings", AAZObjectType, ".workspace_settings")

            workspace_settings = _builder.get(".properties.outputs[].workspaceSettings")
            if workspace_settings is not None:
                workspace_settings.set_prop("workspaceResourceId", AAZStrType, ".workspace_resource_id")

            source = _builder.get(".properties.source")
            if source is not None:
                source.set_prop("port", AAZIntType, ".port")
                source.set_prop("resourceId", AAZStrType, ".resource_id", typ_kwargs={"flags": {"required": True}})

            test_configurations = _builder.get(".properties.testConfigurations")
            if test_configurations is not None:
                test_configurations.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.testConfigurations[]")
            if _elements is not None:
                _elements.set_prop("httpConfiguration", AAZObjectType, ".http_configuration")
                _elements.set_prop("icmpConfiguration", AAZObjectType, ".icmp_configuration")
                _elements.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("preferredIPVersion", AAZStrType, ".preferred_ip_version")
                _elements.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("successThreshold", AAZObjectType, ".success_threshold")
                _elements.set_prop("tcpConfiguration", AAZObjectType, ".tcp_configuration")
                _elements.set_prop("testFrequencySec", AAZIntType, ".test_frequency_sec")

            http_configuration = _builder.get(".properties.testConfigurations[].httpConfiguration")
            if http_configuration is not None:
                http_configuration.set_prop("method", AAZStrType, ".method")
                http_configuration.set_prop("path", AAZStrType, ".path")
                http_configuration.set_prop("port", AAZIntType, ".port")
                http_configuration.set_prop("preferHTTPS", AAZBoolType, ".prefer_https")
                http_configuration.set_prop("requestHeaders", AAZListType, ".request_headers")
                http_configuration.set_prop("validStatusCodeRanges", AAZListType, ".valid_status_code_ranges")

            request_headers = _builder.get(".properties.testConfigurations[].httpConfiguration.requestHeaders")
            if request_headers is not None:
                request_headers.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.testConfigurations[].httpConfiguration.requestHeaders[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("value", AAZStrType, ".value")

            valid_status_code_ranges = _builder.get(".properties.testConfigurations[].httpConfiguration.validStatusCodeRanges")
            if valid_status_code_ranges is not None:
                valid_status_code_ranges.set_elements(AAZStrType, ".")

            icmp_configuration = _builder.get(".properties.testConfigurations[].icmpConfiguration")
            if icmp_configuration is not None:
                icmp_configuration.set_prop("disableTraceRoute", AAZBoolType, ".disable_trace_route")

            success_threshold = _builder.get(".properties.testConfigurations[].successThreshold")
            if success_threshold is not None:
                success_threshold.set_prop("checksFailedPercent", AAZIntType, ".checks_failed_percent")
                success_threshold.set_prop("roundTripTimeMs", AAZFloatType, ".round_trip_time_ms")

            tcp_configuration = _builder.get(".properties.testConfigurations[].tcpConfiguration")
            if tcp_configuration is not None:
                tcp_configuration.set_prop("destinationPortBehavior", AAZStrType, ".destination_port_behavior")
                tcp_configuration.set_prop("disableTraceRoute", AAZBoolType, ".disable_trace_route")
                tcp_configuration.set_prop("port", AAZIntType, ".port")

            test_groups = _builder.get(".properties.testGroups")
            if test_groups is not None:
                test_groups.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.testGroups[]")
            if _elements is not None:
                _elements.set_prop("destinations", AAZListType, ".destinations", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("disable", AAZBoolType, ".disable")
                _elements.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("sources", AAZListType, ".sources", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("testConfigurations", AAZListType, ".test_configurations", typ_kwargs={"flags": {"required": True}})

            destinations = _builder.get(".properties.testGroups[].destinations")
            if destinations is not None:
                destinations.set_elements(AAZStrType, ".")

            sources = _builder.get(".properties.testGroups[].sources")
            if sources is not None:
                sources.set_elements(AAZStrType, ".")

            test_configurations = _builder.get(".properties.testGroups[].testConfigurations")
            if test_configurations is not None:
                test_configurations.set_elements(AAZStrType, ".")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.vars.instance,
                self.ctx.generic_update_args
            )


class _UpdateHelper:
    """Helper class for Update"""

    @classmethod
    def _build_schema_connection_monitor_endpoint_scope_item_update(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("address", AAZStrType, ".address")

    _schema_connection_monitor_endpoint_scope_item_read = None

    @classmethod
    def _build_schema_connection_monitor_endpoint_scope_item_read(cls, _schema):
        if cls._schema_connection_monitor_endpoint_scope_item_read is not None:
            _schema.address = cls._schema_connection_monitor_endpoint_scope_item_read.address
            return

        cls._schema_connection_monitor_endpoint_scope_item_read = _schema_connection_monitor_endpoint_scope_item_read = AAZObjectType()

        connection_monitor_endpoint_scope_item_read = _schema_connection_monitor_endpoint_scope_item_read
        connection_monitor_endpoint_scope_item_read.address = AAZStrType()

        _schema.address = cls._schema_connection_monitor_endpoint_scope_item_read.address

    _schema_connection_monitor_result_read = None

    @classmethod
    def _build_schema_connection_monitor_result_read(cls, _schema):
        if cls._schema_connection_monitor_result_read is not None:
            _schema.etag = cls._schema_connection_monitor_result_read.etag
            _schema.id = cls._schema_connection_monitor_result_read.id
            _schema.location = cls._schema_connection_monitor_result_read.location
            _schema.name = cls._schema_connection_monitor_result_read.name
            _schema.properties = cls._schema_connection_monitor_result_read.properties
            _schema.tags = cls._schema_connection_monitor_result_read.tags
            _schema.type = cls._schema_connection_monitor_result_read.type
            return

        cls._schema_connection_monitor_result_read = _schema_connection_monitor_result_read = AAZObjectType()

        connection_monitor_result_read = _schema_connection_monitor_result_read
        connection_monitor_result_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        connection_monitor_result_read.id = AAZStrType(
            flags={"read_only": True},
        )
        connection_monitor_result_read.location = AAZStrType()
        connection_monitor_result_read.name = AAZStrType(
            flags={"read_only": True},
        )
        connection_monitor_result_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        connection_monitor_result_read.tags = AAZDictType()
        connection_monitor_result_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_connection_monitor_result_read.properties
        properties.auto_start = AAZBoolType(
            serialized_name="autoStart",
        )
        properties.connection_monitor_type = AAZStrType(
            serialized_name="connectionMonitorType",
            flags={"read_only": True},
        )
        properties.destination = AAZObjectType()
        properties.endpoints = AAZListType()
        properties.monitoring_interval_in_seconds = AAZIntType(
            serialized_name="monitoringIntervalInSeconds",
        )
        properties.monitoring_status = AAZStrType(
            serialized_name="monitoringStatus",
            flags={"read_only": True},
        )
        properties.notes = AAZStrType()
        properties.outputs = AAZListType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.source = AAZObjectType()
        properties.start_time = AAZStrType(
            serialized_name="startTime",
            flags={"read_only": True},
        )
        properties.test_configurations = AAZListType(
            serialized_name="testConfigurations",
        )
        properties.test_groups = AAZListType(
            serialized_name="testGroups",
        )

        destination = _schema_connection_monitor_result_read.properties.destination
        destination.address = AAZStrType()
        destination.port = AAZIntType()
        destination.resource_id = AAZStrType(
            serialized_name="resourceId",
        )

        endpoints = _schema_connection_monitor_result_read.properties.endpoints
        endpoints.Element = AAZObjectType()

        _element = _schema_connection_monitor_result_read.properties.endpoints.Element
        _element.address = AAZStrType()
        _element.coverage_level = AAZStrType(
            serialized_name="coverageLevel",
        )
        _element.filter = AAZObjectType()
        _element.name = AAZStrType(
            flags={"required": True},
        )
        _element.resource_id = AAZStrType(
            serialized_name="resourceId",
        )
        _element.scope = AAZObjectType()
        _element.type = AAZStrType()

        filter = _schema_connection_monitor_result_read.properties.endpoints.Element.filter
        filter.items = AAZListType()
        filter.type = AAZStrType()

        items = _schema_connection_monitor_result_read.properties.endpoints.Element.filter.items
        items.Element = AAZObjectType()

        _element = _schema_connection_monitor_result_read.properties.endpoints.Element.filter.items.Element
        _element.address = AAZStrType()
        _element.type = AAZStrType()

        scope = _schema_connection_monitor_result_read.properties.endpoints.Element.scope
        scope.exclude = AAZListType()
        scope.include = AAZListType()

        exclude = _schema_connection_monitor_result_read.properties.endpoints.Element.scope.exclude
        exclude.Element = AAZObjectType()
        cls._build_schema_connection_monitor_endpoint_scope_item_read(exclude.Element)

        include = _schema_connection_monitor_result_read.properties.endpoints.Element.scope.include
        include.Element = AAZObjectType()
        cls._build_schema_connection_monitor_endpoint_scope_item_read(include.Element)

        outputs = _schema_connection_monitor_result_read.properties.outputs
        outputs.Element = AAZObjectType()

        _element = _schema_connection_monitor_result_read.properties.outputs.Element
        _element.type = AAZStrType()
        _element.workspace_settings = AAZObjectType(
            serialized_name="workspaceSettings",
        )

        workspace_settings = _schema_connection_monitor_result_read.properties.outputs.Element.workspace_settings
        workspace_settings.workspace_resource_id = AAZStrType(
            serialized_name="workspaceResourceId",
        )

        source = _schema_connection_monitor_result_read.properties.source
        source.port = AAZIntType()
        source.resource_id = AAZStrType(
            serialized_name="resourceId",
            flags={"required": True},
        )

        test_configurations = _schema_connection_monitor_result_read.properties.test_configurations
        test_configurations.Element = AAZObjectType()

        _element = _schema_connection_monitor_result_read.properties.test_configurations.Element
        _element.http_configuration = AAZObjectType(
            serialized_name="httpConfiguration",
        )
        _element.icmp_configuration = AAZObjectType(
            serialized_name="icmpConfiguration",
        )
        _element.name = AAZStrType(
            flags={"required": True},
        )
        _element.preferred_ip_version = AAZStrType(
            serialized_name="preferredIPVersion",
        )
        _element.protocol = AAZStrType(
            flags={"required": True},
        )
        _element.success_threshold = AAZObjectType(
            serialized_name="successThreshold",
        )
        _element.tcp_configuration = AAZObjectType(
            serialized_name="tcpConfiguration",
        )
        _element.test_frequency_sec = AAZIntType(
            serialized_name="testFrequencySec",
        )

        http_configuration = _schema_connection_monitor_result_read.properties.test_configurations.Element.http_configuration
        http_configuration.method = AAZStrType()
        http_configuration.path = AAZStrType()
        http_configuration.port = AAZIntType()
        http_configuration.prefer_https = AAZBoolType(
            serialized_name="preferHTTPS",
        )
        http_configuration.request_headers = AAZListType(
            serialized_name="requestHeaders",
        )
        http_configuration.valid_status_code_ranges = AAZListType(
            serialized_name="validStatusCodeRanges",
        )

        request_headers = _schema_connection_monitor_result_read.properties.test_configurations.Element.http_configuration.request_headers
        request_headers.Element = AAZObjectType()

        _element = _schema_connection_monitor_result_read.properties.test_configurations.Element.http_configuration.request_headers.Element
        _element.name = AAZStrType()
        _element.value = AAZStrType()

        valid_status_code_ranges = _schema_connection_monitor_result_read.properties.test_configurations.Element.http_configuration.valid_status_code_ranges
        valid_status_code_ranges.Element = AAZStrType()

        icmp_configuration = _schema_connection_monitor_result_read.properties.test_configurations.Element.icmp_configuration
        icmp_configuration.disable_trace_route = AAZBoolType(
            serialized_name="disableTraceRoute",
        )

        success_threshold = _schema_connection_monitor_result_read.properties.test_configurations.Element.success_threshold
        success_threshold.checks_failed_percent = AAZIntType(
            serialized_name="checksFailedPercent",
        )
        success_threshold.round_trip_time_ms = AAZFloatType(
            serialized_name="roundTripTimeMs",
        )

        tcp_configuration = _schema_connection_monitor_result_read.properties.test_configurations.Element.tcp_configuration
        tcp_configuration.destination_port_behavior = AAZStrType(
            serialized_name="destinationPortBehavior",
        )
        tcp_configuration.disable_trace_route = AAZBoolType(
            serialized_name="disableTraceRoute",
        )
        tcp_configuration.port = AAZIntType()

        test_groups = _schema_connection_monitor_result_read.properties.test_groups
        test_groups.Element = AAZObjectType()

        _element = _schema_connection_monitor_result_read.properties.test_groups.Element
        _element.destinations = AAZListType(
            flags={"required": True},
        )
        _element.disable = AAZBoolType()
        _element.name = AAZStrType(
            flags={"required": True},
        )
        _element.sources = AAZListType(
            flags={"required": True},
        )
        _element.test_configurations = AAZListType(
            serialized_name="testConfigurations",
            flags={"required": True},
        )

        destinations = _schema_connection_monitor_result_read.properties.test_groups.Element.destinations
        destinations.Element = AAZStrType()

        sources = _schema_connection_monitor_result_read.properties.test_groups.Element.sources
        sources.Element = AAZStrType()

        test_configurations = _schema_connection_monitor_result_read.properties.test_groups.Element.test_configurations
        test_configurations.Element = AAZStrType()

        tags = _schema_connection_monitor_result_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_connection_monitor_result_read.etag
        _schema.id = cls._schema_connection_monitor_result_read.id
        _schema.location = cls._schema_connection_monitor_result_read.location
        _schema.name = cls._schema_connection_monitor_result_read.name
        _schema.properties = cls._schema_connection_monitor_result_read.properties
        _schema.tags = cls._schema_connection_monitor_result_read.tags
        _schema.type = cls._schema_connection_monitor_result_read.type


__all__ = ["Update"]
