/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.update_cache;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class MLUpdateModelCacheNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    @Generated
    private static final Logger log = LogManager.getLogger(MLUpdateModelCacheNodeResponse.class);
    private Map<String, String> modelUpdateStatus;

    public MLUpdateModelCacheNodeResponse(DiscoveryNode node, Map<String, String> modelUpdateStatus) {
        super(node);
        this.modelUpdateStatus = modelUpdateStatus;
    }

    public MLUpdateModelCacheNodeResponse(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.modelUpdateStatus = in.readMap(StreamInput::readString, StreamInput::readString);
        }
    }

    public static MLUpdateModelCacheNodeResponse readStats(StreamInput in) throws IOException {
        return new MLUpdateModelCacheNodeResponse(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (!this.isModelUpdateStatusEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.modelUpdateStatus, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("stats");
        if (!this.isModelUpdateStatusEmpty()) {
            for (Map.Entry<String, String> stat : this.modelUpdateStatus.entrySet()) {
                builder.field(stat.getKey(), stat.getValue());
            }
        }
        builder.endObject();
        return builder;
    }

    public boolean isModelUpdateStatusEmpty() {
        return this.modelUpdateStatus == null || this.modelUpdateStatus.isEmpty();
    }

    @Generated
    public Map<String, String> getModelUpdateStatus() {
        return this.modelUpdateStatus;
    }
}

