/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.RateLimiter;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;

@PublicApi(since="1.0.0")
public class RecoverySettings {
    private static final Logger logger = LogManager.getLogger(RecoverySettings.class);
    public static final Setting<ByteSizeValue> INDICES_RECOVERY_MAX_BYTES_PER_SEC_SETTING = Setting.byteSizeSetting("indices.recovery.max_bytes_per_sec", new ByteSizeValue(40L, ByteSizeUnit.MB), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> INDICES_REPLICATION_MAX_BYTES_PER_SEC_SETTING = Setting.byteSizeSetting("indices.replication.max_bytes_per_sec", new ByteSizeValue(-1L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> INDICES_REPLICATION_MERGES_WARMER_MIN_SEGMENT_SIZE_THRESHOLD_SETTING = Setting.byteSizeSetting("indices.replication.merges.warmer.min_segment_size_threshold", new ByteSizeValue(500L, ByteSizeUnit.MB), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> INDICES_MERGED_SEGMENT_REPLICATION_WARMER_ENABLED_SETTING = Setting.boolSetting("indices.replication.merges.warmer.enabled", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> INDICES_MERGED_SEGMENT_REPLICATION_MAX_BYTES_PER_SEC_SETTING = Setting.byteSizeSetting("indices.replication.merges.warmer.max_bytes_per_sec", new ByteSizeValue(-1L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_MERGED_SEGMENT_REPLICATION_TIMEOUT_SETTING = Setting.timeSetting("indices.replication.merges.warmer.timeout", TimeValue.timeValueMinutes((long)15L), TimeValue.timeValueMinutes((long)0L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> INDICES_RECOVERY_MAX_CONCURRENT_FILE_CHUNKS_SETTING = Setting.intSetting("indices.recovery.max_concurrent_file_chunks", 2, 1, 5, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> INDICES_RECOVERY_MAX_CONCURRENT_OPERATIONS_SETTING = Setting.intSetting("indices.recovery.max_concurrent_operations", 1, 1, 4, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> INDICES_RECOVERY_MAX_CONCURRENT_REMOTE_STORE_STREAMS_SETTING = new Setting<Integer>("indices.recovery.max_concurrent_remote_store_streams", s -> Integer.toString(Math.max(1, OpenSearchExecutors.allocatedProcessors(s) / 2)), s -> Setting.parseInt(s, 1, "indices.recovery.max_concurrent_remote_store_streams"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_RECOVERY_RETRY_DELAY_STATE_SYNC_SETTING = Setting.positiveTimeSetting("indices.recovery.retry_delay_state_sync", TimeValue.timeValueMillis((long)500L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_RECOVERY_RETRY_DELAY_NETWORK_SETTING = Setting.positiveTimeSetting("indices.recovery.retry_delay_network", TimeValue.timeValueSeconds((long)5L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_RECOVERY_INTERNAL_ACTION_TIMEOUT_SETTING = Setting.positiveTimeSetting("indices.recovery.internal_action_timeout", TimeValue.timeValueMinutes((long)15L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_RECOVERY_INTERNAL_ACTION_RETRY_TIMEOUT_SETTING = Setting.positiveTimeSetting("indices.recovery.internal_action_retry_timeout", TimeValue.timeValueMinutes((long)1L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_RECOVERY_INTERNAL_LONG_ACTION_TIMEOUT_SETTING = Setting.timeSetting("indices.recovery.internal_action_long_timeout", s -> TimeValue.timeValueMillis((long)(INDICES_RECOVERY_INTERNAL_ACTION_TIMEOUT_SETTING.get((Settings)s).millis() * 2L)), TimeValue.timeValueSeconds((long)0L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_RECOVERY_ACTIVITY_TIMEOUT_SETTING = Setting.timeSetting("indices.recovery.recovery_activity_timeout", INDICES_RECOVERY_INTERNAL_LONG_ACTION_TIMEOUT_SETTING::get, TimeValue.timeValueSeconds((long)0L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_INTERNAL_REMOTE_UPLOAD_TIMEOUT = Setting.timeSetting("indices.recovery.internal_remote_upload_timeout", new TimeValue(1L, TimeUnit.HOURS), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ByteSizeValue DEFAULT_CHUNK_SIZE = new ByteSizeValue(524272L, ByteSizeUnit.BYTES);
    public static final Setting<ByteSizeValue> INDICES_RECOVERY_CHUNK_SIZE_SETTING = Setting.byteSizeSetting("indices.recovery.chunk_size", DEFAULT_CHUNK_SIZE, new ByteSizeValue(1L, ByteSizeUnit.BYTES), new ByteSizeValue(100L, ByteSizeUnit.MB), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> INDICES_TRANSLOG_CONCURRENT_RECOVERY_ENABLE = Setting.boolSetting("indices.translog_concurrent_recovery.enable", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> INDICES_TRANSLOG_CONCURRENT_RECOVERY_BATCH_SIZE = Setting.intSetting("indices.translog_concurrent_recovery.batch_size", 500000, 10000, 1000000, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile ByteSizeValue mergedSegmentWarmerMinSegmentSizeThreshold;
    private volatile ByteSizeValue recoveryMaxBytesPerSec;
    private volatile ByteSizeValue replicationMaxBytesPerSec;
    private volatile boolean mergedSegmentReplicationWarmerEnabled;
    private volatile ByteSizeValue mergedSegmentReplicationMaxBytesPerSec;
    private volatile int maxConcurrentFileChunks;
    private volatile int maxConcurrentOperations;
    private volatile int maxConcurrentRemoteStoreStreams;
    private volatile RateLimiter.SimpleRateLimiter recoveryRateLimiter;
    private volatile RateLimiter.SimpleRateLimiter replicationRateLimiter;
    private volatile RateLimiter.SimpleRateLimiter mergedSegmentReplicationRateLimiter;
    private volatile TimeValue retryDelayStateSync;
    private volatile TimeValue retryDelayNetwork;
    private volatile TimeValue activityTimeout;
    private volatile TimeValue internalActionTimeout;
    private volatile TimeValue internalActionRetryTimeout;
    private volatile TimeValue internalActionLongTimeout;
    private volatile ByteSizeValue chunkSize;
    private volatile TimeValue internalRemoteUploadTimeout;
    private volatile TimeValue mergedSegmentReplicationTimeout;
    private volatile boolean isTranslogConcurrentRecoveryEnable;
    private volatile int translogConcurrentRecoveryBatchSize;

    public RecoverySettings(Settings settings, ClusterSettings clusterSettings) {
        this.retryDelayStateSync = INDICES_RECOVERY_RETRY_DELAY_STATE_SYNC_SETTING.get(settings);
        this.maxConcurrentFileChunks = INDICES_RECOVERY_MAX_CONCURRENT_FILE_CHUNKS_SETTING.get(settings);
        this.maxConcurrentOperations = INDICES_RECOVERY_MAX_CONCURRENT_OPERATIONS_SETTING.get(settings);
        this.maxConcurrentRemoteStoreStreams = INDICES_RECOVERY_MAX_CONCURRENT_REMOTE_STORE_STREAMS_SETTING.get(settings);
        this.retryDelayNetwork = INDICES_RECOVERY_RETRY_DELAY_NETWORK_SETTING.get(settings);
        this.internalActionTimeout = INDICES_RECOVERY_INTERNAL_ACTION_TIMEOUT_SETTING.get(settings);
        this.internalActionRetryTimeout = INDICES_RECOVERY_INTERNAL_ACTION_RETRY_TIMEOUT_SETTING.get(settings);
        this.internalActionLongTimeout = INDICES_RECOVERY_INTERNAL_LONG_ACTION_TIMEOUT_SETTING.get(settings);
        this.activityTimeout = INDICES_RECOVERY_ACTIVITY_TIMEOUT_SETTING.get(settings);
        this.recoveryMaxBytesPerSec = INDICES_RECOVERY_MAX_BYTES_PER_SEC_SETTING.get(settings);
        this.recoveryRateLimiter = this.recoveryMaxBytesPerSec.getBytes() <= 0L ? null : new RateLimiter.SimpleRateLimiter(this.recoveryMaxBytesPerSec.getMbFrac());
        this.replicationMaxBytesPerSec = INDICES_REPLICATION_MAX_BYTES_PER_SEC_SETTING.get(settings);
        this.mergedSegmentReplicationWarmerEnabled = INDICES_MERGED_SEGMENT_REPLICATION_WARMER_ENABLED_SETTING.get(settings);
        this.mergedSegmentReplicationMaxBytesPerSec = INDICES_MERGED_SEGMENT_REPLICATION_MAX_BYTES_PER_SEC_SETTING.get(settings);
        this.mergedSegmentReplicationTimeout = INDICES_MERGED_SEGMENT_REPLICATION_TIMEOUT_SETTING.get(settings);
        this.mergedSegmentWarmerMinSegmentSizeThreshold = INDICES_REPLICATION_MERGES_WARMER_MIN_SEGMENT_SIZE_THRESHOLD_SETTING.get(settings);
        this.replicationRateLimiter = this.getReplicationRateLimiter(this.replicationMaxBytesPerSec);
        this.mergedSegmentReplicationRateLimiter = this.getReplicationRateLimiter(this.mergedSegmentReplicationMaxBytesPerSec);
        logger.debug("using recovery max_bytes_per_sec[{}]", (Object)this.recoveryMaxBytesPerSec);
        this.internalRemoteUploadTimeout = INDICES_INTERNAL_REMOTE_UPLOAD_TIMEOUT.get(settings);
        this.chunkSize = INDICES_RECOVERY_CHUNK_SIZE_SETTING.get(settings);
        this.isTranslogConcurrentRecoveryEnable = INDICES_TRANSLOG_CONCURRENT_RECOVERY_ENABLE.get(settings);
        this.translogConcurrentRecoveryBatchSize = INDICES_TRANSLOG_CONCURRENT_RECOVERY_BATCH_SIZE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_MAX_BYTES_PER_SEC_SETTING, this::setRecoveryMaxBytesPerSec);
        clusterSettings.addSettingsUpdateConsumer(INDICES_REPLICATION_MAX_BYTES_PER_SEC_SETTING, this::setReplicationMaxBytesPerSec);
        clusterSettings.addSettingsUpdateConsumer(INDICES_MERGED_SEGMENT_REPLICATION_WARMER_ENABLED_SETTING, this::setIndicesMergedSegmentReplicationWarmerEnabled);
        clusterSettings.addSettingsUpdateConsumer(INDICES_MERGED_SEGMENT_REPLICATION_MAX_BYTES_PER_SEC_SETTING, this::setMergedSegmentReplicationMaxBytesPerSec);
        clusterSettings.addSettingsUpdateConsumer(INDICES_MERGED_SEGMENT_REPLICATION_TIMEOUT_SETTING, this::setMergedSegmentReplicationTimeout);
        clusterSettings.addSettingsUpdateConsumer(INDICES_REPLICATION_MERGES_WARMER_MIN_SEGMENT_SIZE_THRESHOLD_SETTING, this::setMergedSegmentWarmerMinSegmentSizeThreshold);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_MAX_CONCURRENT_FILE_CHUNKS_SETTING, this::setMaxConcurrentFileChunks);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_MAX_CONCURRENT_OPERATIONS_SETTING, this::setMaxConcurrentOperations);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_MAX_CONCURRENT_REMOTE_STORE_STREAMS_SETTING, this::setMaxConcurrentRemoteStoreStreams);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_RETRY_DELAY_STATE_SYNC_SETTING, this::setRetryDelayStateSync);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_RETRY_DELAY_NETWORK_SETTING, this::setRetryDelayNetwork);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_INTERNAL_ACTION_TIMEOUT_SETTING, this::setInternalActionTimeout);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_INTERNAL_LONG_ACTION_TIMEOUT_SETTING, this::setInternalActionLongTimeout);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_ACTIVITY_TIMEOUT_SETTING, this::setActivityTimeout);
        clusterSettings.addSettingsUpdateConsumer(INDICES_INTERNAL_REMOTE_UPLOAD_TIMEOUT, this::setInternalRemoteUploadTimeout);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_CHUNK_SIZE_SETTING, this::setChunkSize);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_INTERNAL_ACTION_RETRY_TIMEOUT_SETTING, this::setInternalActionRetryTimeout);
        clusterSettings.addSettingsUpdateConsumer(INDICES_TRANSLOG_CONCURRENT_RECOVERY_ENABLE, this::setTranslogConcurrentRecoveryEnable);
        clusterSettings.addSettingsUpdateConsumer(INDICES_TRANSLOG_CONCURRENT_RECOVERY_BATCH_SIZE, this::setTranslogConcurrentRecoveryBatchSize);
    }

    private void setMergedSegmentWarmerMinSegmentSizeThreshold(ByteSizeValue value) {
        this.mergedSegmentWarmerMinSegmentSizeThreshold = value;
    }

    public ByteSizeValue getMergedSegmentWarmerMinSegmentSizeThreshold() {
        return this.mergedSegmentWarmerMinSegmentSizeThreshold;
    }

    public RateLimiter recoveryRateLimiter() {
        return this.recoveryRateLimiter;
    }

    public RateLimiter replicationRateLimiter() {
        return this.replicationRateLimiter;
    }

    public RateLimiter.SimpleRateLimiter mergedSegmentReplicationRateLimiter() {
        return this.mergedSegmentReplicationRateLimiter;
    }

    public TimeValue retryDelayNetwork() {
        return this.retryDelayNetwork;
    }

    public TimeValue retryDelayStateSync() {
        return this.retryDelayStateSync;
    }

    public TimeValue activityTimeout() {
        return this.activityTimeout;
    }

    public TimeValue internalActionTimeout() {
        return this.internalActionTimeout;
    }

    public TimeValue internalActionRetryTimeout() {
        return this.internalActionRetryTimeout;
    }

    public TimeValue internalActionLongTimeout() {
        return this.internalActionLongTimeout;
    }

    public TimeValue internalRemoteUploadTimeout() {
        return this.internalRemoteUploadTimeout;
    }

    public ByteSizeValue getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(ByteSizeValue chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void setRetryDelayStateSync(TimeValue retryDelayStateSync) {
        this.retryDelayStateSync = retryDelayStateSync;
    }

    public void setRetryDelayNetwork(TimeValue retryDelayNetwork) {
        this.retryDelayNetwork = retryDelayNetwork;
    }

    public void setActivityTimeout(TimeValue activityTimeout) {
        this.activityTimeout = activityTimeout;
    }

    public void setInternalActionTimeout(TimeValue internalActionTimeout) {
        this.internalActionTimeout = internalActionTimeout;
    }

    public void setInternalActionLongTimeout(TimeValue internalActionLongTimeout) {
        this.internalActionLongTimeout = internalActionLongTimeout;
    }

    public void setInternalRemoteUploadTimeout(TimeValue internalRemoteUploadTimeout) {
        this.internalRemoteUploadTimeout = internalRemoteUploadTimeout;
    }

    public void setInternalActionRetryTimeout(TimeValue internalActionRetryTimeout) {
        this.internalActionRetryTimeout = internalActionRetryTimeout;
    }

    private void setRecoveryMaxBytesPerSec(ByteSizeValue recoveryMaxBytesPerSec) {
        this.recoveryMaxBytesPerSec = recoveryMaxBytesPerSec;
        if (recoveryMaxBytesPerSec.getBytes() <= 0L) {
            this.recoveryRateLimiter = null;
        } else if (this.recoveryRateLimiter != null) {
            this.recoveryRateLimiter.setMBPerSec(recoveryMaxBytesPerSec.getMbFrac());
        } else {
            this.recoveryRateLimiter = new RateLimiter.SimpleRateLimiter(recoveryMaxBytesPerSec.getMbFrac());
        }
        if (this.replicationMaxBytesPerSec.getBytes() < 0L) {
            this.replicationRateLimiter = this.getReplicationRateLimiter(this.replicationMaxBytesPerSec);
        }
        if (this.mergedSegmentReplicationMaxBytesPerSec.getBytes() < 0L) {
            this.mergedSegmentReplicationRateLimiter = this.getReplicationRateLimiter(this.mergedSegmentReplicationMaxBytesPerSec);
        }
    }

    private void setReplicationMaxBytesPerSec(ByteSizeValue replicationMaxBytesPerSec) {
        this.replicationMaxBytesPerSec = replicationMaxBytesPerSec;
        this.replicationRateLimiter = this.getReplicationRateLimiter(replicationMaxBytesPerSec);
    }

    private RateLimiter.SimpleRateLimiter getReplicationRateLimiter(ByteSizeValue replicationMaxBytesPerSec) {
        if (replicationMaxBytesPerSec.getBytes() >= 0L) {
            if (replicationMaxBytesPerSec.getBytes() == 0L) {
                return null;
            }
            return new RateLimiter.SimpleRateLimiter(replicationMaxBytesPerSec.getMbFrac());
        }
        if (this.recoveryMaxBytesPerSec.getBytes() <= 0L) {
            return null;
        }
        return new RateLimiter.SimpleRateLimiter(this.recoveryMaxBytesPerSec.getMbFrac());
    }

    public TimeValue getMergedSegmentReplicationTimeout() {
        return this.mergedSegmentReplicationTimeout;
    }

    private void setMergedSegmentReplicationMaxBytesPerSec(ByteSizeValue mergedSegmentReplicationMaxBytesPerSec) {
        this.mergedSegmentReplicationMaxBytesPerSec = mergedSegmentReplicationMaxBytesPerSec;
        this.mergedSegmentReplicationRateLimiter = this.getReplicationRateLimiter(mergedSegmentReplicationMaxBytesPerSec);
    }

    public void setMergedSegmentReplicationTimeout(TimeValue mergedSegmentReplicationTimeout) {
        this.mergedSegmentReplicationTimeout = mergedSegmentReplicationTimeout;
    }

    public int getMaxConcurrentFileChunks() {
        return this.maxConcurrentFileChunks;
    }

    private void setMaxConcurrentFileChunks(int maxConcurrentFileChunks) {
        this.maxConcurrentFileChunks = maxConcurrentFileChunks;
    }

    public int getMaxConcurrentOperations() {
        return this.maxConcurrentOperations;
    }

    private void setMaxConcurrentOperations(int maxConcurrentOperations) {
        this.maxConcurrentOperations = maxConcurrentOperations;
    }

    public int getMaxConcurrentRemoteStoreStreams() {
        return this.maxConcurrentRemoteStoreStreams;
    }

    private void setMaxConcurrentRemoteStoreStreams(int maxConcurrentRemoteStoreStreams) {
        this.maxConcurrentRemoteStoreStreams = maxConcurrentRemoteStoreStreams;
    }

    public boolean isMergedSegmentReplicationWarmerEnabled() {
        return this.mergedSegmentReplicationWarmerEnabled;
    }

    public void setIndicesMergedSegmentReplicationWarmerEnabled(boolean mergedSegmentReplicationWarmerEnabled) {
        this.mergedSegmentReplicationWarmerEnabled = mergedSegmentReplicationWarmerEnabled;
    }

    public boolean isTranslogConcurrentRecoveryEnable() {
        return this.isTranslogConcurrentRecoveryEnable;
    }

    private void setTranslogConcurrentRecoveryEnable(boolean translogConcurrentRecoveryEnable) {
        this.isTranslogConcurrentRecoveryEnable = translogConcurrentRecoveryEnable;
    }

    public int getTranslogConcurrentRecoveryBatchSize() {
        return this.translogConcurrentRecoveryBatchSize;
    }

    private void setTranslogConcurrentRecoveryBatchSize(int translogConcurrentRecoveryBatchSize) {
        this.translogConcurrentRecoveryBatchSize = translogConcurrentRecoveryBatchSize;
    }
}

