﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/mediaconnect/MediaConnect_EXPORTS.h>
#include <aws/mediaconnect/model/MessageDetail.h>
#include <aws/mediaconnect/model/NdiSourceMetadataInfo.h>
#include <aws/mediaconnect/model/TransportMediaInfo.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace MediaConnect {
namespace Model {
class DescribeFlowSourceMetadataResult {
 public:
  AWS_MEDIACONNECT_API DescribeFlowSourceMetadataResult() = default;
  AWS_MEDIACONNECT_API DescribeFlowSourceMetadataResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MEDIACONNECT_API DescribeFlowSourceMetadataResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> The ARN of the flow that DescribeFlowSourceMetadata was performed on.</p>
   */
  inline const Aws::String& GetFlowArn() const { return m_flowArn; }
  template <typename FlowArnT = Aws::String>
  void SetFlowArn(FlowArnT&& value) {
    m_flowArnHasBeenSet = true;
    m_flowArn = std::forward<FlowArnT>(value);
  }
  template <typename FlowArnT = Aws::String>
  DescribeFlowSourceMetadataResult& WithFlowArn(FlowArnT&& value) {
    SetFlowArn(std::forward<FlowArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Provides a status code and message regarding issues found with the flow
   * source metadata.</p>
   */
  inline const Aws::Vector<MessageDetail>& GetMessages() const { return m_messages; }
  template <typename MessagesT = Aws::Vector<MessageDetail>>
  void SetMessages(MessagesT&& value) {
    m_messagesHasBeenSet = true;
    m_messages = std::forward<MessagesT>(value);
  }
  template <typename MessagesT = Aws::Vector<MessageDetail>>
  DescribeFlowSourceMetadataResult& WithMessages(MessagesT&& value) {
    SetMessages(std::forward<MessagesT>(value));
    return *this;
  }
  template <typename MessagesT = MessageDetail>
  DescribeFlowSourceMetadataResult& AddMessages(MessagesT&& value) {
    m_messagesHasBeenSet = true;
    m_messages.emplace_back(std::forward<MessagesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The timestamp of the most recent change in metadata for this flow���s
   * source.</p>
   */
  inline const Aws::Utils::DateTime& GetTimestamp() const { return m_timestamp; }
  template <typename TimestampT = Aws::Utils::DateTime>
  void SetTimestamp(TimestampT&& value) {
    m_timestampHasBeenSet = true;
    m_timestamp = std::forward<TimestampT>(value);
  }
  template <typename TimestampT = Aws::Utils::DateTime>
  DescribeFlowSourceMetadataResult& WithTimestamp(TimestampT&& value) {
    SetTimestamp(std::forward<TimestampT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Information about the flow's transport media. </p>
   */
  inline const TransportMediaInfo& GetTransportMediaInfo() const { return m_transportMediaInfo; }
  template <typename TransportMediaInfoT = TransportMediaInfo>
  void SetTransportMediaInfo(TransportMediaInfoT&& value) {
    m_transportMediaInfoHasBeenSet = true;
    m_transportMediaInfo = std::forward<TransportMediaInfoT>(value);
  }
  template <typename TransportMediaInfoT = TransportMediaInfo>
  DescribeFlowSourceMetadataResult& WithTransportMediaInfo(TransportMediaInfoT&& value) {
    SetTransportMediaInfo(std::forward<TransportMediaInfoT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The NDI® specific information about the flow's source. This includes the
   * current active NDI sender, a list of all discovered NDI senders, the associated
   * media streams for the active NDI sender, and any relevant status messages. </p>
   */
  inline const NdiSourceMetadataInfo& GetNdiInfo() const { return m_ndiInfo; }
  template <typename NdiInfoT = NdiSourceMetadataInfo>
  void SetNdiInfo(NdiInfoT&& value) {
    m_ndiInfoHasBeenSet = true;
    m_ndiInfo = std::forward<NdiInfoT>(value);
  }
  template <typename NdiInfoT = NdiSourceMetadataInfo>
  DescribeFlowSourceMetadataResult& WithNdiInfo(NdiInfoT&& value) {
    SetNdiInfo(std::forward<NdiInfoT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeFlowSourceMetadataResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_flowArn;

  Aws::Vector<MessageDetail> m_messages;

  Aws::Utils::DateTime m_timestamp{};

  TransportMediaInfo m_transportMediaInfo;

  NdiSourceMetadataInfo m_ndiInfo;

  Aws::String m_requestId;
  bool m_flowArnHasBeenSet = false;
  bool m_messagesHasBeenSet = false;
  bool m_timestampHasBeenSet = false;
  bool m_transportMediaInfoHasBeenSet = false;
  bool m_ndiInfoHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaConnect
}  // namespace Aws
