﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime/Chime_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Chime {
namespace Model {

/**
 * <p>The Amazon Chime chat room details.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/Room">AWS API
 * Reference</a></p>
 */
class Room {
 public:
  AWS_CHIME_API Room() = default;
  AWS_CHIME_API Room(Aws::Utils::Json::JsonView jsonValue);
  AWS_CHIME_API Room& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CHIME_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The room ID.</p>
   */
  inline const Aws::String& GetRoomId() const { return m_roomId; }
  inline bool RoomIdHasBeenSet() const { return m_roomIdHasBeenSet; }
  template <typename RoomIdT = Aws::String>
  void SetRoomId(RoomIdT&& value) {
    m_roomIdHasBeenSet = true;
    m_roomId = std::forward<RoomIdT>(value);
  }
  template <typename RoomIdT = Aws::String>
  Room& WithRoomId(RoomIdT&& value) {
    SetRoomId(std::forward<RoomIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The room name.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  Room& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Chime account ID.</p>
   */
  inline const Aws::String& GetAccountId() const { return m_accountId; }
  inline bool AccountIdHasBeenSet() const { return m_accountIdHasBeenSet; }
  template <typename AccountIdT = Aws::String>
  void SetAccountId(AccountIdT&& value) {
    m_accountIdHasBeenSet = true;
    m_accountId = std::forward<AccountIdT>(value);
  }
  template <typename AccountIdT = Aws::String>
  Room& WithAccountId(AccountIdT&& value) {
    SetAccountId(std::forward<AccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the room creator.</p>
   */
  inline const Aws::String& GetCreatedBy() const { return m_createdBy; }
  inline bool CreatedByHasBeenSet() const { return m_createdByHasBeenSet; }
  template <typename CreatedByT = Aws::String>
  void SetCreatedBy(CreatedByT&& value) {
    m_createdByHasBeenSet = true;
    m_createdBy = std::forward<CreatedByT>(value);
  }
  template <typename CreatedByT = Aws::String>
  Room& WithCreatedBy(CreatedByT&& value) {
    SetCreatedBy(std::forward<CreatedByT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The room creation timestamp, in ISO 8601 format.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedTimestamp() const { return m_createdTimestamp; }
  inline bool CreatedTimestampHasBeenSet() const { return m_createdTimestampHasBeenSet; }
  template <typename CreatedTimestampT = Aws::Utils::DateTime>
  void SetCreatedTimestamp(CreatedTimestampT&& value) {
    m_createdTimestampHasBeenSet = true;
    m_createdTimestamp = std::forward<CreatedTimestampT>(value);
  }
  template <typename CreatedTimestampT = Aws::Utils::DateTime>
  Room& WithCreatedTimestamp(CreatedTimestampT&& value) {
    SetCreatedTimestamp(std::forward<CreatedTimestampT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The room update timestamp, in ISO 8601 format.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdatedTimestamp() const { return m_updatedTimestamp; }
  inline bool UpdatedTimestampHasBeenSet() const { return m_updatedTimestampHasBeenSet; }
  template <typename UpdatedTimestampT = Aws::Utils::DateTime>
  void SetUpdatedTimestamp(UpdatedTimestampT&& value) {
    m_updatedTimestampHasBeenSet = true;
    m_updatedTimestamp = std::forward<UpdatedTimestampT>(value);
  }
  template <typename UpdatedTimestampT = Aws::Utils::DateTime>
  Room& WithUpdatedTimestamp(UpdatedTimestampT&& value) {
    SetUpdatedTimestamp(std::forward<UpdatedTimestampT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_roomId;

  Aws::String m_name;

  Aws::String m_accountId;

  Aws::String m_createdBy;

  Aws::Utils::DateTime m_createdTimestamp{};

  Aws::Utils::DateTime m_updatedTimestamp{};
  bool m_roomIdHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_accountIdHasBeenSet = false;
  bool m_createdByHasBeenSet = false;
  bool m_createdTimestampHasBeenSet = false;
  bool m_updatedTimestampHasBeenSet = false;
};

}  // namespace Model
}  // namespace Chime
}  // namespace Aws
