// Copyright (c) 2001-2016, Alliance for Open Media. All rights reserved
// Copyright (c) 2017-2019, The rav1e contributors. All rights reserved
//
// This source code is subject to the terms of the BSD 2 Clause License and
// the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
// was not distributed with this source code in the LICENSE file, you can
// obtain it at www.aomedia.org/license/software. If the Alliance for Open
// Media Patent License 1.0 was not distributed with this source code in the
// PATENTS file, you can obtain it at www.aomedia.org/license/patent.

pub const RDO_NUM_BINS: usize = 50;
#[allow(unused)]
pub const RDO_MAX_BIN: usize = 10000;
pub const RATE_EST_MAX_BIN: usize = 100_000;
pub const RDO_QUANT_BINS: usize = 8;
pub const RDO_QUANT_DIV: usize = 256 / RDO_QUANT_BINS;
#[allow(unused)]
pub const RDO_BIN_SIZE: u64 = (RDO_MAX_BIN / RDO_NUM_BINS) as u64;
pub const RATE_EST_BIN_SIZE: u64 = (RATE_EST_MAX_BIN / RDO_NUM_BINS) as u64;

use crate::transform::TxSize;

pub static RDO_RATE_TABLE: [[[u64; RDO_NUM_BINS]; TxSize::TX_SIZES_ALL];
  RDO_QUANT_BINS] = [
  [
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 104,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 707,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 2756,
    ],
    [
      13934, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 7628,
    ],
    [
      3155, 8704, 12726, 17300, 19395, 20872, 22052, 23156, 24014, 25176,
      26269, 27336, 28359, 28967, 29713, 30205, 30847, 31286, 31776, 32355,
      32826, 33232, 33367, 33741, 34095, 34472, 34726, 35087, 35195, 35531,
      35614, 35728, 35934, 35973, 36165, 36360, 36281, 36651, 36759, 36921,
      37014, 37095, 37188, 37012, 37310, 37255, 37157, 37399, 37753, 41014,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 146,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 1159,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      7612, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 4525,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
  ],
  [
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 56,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 446,
    ],
    [
      3456, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 1438,
    ],
    [
      5300, 12376, 13413, 21251, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 1449,
    ],
    [
      468, 2455, 5285, 8433, 10917, 12155, 13651, 14712, 15475, 16484, 17678,
      18613, 19609, 20313, 20833, 21383, 21834, 22277, 22758, 23300, 23686,
      24012, 24419, 24739, 25112, 25439, 25602, 26011, 26256, 26389, 26539,
      26662, 26827, 26946, 27059, 27145, 27358, 27485, 27510, 27509, 27594,
      27720, 27792, 28033, 28029, 28087, 28285, 28548, 28657, 31616,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 69,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      2627, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 668,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      3957, 6158, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 955,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
  ],
  [
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 26,
    ],
    [
      814, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 217,
    ],
    [
      1127, 2725, 4344, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 154,
    ],
    [
      345, 1365, 2879, 4614, 6905, 9707, 9334, 9812, 11542, 14962, 22525,
      28756, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 717,
    ],
    [
      116, 270, 689, 1041, 1618, 2298, 3748, 5051, 5800, 6310, 6909, 7391,
      7745, 8030, 8482, 8996, 9557, 10112, 10633, 11148, 11623, 12152, 12614,
      13089, 13592, 14000, 14425, 14886, 15182, 15630, 15871, 16282, 16506,
      16780, 17018, 17139, 17228, 17411, 17463, 17587, 17723, 17634, 17696,
      17944, 18012, 17950, 18006, 18005, 18182, 22725,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 23,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      873, 2245, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 182,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      519, 1820, 3040, 5457, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 154,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
  ],
  [
    [
      169, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 15,
    ],
    [
      463, 859, 1141, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 76,
    ],
    [
      295, 923, 1607, 2072, 2388, 3105, 4419, 5573, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 65,
    ],
    [
      112, 343, 674, 1102, 1578, 2089, 2648, 3376, 4342, 4869, 5708, 5918,
      5901, 6998, 8658, 8258, 7166, 7837, 9781, 10973, 10590, 11659, 11882,
      12548, 15440, 19254, 22300, 24169, 25287, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 413,
    ],
    [
      60, 105, 217, 365, 586, 798, 1010, 1287, 1563, 1952, 2385, 2825, 3135,
      3158, 3796, 4070, 4377, 4574, 4794, 5032, 5350, 5507, 5762, 5986, 6267,
      6519, 6741, 7016, 7346, 7645, 8040, 8413, 8750, 9012, 9362, 9687, 9982,
      10270, 10558, 10725, 11056, 11204, 11387, 11663, 11752, 11877, 12042,
      12104, 12188, 16345,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      154, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 9,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      327, 950, 1500, 1781, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 78,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      125, 384, 795, 1244, 2031, 2451, 3184, 3711, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 75,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
  ],
  [
    [
      83, 148, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 7,
    ],
    [
      170, 381, 574, 822, 1042, 1186, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 28,
    ],
    [
      89, 233, 449, 680, 867, 1082, 1319, 1445, 1725, 1907, 2163, 2432, 2636,
      3171, 3869, 4433, 4818, 5081, 5327, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 29,
    ],
    [
      43, 112, 190, 282, 370, 477, 587, 725, 913, 1105, 1315, 1542, 1773,
      1992, 2173, 2337, 2526, 2703, 2884, 3072, 3276, 3472, 3668, 3886, 4168,
      4521, 4923, 5082, 4981, 5031, 5290, 5598, 6069, 6710, 7558, 8505, 9363,
      9523, 8687, 7810, 7479, 7697, 8214, 8970, 9562, 9978, 10067, 9798, 9430,
      843,
    ],
    [
      46, 58, 75, 129, 207, 265, 340, 426, 505, 554, 662, 771, 873, 1023,
      1097, 1183, 1270, 1342, 1445, 1561, 1642, 1741, 1852, 1992, 2037, 2170,
      2236, 2339, 2387, 2507, 2713, 2837, 2893, 3108, 3262, 3364, 3466, 3592,
      3758, 3811, 4050, 4191, 4326, 4493, 4607, 4773, 4846, 5055, 5247, 9882,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      81, 155, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 3,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      120, 275, 521, 750, 987, 1167, 1264, 1373, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 55,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      57, 85, 114, 227, 424, 686, 890, 1071, 1436, 1495, 1521, 1956, 2182,
      2247, 2349, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 58,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
  ],
  [
    [
      22, 47, 62, 81, 106, 116, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 2,
    ],
    [
      46, 108, 158, 203, 253, 296, 333, 371, 429, 500, 558, 587, 580, 542,
      505, 502, 529, 554, 590, 612, 632, 645, 678, 684, 687, 735, 716, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 12,
    ],
    [
      24, 56, 96, 144, 195, 247, 297, 343, 387, 427, 463, 499, 533, 568, 605,
      642, 685, 739, 806, 872, 904, 929, 982, 1068, 1168, 1238, 1254, 1246,
      1201, 1202, 1257, 1346, 1445, 1572, 1661, 1755, 1851, 1966, 2062, 2201,
      2290, 2405, 2448, 2482, 2488, 2474, 2367, 2270, 2085, 17,
    ],
    [
      22, 34, 52, 72, 93, 112, 130, 149, 170, 198, 226, 261, 292, 326, 359,
      395, 427, 464, 507, 553, 605, 655, 716, 757, 804, 856, 902, 944, 987,
      1030, 1064, 1114, 1159, 1192, 1226, 1262, 1308, 1339, 1367, 1395, 1440,
      1470, 1504, 1548, 1568, 1604, 1647, 1680, 1715, 1461,
    ],
    [
      40, 42, 47, 54, 72, 98, 111, 130, 148, 159, 182, 200, 231, 246, 285,
      298, 312, 324, 357, 375, 394, 418, 439, 467, 472, 501, 518, 536, 564,
      562, 604, 620, 632, 644, 674, 691, 735, 770, 786, 781, 827, 856, 947,
      939, 993, 1008, 1030, 1092, 1120, 3819,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      11, 38, 44, 35, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 1,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      70, 90, 117, 151, 195, 243, 297, 339, 386, 425, 475, 508, 517, 492, 487,
      494, 510, 499, 524, 617, 599, 652, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 46,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      43, 47, 47, 51, 65, 97, 120, 149, 181, 229, 277, 314, 371, 449, 480,
      499, 435, 616, 671, 604, 596, 586, 679, 832, 927, 876, 960, 923, 1070,
      1101, 1148, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      53,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
  ],
  [
    [
      4, 11, 16, 18, 24, 30, 39, 46, 56, 58, 51, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 0,
    ],
    [
      14, 30, 46, 60, 73, 84, 94, 105, 115, 126, 137, 150, 162, 175, 188, 199,
      207, 213, 217, 226, 235, 251, 263, 284, 301, 319, 336, 351, 363, 373,
      384, 393, 392, 391, 397, 390, 387, 376, 370, 357, 348, 338, 335, 328,
      321, 318, 318, 331, 320, 6,
    ],
    [
      6, 13, 21, 31, 43, 55, 67, 79, 91, 103, 114, 125, 135, 145, 156, 164,
      174, 184, 193, 202, 212, 221, 229, 238, 245, 255, 263, 270, 281, 289,
      299, 308, 317, 326, 332, 343, 349, 357, 368, 374, 385, 399, 405, 417,
      425, 439, 452, 469, 480, 30,
    ],
    [
      16, 17, 20, 23, 27, 31, 35, 39, 43, 48, 52, 57, 62, 68, 73, 78, 84, 90,
      96, 102, 108, 113, 120, 124, 129, 137, 143, 150, 157, 162, 170, 177,
      186, 195, 201, 207, 221, 225, 233, 244, 248, 259, 270, 274, 283, 292,
      302, 311, 320, 624,
    ],
    [
      37, 37, 37, 38, 40, 42, 46, 48, 51, 55, 58, 60, 66, 69, 72, 77, 82, 81,
      86, 89, 93, 97, 98, 102, 107, 114, 116, 119, 128, 132, 130, 135, 137,
      138, 138, 139, 151, 156, 153, 153, 153, 154, 168, 172, 171, 170, 178,
      182, 191, 1284,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      1, 3, 7, 14, 17, 19, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 0,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      47, 52, 58, 63, 69, 73, 79, 84, 88, 94, 101, 106, 114, 124, 136, 141,
      146, 166, 193, 202, 223, 211, 243, 263, 279, 301, 264, 299, 308, 321,
      327, 337, 328, 346, 319, 321, 307, 329, 323, 304, 328, 315, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 33,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      38, 39, 41, 42, 41, 43, 42, 42, 45, 46, 53, 56, 60, 68, 70, 77, 84, 84,
      88, 75, 86, 121, 135, 137, 144, 154, 161, 162, 178, 183, 189, 196, 202,
      245, 286, 295, 251, 270, 265, 242, 242, 233, 182, 326, 183, 447, 294,
      330, 318, 108,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
  ],
  [
    [
      1, 2, 2, 3, 3, 3, 3, 4, 5, 6, 8, 15, 17, 24, 25, 23, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 0,
    ],
    [
      9, 16, 22, 26, 30, 34, 38, 42, 46, 49, 53, 55, 58, 61, 64, 66, 69, 71,
      74, 75, 78, 78, 83, 85, 87, 88, 88, 92, 94, 97, 97, 101, 102, 105, 107,
      106, 110, 113, 115, 119, 118, 117, 122, 126, 129, 129, 126, 131, 134, 6,
    ],
    [
      3, 5, 6, 9, 11, 13, 16, 19, 22, 25, 28, 31, 34, 37, 40, 44, 47, 51, 54,
      58, 62, 65, 68, 72, 75, 78, 79, 84, 88, 91, 95, 96, 100, 103, 106, 107,
      110, 111, 117, 119, 119, 122, 125, 127, 130, 132, 134, 138, 140, 21,
    ],
    [
      11, 13, 13, 15, 16, 17, 18, 18, 19, 21, 22, 24, 25, 27, 28, 29, 31, 32,
      33, 34, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 48, 48, 49, 51, 52,
      54, 55, 56, 57, 59, 60, 61, 62, 63, 64, 66, 67, 69, 181,
    ],
    [
      33, 32, 34, 34, 34, 35, 35, 36, 37, 37, 38, 38, 39, 39, 39, 40, 41, 41,
      42, 43, 43, 44, 45, 45, 46, 47, 47, 48, 50, 50, 51, 52, 53, 52, 52, 53,
      55, 55, 56, 56, 58, 58, 58, 59, 60, 60, 58, 59, 61, 393,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      0, 1, 1, 1, 2, 1, 2, 1, 2, 1, 0, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 0,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      40, 44, 47, 49, 50, 51, 52, 52, 51, 52, 53, 55, 55, 57, 57, 57, 59, 60,
      62, 63, 64, 65, 66, 67, 67, 69, 68, 72, 76, 77, 80, 76, 76, 85, 85, 90,
      92, 98, 87, 87, 88, 98, 94, 103, 107, 98, 107, 109, 109, 31,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      36, 37, 38, 38, 37, 37, 37, 37, 37, 36, 37, 37, 37, 37, 38, 37, 38, 38,
      40, 40, 41, 40, 38, 44, 47, 44, 43, 44, 45, 50, 44, 44, 46, 49, 49, 54,
      58, 56, 64, 63, 62, 60, 54, 54, 59, 59, 65, 57, 60, 78,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
    [
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
      99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999, 99999,
    ],
  ],
];
