// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Role.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.usermgmt {
  public class Role : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("usermgmt.Role:1.0.0", null);

    public Role(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Role(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Role StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Role(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_INVALID_VALUE = 1;

    public class Privilege : ICloneable {
      public object Clone() {
        Privilege copy = new Privilege();
        copy.name = this.name;
        copy.args = this.args;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["name"] = this.name;
        json["args"] = new JsonArray(this.args.Select(
          _value => (JsonValue)(_value)));
        return json;
      }

      public static Privilege Decode(LightJson.JsonObject json, Agent agent) {
        Privilege inst = new Privilege();
        inst.name = (string)json["name"];
        inst.args = new System.Collections.Generic.List<string>(json["args"].AsJsonArray.Select(
          _value => (string)_value));
        return inst;
      }

      public string name = "";
      public System.Collections.Generic.IEnumerable<string> args = new System.Collections.Generic.List<string>();
    }

    public class Info : ICloneable {
      public object Clone() {
        Info copy = new Info();
        copy.description = this.description;
        copy.locked = this.locked;
        copy.privileges = this.privileges;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["description"] = this.description;
        json["locked"] = this.locked;
        json["privileges"] = new JsonArray(this.privileges.Select(
          _value => (JsonValue)(_value.Encode())));
        return json;
      }

      public static Info Decode(LightJson.JsonObject json, Agent agent) {
        Info inst = new Info();
        inst.description = (string)json["description"];
        inst.locked = (bool)json["locked"];
        inst.privileges = new System.Collections.Generic.List<Com.Raritan.Idl.usermgmt.Role.Privilege>(json["privileges"].AsJsonArray.Select(
          _value => Com.Raritan.Idl.usermgmt.Role.Privilege.Decode(_value, agent)));
        return inst;
      }

      public string description = "";
      public bool locked = false;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.usermgmt.Role.Privilege> privileges = new System.Collections.Generic.List<Com.Raritan.Idl.usermgmt.Role.Privilege>();
    }

    public class GetInfoResult {
      public Com.Raritan.Idl.usermgmt.Role.Info _ret_;
    }

    public GetInfoResult getInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInfo", _parameters);
      var _ret = new GetInfoResult();
      _ret._ret_ = Com.Raritan.Idl.usermgmt.Role.Info.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInfo", _parameters,
        _result => {
          try {
            var _ret = new GetInfoResult();
            _ret._ret_ = Com.Raritan.Idl.usermgmt.Role.Info.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class UpdateFullResult {
      public int _ret_;
    }

    public UpdateFullResult updateFull(Com.Raritan.Idl.usermgmt.Role.Info info) {
      var _parameters = new LightJson.JsonObject();
      _parameters["info"] = info.Encode();

      var _result = RpcCall("updateFull", _parameters);
      var _ret = new UpdateFullResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest updateFull(Com.Raritan.Idl.usermgmt.Role.Info info, AsyncRpcResponse<UpdateFullResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return updateFull(info, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest updateFull(Com.Raritan.Idl.usermgmt.Role.Info info, AsyncRpcResponse<UpdateFullResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["info"] = info.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("updateFull", _parameters,
        _result => {
          try {
            var _ret = new UpdateFullResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
