#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2017 Mopi
set -o errexit

###
# else Heart.Break()
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250409.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='else-heart-break'
GAME_NAME='else Heart.Break()'

ARCHIVE_BASE_0_NAME='ElseHeartbreakLinux.tgz'
ARCHIVE_BASE_0_MD5='7030450cadac6234676967ae41f2a732'
ARCHIVE_BASE_0_SIZE='1418045'
ARCHIVE_BASE_0_VERSION='1.0.9-humble160129'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/else-heartbreak'

UNITY3D_NAME='ElseHeartbreak'
UNITY3D_PLUGINS='
ScreenSelector.so'

CONTENT_PATH_DEFAULT='ElseHeartbreakLinux'
## TODO: Check if it is required to build a dedicated package for assets
CONTENT_GAME_ASSETS_FILES="
${UNITY3D_NAME}_Data/*.assets"

USER_PERSISTENT_DIRECTORIES="
${UNITY3D_NAME}_Data/InitData
${UNITY3D_NAME}_Data/Saves"

PACKAGES_LIST='
PKG_BIN
PKG_ASSETS
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_ASSETS
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libGLU.so.1
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXcursor.so.1'

PKG_ASSETS_ID="${GAME_ID}-assets"
PKG_ASSETS_DESCRIPTION='assets'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
