/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef INCLUDED_SW_SOURCE_FILTER_XML_XMLIMPIT_HXX
#define INCLUDED_SW_SOURCE_FILTER_XML_XMLIMPIT_HXX

#include <com/sun/star/xml/sax/XFastAttributeList.hpp>
#include "xmlitmap.hxx"

class SvXMLUnitConverter;
class SfxPoolItem;
class SfxItemSet;
class SvXMLNamespaceMap;
class SvXMLAttrContainerItem;

class SvXMLImportItemMapper
{
    SvXMLItemMapEntriesRef mrMapEntries;

public:
    explicit SvXMLImportItemMapper( SvXMLItemMapEntriesRef aMapEntries );
    virtual ~SvXMLImportItemMapper();

    /** fills the given itemset with the attributes in the given list */
    void importXML( SfxItemSet& rSet,
                    css::uno::Reference< css::xml::sax::XFastAttributeList > const & xAttrList,
                    const SvXMLUnitConverter& rUnitConverter,
                    const SvXMLNamespaceMap& rNamespaceMap );

    /** this method is called for every item that has the
        MID_SW_FLAG_SPECIAL_ITEM_IMPORT flag set */
    virtual bool handleSpecialItem( const SvXMLItemMapEntry& rEntry,
                                    SfxPoolItem& rItem,
                                    SfxItemSet& rSet,
                                    const OUString& rValue,
                                    const SvXMLUnitConverter& rUnitConverter );

    /** this method is called for every item that has the
        MID_SW_FLAG_NO_ITEM_IMPORT flag set */
    virtual bool handleNoItem( const SvXMLItemMapEntry& rEntry,
                               SfxItemSet& rSet,
                               const OUString& rValue,
                               const SvXMLUnitConverter& rUnitConverter,
                               const SvXMLNamespaceMap& rNamespaceMap );

    /** This method is called when all attributes have benn processed. It
      * may be used to remove items that are incomplete */
    virtual void finished(SfxItemSet & rSet,
                          SvXMLUnitConverter const& rUnitConverter) const;

    virtual void setMapEntries(const SvXMLItemMapEntriesRef& rMapEntries);
    inline const SvXMLItemMapEntriesRef& getMapEntries() const;

    /** This method is called for every item that should be set based
        upon an XML attribute value. */
    static bool PutXMLValue(
        SfxPoolItem& rItem,
        const OUString& rValue,
        sal_uInt16 nMemberId,
        const SvXMLUnitConverter& rUnitConverter );
private:
    void importXMLUnknownAttributes( SfxItemSet& rSet,
                    css::uno::Reference< css::xml::sax::XFastAttributeList > const & xAttrList,
                    const SvXMLUnitConverter& rUnitConverter,
                    std::unique_ptr<SvXMLAttrContainerItem>& pUnknownItem );

};

inline const SvXMLItemMapEntriesRef&
SvXMLImportItemMapper::getMapEntries() const
{
    return mrMapEntries;
}

#endif // INCLUDED_SW_SOURCE_FILTER_XML_XMLIMPIT_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
