// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/completion_service.proto

package talent

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Enum to specify the scope of completion.
type CompleteQueryRequest_CompletionScope int32

const (
	// Default value.
	CompleteQueryRequest_COMPLETION_SCOPE_UNSPECIFIED CompleteQueryRequest_CompletionScope = 0
	// Suggestions are based only on the data provided by the client.
	CompleteQueryRequest_TENANT CompleteQueryRequest_CompletionScope = 1
	// Suggestions are based on all jobs data in the system that's visible to
	// the client
	CompleteQueryRequest_PUBLIC CompleteQueryRequest_CompletionScope = 2
)

var CompleteQueryRequest_CompletionScope_name = map[int32]string{
	0: "COMPLETION_SCOPE_UNSPECIFIED",
	1: "TENANT",
	2: "PUBLIC",
}

var CompleteQueryRequest_CompletionScope_value = map[string]int32{
	"COMPLETION_SCOPE_UNSPECIFIED": 0,
	"TENANT":                       1,
	"PUBLIC":                       2,
}

func (x CompleteQueryRequest_CompletionScope) String() string {
	return proto.EnumName(CompleteQueryRequest_CompletionScope_name, int32(x))
}

func (CompleteQueryRequest_CompletionScope) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a6e2d15ed940916e, []int{0, 0}
}

// Enum to specify auto-completion topics.
type CompleteQueryRequest_CompletionType int32

const (
	// Default value.
	CompleteQueryRequest_COMPLETION_TYPE_UNSPECIFIED CompleteQueryRequest_CompletionType = 0
	// Suggest job titles for jobs autocomplete.
	//
	// For [CompletionType.JOB_TITLE][google.cloud.talent.v4beta1.CompleteQueryRequest.CompletionType.JOB_TITLE] type, only open jobs with the same
	// [language_codes][google.cloud.talent.v4beta1.CompleteQueryRequest.language_codes] are returned.
	CompleteQueryRequest_JOB_TITLE CompleteQueryRequest_CompletionType = 1
	// Suggest company names for jobs autocomplete.
	//
	// For [CompletionType.COMPANY_NAME][google.cloud.talent.v4beta1.CompleteQueryRequest.CompletionType.COMPANY_NAME] type,
	// only companies having open jobs with the same [language_codes][google.cloud.talent.v4beta1.CompleteQueryRequest.language_codes] are
	// returned.
	CompleteQueryRequest_COMPANY_NAME CompleteQueryRequest_CompletionType = 2
	// Suggest both job titles and company names for jobs autocomplete.
	//
	// For [CompletionType.COMBINED][google.cloud.talent.v4beta1.CompleteQueryRequest.CompletionType.COMBINED] type, only open jobs with the same
	// [language_codes][google.cloud.talent.v4beta1.CompleteQueryRequest.language_codes] or companies having open jobs with the same
	// [language_codes][google.cloud.talent.v4beta1.CompleteQueryRequest.language_codes] are returned.
	CompleteQueryRequest_COMBINED CompleteQueryRequest_CompletionType = 3
)

var CompleteQueryRequest_CompletionType_name = map[int32]string{
	0: "COMPLETION_TYPE_UNSPECIFIED",
	1: "JOB_TITLE",
	2: "COMPANY_NAME",
	3: "COMBINED",
}

var CompleteQueryRequest_CompletionType_value = map[string]int32{
	"COMPLETION_TYPE_UNSPECIFIED": 0,
	"JOB_TITLE":                   1,
	"COMPANY_NAME":                2,
	"COMBINED":                    3,
}

func (x CompleteQueryRequest_CompletionType) String() string {
	return proto.EnumName(CompleteQueryRequest_CompletionType_name, int32(x))
}

func (CompleteQueryRequest_CompletionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a6e2d15ed940916e, []int{0, 1}
}

// Auto-complete parameters.
type CompleteQueryRequest struct {
	// Required. Resource name of tenant the completion is performed within.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/foo/tenant/bar".
	//
	// If tenant id is unspecified, the default tenant is used, for
	// example, "projects/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The query used to generate suggestions.
	//
	// The maximum number of allowed characters is 255.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// The list of languages of the query. This is
	// the BCP-47 language code, such as "en-US" or "sr-Latn".
	// For more information, see
	// [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
	//
	// The maximum number of allowed characters is 255.
	LanguageCodes []string `protobuf:"bytes,3,rep,name=language_codes,json=languageCodes,proto3" json:"language_codes,omitempty"`
	// Required. Completion result count.
	//
	// The maximum allowed page size is 10.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If provided, restricts completion to specified company.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}", for
	// example, "projects/foo/tenants/bar/companies/baz".
	//
	// If tenant id is unspecified, the default tenant is used, for
	// example, "projects/foo".
	Company string `protobuf:"bytes,5,opt,name=company,proto3" json:"company,omitempty"`
	// The scope of the completion. The defaults is [CompletionScope.PUBLIC][google.cloud.talent.v4beta1.CompleteQueryRequest.CompletionScope.PUBLIC].
	Scope CompleteQueryRequest_CompletionScope `protobuf:"varint,6,opt,name=scope,proto3,enum=google.cloud.talent.v4beta1.CompleteQueryRequest_CompletionScope" json:"scope,omitempty"`
	// The completion topic. The default is [CompletionType.COMBINED][google.cloud.talent.v4beta1.CompleteQueryRequest.CompletionType.COMBINED].
	Type                 CompleteQueryRequest_CompletionType `protobuf:"varint,7,opt,name=type,proto3,enum=google.cloud.talent.v4beta1.CompleteQueryRequest_CompletionType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *CompleteQueryRequest) Reset()         { *m = CompleteQueryRequest{} }
func (m *CompleteQueryRequest) String() string { return proto.CompactTextString(m) }
func (*CompleteQueryRequest) ProtoMessage()    {}
func (*CompleteQueryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6e2d15ed940916e, []int{0}
}

func (m *CompleteQueryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompleteQueryRequest.Unmarshal(m, b)
}
func (m *CompleteQueryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompleteQueryRequest.Marshal(b, m, deterministic)
}
func (m *CompleteQueryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompleteQueryRequest.Merge(m, src)
}
func (m *CompleteQueryRequest) XXX_Size() int {
	return xxx_messageInfo_CompleteQueryRequest.Size(m)
}
func (m *CompleteQueryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CompleteQueryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CompleteQueryRequest proto.InternalMessageInfo

func (m *CompleteQueryRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CompleteQueryRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *CompleteQueryRequest) GetLanguageCodes() []string {
	if m != nil {
		return m.LanguageCodes
	}
	return nil
}

func (m *CompleteQueryRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *CompleteQueryRequest) GetCompany() string {
	if m != nil {
		return m.Company
	}
	return ""
}

func (m *CompleteQueryRequest) GetScope() CompleteQueryRequest_CompletionScope {
	if m != nil {
		return m.Scope
	}
	return CompleteQueryRequest_COMPLETION_SCOPE_UNSPECIFIED
}

func (m *CompleteQueryRequest) GetType() CompleteQueryRequest_CompletionType {
	if m != nil {
		return m.Type
	}
	return CompleteQueryRequest_COMPLETION_TYPE_UNSPECIFIED
}

// Response of auto-complete query.
type CompleteQueryResponse struct {
	// Results of the matching job/company candidates.
	CompletionResults []*CompleteQueryResponse_CompletionResult `protobuf:"bytes,1,rep,name=completion_results,json=completionResults,proto3" json:"completion_results,omitempty"`
	// Additional information for the API invocation, such as the request
	// tracking id.
	Metadata             *ResponseMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CompleteQueryResponse) Reset()         { *m = CompleteQueryResponse{} }
func (m *CompleteQueryResponse) String() string { return proto.CompactTextString(m) }
func (*CompleteQueryResponse) ProtoMessage()    {}
func (*CompleteQueryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6e2d15ed940916e, []int{1}
}

func (m *CompleteQueryResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompleteQueryResponse.Unmarshal(m, b)
}
func (m *CompleteQueryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompleteQueryResponse.Marshal(b, m, deterministic)
}
func (m *CompleteQueryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompleteQueryResponse.Merge(m, src)
}
func (m *CompleteQueryResponse) XXX_Size() int {
	return xxx_messageInfo_CompleteQueryResponse.Size(m)
}
func (m *CompleteQueryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CompleteQueryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CompleteQueryResponse proto.InternalMessageInfo

func (m *CompleteQueryResponse) GetCompletionResults() []*CompleteQueryResponse_CompletionResult {
	if m != nil {
		return m.CompletionResults
	}
	return nil
}

func (m *CompleteQueryResponse) GetMetadata() *ResponseMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// Resource that represents completion results.
type CompleteQueryResponse_CompletionResult struct {
	// The suggestion for the query.
	Suggestion string `protobuf:"bytes,1,opt,name=suggestion,proto3" json:"suggestion,omitempty"`
	// The completion topic.
	Type CompleteQueryRequest_CompletionType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.talent.v4beta1.CompleteQueryRequest_CompletionType" json:"type,omitempty"`
	// The URI of the company image for
	// [COMPANY_NAME][google.cloud.talent.v4beta1.CompleteQueryRequest.CompletionType.COMPANY_NAME].
	ImageUri             string   `protobuf:"bytes,3,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CompleteQueryResponse_CompletionResult) Reset() {
	*m = CompleteQueryResponse_CompletionResult{}
}
func (m *CompleteQueryResponse_CompletionResult) String() string { return proto.CompactTextString(m) }
func (*CompleteQueryResponse_CompletionResult) ProtoMessage()    {}
func (*CompleteQueryResponse_CompletionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6e2d15ed940916e, []int{1, 0}
}

func (m *CompleteQueryResponse_CompletionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompleteQueryResponse_CompletionResult.Unmarshal(m, b)
}
func (m *CompleteQueryResponse_CompletionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompleteQueryResponse_CompletionResult.Marshal(b, m, deterministic)
}
func (m *CompleteQueryResponse_CompletionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompleteQueryResponse_CompletionResult.Merge(m, src)
}
func (m *CompleteQueryResponse_CompletionResult) XXX_Size() int {
	return xxx_messageInfo_CompleteQueryResponse_CompletionResult.Size(m)
}
func (m *CompleteQueryResponse_CompletionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_CompleteQueryResponse_CompletionResult.DiscardUnknown(m)
}

var xxx_messageInfo_CompleteQueryResponse_CompletionResult proto.InternalMessageInfo

func (m *CompleteQueryResponse_CompletionResult) GetSuggestion() string {
	if m != nil {
		return m.Suggestion
	}
	return ""
}

func (m *CompleteQueryResponse_CompletionResult) GetType() CompleteQueryRequest_CompletionType {
	if m != nil {
		return m.Type
	}
	return CompleteQueryRequest_COMPLETION_TYPE_UNSPECIFIED
}

func (m *CompleteQueryResponse_CompletionResult) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.talent.v4beta1.CompleteQueryRequest_CompletionScope", CompleteQueryRequest_CompletionScope_name, CompleteQueryRequest_CompletionScope_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.CompleteQueryRequest_CompletionType", CompleteQueryRequest_CompletionType_name, CompleteQueryRequest_CompletionType_value)
	proto.RegisterType((*CompleteQueryRequest)(nil), "google.cloud.talent.v4beta1.CompleteQueryRequest")
	proto.RegisterType((*CompleteQueryResponse)(nil), "google.cloud.talent.v4beta1.CompleteQueryResponse")
	proto.RegisterType((*CompleteQueryResponse_CompletionResult)(nil), "google.cloud.talent.v4beta1.CompleteQueryResponse.CompletionResult")
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/completion_service.proto", fileDescriptor_a6e2d15ed940916e)
}

var fileDescriptor_a6e2d15ed940916e = []byte{
	// 770 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x95, 0x5f, 0x4f, 0xfb, 0x54,
	0x18, 0xc7, 0x6d, 0xc7, 0xf6, 0xdb, 0xce, 0x0f, 0xb0, 0x1e, 0xff, 0x95, 0x0d, 0xa4, 0x99, 0x21,
	0x2e, 0x46, 0xda, 0x30, 0xb9, 0x82, 0x98, 0xd8, 0x95, 0x9a, 0x4c, 0xd9, 0x1f, 0xbb, 0x12, 0x03,
	0x37, 0xe3, 0xac, 0x3b, 0x94, 0x92, 0xae, 0xa7, 0xf4, 0x9c, 0x42, 0x86, 0xf1, 0xc6, 0xf8, 0x0e,
	0x7c, 0x07, 0x26, 0xbe, 0x19, 0xef, 0xd4, 0x98, 0x78, 0xc9, 0x85, 0xaf, 0x82, 0x0b, 0x63, 0x4e,
	0xdb, 0x41, 0x99, 0x64, 0x84, 0xe8, 0x5d, 0xf7, 0xed, 0xf3, 0xfd, 0x7c, 0x4f, 0xcf, 0x39, 0xcf,
	0x33, 0xb0, 0xeb, 0x12, 0xe2, 0xfa, 0x58, 0x73, 0x7c, 0x12, 0x8f, 0x35, 0x86, 0x7c, 0x1c, 0x30,
	0xed, 0x6a, 0x77, 0x84, 0x19, 0xda, 0xd1, 0x1c, 0x32, 0x09, 0x7d, 0xcc, 0x3c, 0x12, 0x0c, 0x29,
	0x8e, 0xae, 0x3c, 0x07, 0xab, 0x61, 0x44, 0x18, 0x81, 0xb5, 0xd4, 0xa5, 0x26, 0x2e, 0x35, 0x75,
	0xa9, 0x99, 0xab, 0xba, 0x9e, 0x21, 0x51, 0xe8, 0x69, 0x28, 0x08, 0x08, 0x43, 0x9c, 0x40, 0x53,
	0x6b, 0x75, 0x33, 0xf7, 0xf6, 0xcc, 0xc3, 0xfe, 0x78, 0x38, 0xc2, 0xe7, 0xe8, 0xca, 0x23, 0x51,
	0x56, 0xb0, 0x96, 0x2b, 0x88, 0x30, 0x25, 0x71, 0x34, 0x8b, 0xad, 0x36, 0x9e, 0x59, 0xec, 0x84,
	0x04, 0x59, 0xe5, 0xfb, 0x39, 0x88, 0xe3, 0x7b, 0x7c, 0x79, 0xc9, 0x8b, 0xfa, 0xaf, 0x4b, 0xe0,
	0x1d, 0x23, 0xfd, 0x2c, 0xfc, 0x75, 0x8c, 0xa3, 0xa9, 0x85, 0x2f, 0x63, 0x4c, 0x19, 0xdc, 0x07,
	0xa5, 0x10, 0x45, 0x38, 0x60, 0xb2, 0xa0, 0x08, 0x8d, 0x4a, 0xeb, 0xc3, 0x5b, 0x5d, 0xbc, 0xd3,
	0x37, 0x60, 0xed, 0x82, 0x8c, 0xa8, 0x9a, 0xe2, 0x50, 0xe8, 0x51, 0xd5, 0x21, 0x13, 0x8d, 0x13,
	0x50, 0x30, 0xb5, 0x32, 0x0b, 0x5c, 0x03, 0xc5, 0x4b, 0x0e, 0x93, 0xc5, 0xc4, 0x5b, 0xb8, 0xd5,
	0x45, 0x2b, 0x55, 0xe0, 0x16, 0x58, 0xf5, 0x51, 0xe0, 0xc6, 0xc8, 0xc5, 0x43, 0x87, 0x8c, 0x31,
	0x95, 0x0b, 0x4a, 0xa1, 0x51, 0xb1, 0x56, 0x66, 0xaa, 0xc1, 0x45, 0xa8, 0x80, 0x4a, 0xc8, 0x4b,
	0xa8, 0x77, 0x83, 0xe5, 0x25, 0x45, 0x68, 0x14, 0x53, 0x4a, 0x99, 0xab, 0x03, 0xef, 0x06, 0xc3,
	0x3d, 0xf0, 0xca, 0x49, 0x63, 0xe5, 0x62, 0x92, 0xa2, 0xdc, 0xe9, 0x1b, 0x60, 0xe1, 0xf2, 0x66,
	0x06, 0xf8, 0x0d, 0x28, 0x52, 0x87, 0x84, 0x58, 0x2e, 0x29, 0x42, 0x63, 0xb5, 0xa9, 0xab, 0x0b,
	0xce, 0x4f, 0x7d, 0x6a, 0x7b, 0x66, 0xa2, 0x47, 0x82, 0x01, 0x07, 0x59, 0x29, 0x0f, 0xda, 0x60,
	0x89, 0x4d, 0x43, 0x2c, 0xbf, 0x4a, 0xb8, 0x9f, 0xff, 0x17, 0xae, 0x3d, 0x0d, 0xb1, 0x95, 0xd0,
	0xea, 0x5f, 0x81, 0x37, 0xe7, 0xf2, 0xa0, 0x02, 0xd6, 0x8d, 0x5e, 0xa7, 0x7f, 0x68, 0xda, 0xed,
	0x5e, 0x77, 0x38, 0x30, 0x7a, 0x7d, 0x73, 0x78, 0xd4, 0x1d, 0xf4, 0x4d, 0xa3, 0xfd, 0x45, 0xdb,
	0x3c, 0x90, 0xde, 0x80, 0x00, 0x94, 0x6c, 0xb3, 0xab, 0x77, 0x6d, 0x49, 0xe0, 0xcf, 0xfd, 0xa3,
	0xd6, 0x61, 0xdb, 0x90, 0xc4, 0xfa, 0x29, 0x58, 0x7d, 0x1c, 0x02, 0x37, 0x41, 0x2d, 0xc7, 0xb2,
	0x8f, 0xff, 0x85, 0x5a, 0x01, 0x95, 0x2f, 0x7b, 0xad, 0xa1, 0xdd, 0xb6, 0x0f, 0x4d, 0x49, 0x80,
	0x12, 0x58, 0xe6, 0xf5, 0x7a, 0xf7, 0x78, 0xd8, 0xd5, 0x3b, 0xa6, 0x24, 0xc2, 0x65, 0x50, 0x36,
	0x7a, 0x9d, 0x56, 0xbb, 0x6b, 0x1e, 0x48, 0x85, 0xfa, 0xdf, 0x22, 0x78, 0x77, 0xee, 0xe3, 0x68,
	0x48, 0x02, 0x8a, 0x61, 0x04, 0x60, 0xae, 0x87, 0x22, 0x4c, 0x63, 0x9f, 0x51, 0x59, 0x50, 0x0a,
	0x8d, 0xd7, 0x4d, 0xe3, 0x25, 0x9b, 0x95, 0xf2, 0x72, 0xbb, 0x65, 0x25, 0x2c, 0xeb, 0x2d, 0x67,
	0x4e, 0xa1, 0xb0, 0x0d, 0xca, 0x13, 0xcc, 0xd0, 0x18, 0x31, 0x94, 0x5c, 0xc7, 0xd7, 0xcd, 0xed,
	0x85, 0x49, 0x33, 0x78, 0x27, 0x33, 0x59, 0xf7, 0xf6, 0xea, 0xcf, 0x02, 0x90, 0xe6, 0x23, 0xe1,
	0x07, 0x00, 0xd0, 0xd8, 0x75, 0x31, 0xe5, 0x5a, 0xda, 0x2c, 0x56, 0x4e, 0xb9, 0xbf, 0x12, 0xe2,
	0xff, 0x79, 0x25, 0x60, 0x0d, 0x54, 0xbc, 0x09, 0x6f, 0x90, 0x38, 0xf2, 0xe4, 0x42, 0x12, 0x5a,
	0x4e, 0x84, 0xa3, 0xc8, 0x6b, 0xfe, 0x21, 0x02, 0xf0, 0xe0, 0x82, 0x7f, 0x0a, 0x60, 0xe5, 0x11,
	0x19, 0xee, 0xbc, 0x78, 0x15, 0xd5, 0xe6, 0xcb, 0x8f, 0xa7, 0x7e, 0xfa, 0xfd, 0xef, 0x7f, 0xfd,
	0x28, 0x9e, 0x40, 0xed, 0x7e, 0x28, 0x7d, 0x9b, 0x0e, 0x88, 0xcf, 0xc2, 0x88, 0x5c, 0x60, 0x87,
	0x51, 0xed, 0x63, 0x8d, 0xe1, 0x00, 0x05, 0xfc, 0xe9, 0xbb, 0xbd, 0xec, 0xf0, 0xf0, 0xc9, 0x47,
	0x70, 0x6b, 0x81, 0xe5, 0xa1, 0xb0, 0xea, 0xff, 0xa2, 0xbf, 0xfd, 0x44, 0xc7, 0xff, 0xa6, 0x0f,
	0xce, 0x19, 0x0b, 0xe9, 0x9e, 0xa6, 0x5d, 0x5f, 0x5f, 0xcf, 0x8f, 0x03, 0x14, 0xb3, 0xf3, 0x74,
	0x66, 0x6e, 0x87, 0x3e, 0x62, 0x67, 0x24, 0x9a, 0x7c, 0xf2, 0x5c, 0x39, 0x0f, 0x69, 0xfd, 0x20,
	0x80, 0x4d, 0x87, 0x4c, 0x16, 0xed, 0x44, 0xeb, 0xbd, 0x5c, 0xa7, 0xa6, 0xff, 0x11, 0x7d, 0x3e,
	0x68, 0xfb, 0xc2, 0x89, 0x9e, 0xd9, 0x5c, 0xc2, 0x47, 0x9d, 0x4a, 0x22, 0x57, 0x73, 0x71, 0x90,
	0x8c, 0x61, 0xed, 0x21, 0xf2, 0xc9, 0x61, 0xbe, 0x9f, 0xfe, 0xfc, 0x49, 0x2c, 0x18, 0xf6, 0x60,
	0x54, 0x4a, 0x3c, 0x9f, 0xfe, 0x13, 0x00, 0x00, 0xff, 0xff, 0x10, 0x21, 0x1b, 0xcf, 0xac, 0x06,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CompletionClient is the client API for Completion service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CompletionClient interface {
	// Completes the specified prefix with keyword suggestions.
	// Intended for use by a job search auto-complete search box.
	CompleteQuery(ctx context.Context, in *CompleteQueryRequest, opts ...grpc.CallOption) (*CompleteQueryResponse, error)
}

type completionClient struct {
	cc grpc.ClientConnInterface
}

func NewCompletionClient(cc grpc.ClientConnInterface) CompletionClient {
	return &completionClient{cc}
}

func (c *completionClient) CompleteQuery(ctx context.Context, in *CompleteQueryRequest, opts ...grpc.CallOption) (*CompleteQueryResponse, error) {
	out := new(CompleteQueryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.Completion/CompleteQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CompletionServer is the server API for Completion service.
type CompletionServer interface {
	// Completes the specified prefix with keyword suggestions.
	// Intended for use by a job search auto-complete search box.
	CompleteQuery(context.Context, *CompleteQueryRequest) (*CompleteQueryResponse, error)
}

// UnimplementedCompletionServer can be embedded to have forward compatible implementations.
type UnimplementedCompletionServer struct {
}

func (*UnimplementedCompletionServer) CompleteQuery(ctx context.Context, req *CompleteQueryRequest) (*CompleteQueryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CompleteQuery not implemented")
}

func RegisterCompletionServer(s *grpc.Server, srv CompletionServer) {
	s.RegisterService(&_Completion_serviceDesc, srv)
}

func _Completion_CompleteQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CompletionServer).CompleteQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.Completion/CompleteQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CompletionServer).CompleteQuery(ctx, req.(*CompleteQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Completion_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.talent.v4beta1.Completion",
	HandlerType: (*CompletionServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CompleteQuery",
			Handler:    _Completion_CompleteQuery_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/talent/v4beta1/completion_service.proto",
}
