//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armvideoanalyzer_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/videoanalyzer/armvideoanalyzer"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/videoanalyzer/resource-manager/Microsoft.Media/preview/2021-11-01-preview/examples/pipeline-topology-list.json
func ExamplePipelineTopologiesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armvideoanalyzer.NewPipelineTopologiesClient("591e76c3-3e97-44db-879c-3e2b12961b62", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListPager("testrg",
		"testaccount2",
		&armvideoanalyzer.PipelineTopologiesClientListOptions{Filter: nil,
			Top: to.Ptr[int32](2),
		})
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/videoanalyzer/resource-manager/Microsoft.Media/preview/2021-11-01-preview/examples/pipeline-topology-get-by-name.json
func ExamplePipelineTopologiesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armvideoanalyzer.NewPipelineTopologiesClient("591e76c3-3e97-44db-879c-3e2b12961b62", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.Get(ctx,
		"testrg",
		"testaccount2",
		"pipelineTopology1",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/videoanalyzer/resource-manager/Microsoft.Media/preview/2021-11-01-preview/examples/pipeline-topology-create.json
func ExamplePipelineTopologiesClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armvideoanalyzer.NewPipelineTopologiesClient("591e76c3-3e97-44db-879c-3e2b12961b62", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.CreateOrUpdate(ctx,
		"testrg",
		"testaccount2",
		"pipelineTopology1",
		armvideoanalyzer.PipelineTopology{
			Kind: to.Ptr(armvideoanalyzer.KindLive),
			Properties: &armvideoanalyzer.PipelineTopologyProperties{
				Description: to.Ptr("Pipeline Topology 1 Description"),
				Parameters: []*armvideoanalyzer.ParameterDeclaration{
					{
						Name:        to.Ptr("rtspUrlParameter"),
						Type:        to.Ptr(armvideoanalyzer.ParameterTypeString),
						Description: to.Ptr("rtsp source url parameter"),
						Default:     to.Ptr("rtsp://microsoft.com/video.mp4"),
					},
					{
						Name:        to.Ptr("rtspPasswordParameter"),
						Type:        to.Ptr(armvideoanalyzer.ParameterTypeSecretString),
						Description: to.Ptr("rtsp source password parameter"),
						Default:     to.Ptr("password"),
					}},
				Sinks: []armvideoanalyzer.SinkNodeBaseClassification{
					&armvideoanalyzer.VideoSink{
						Name: to.Ptr("videoSink"),
						Type: to.Ptr("#Microsoft.VideoAnalyzer.VideoSink"),
						Inputs: []*armvideoanalyzer.NodeInput{
							{
								NodeName: to.Ptr("rtspSource"),
							}},
						VideoCreationProperties: &armvideoanalyzer.VideoCreationProperties{
							Description:   to.Ptr("Parking lot south entrance"),
							SegmentLength: to.Ptr("PT30S"),
							Title:         to.Ptr("Parking Lot (Camera 1)"),
						},
						VideoName: to.Ptr("camera001"),
						VideoPublishingOptions: &armvideoanalyzer.VideoPublishingOptions{
							DisableArchive:        to.Ptr("false"),
							DisableRtspPublishing: to.Ptr("true"),
						},
					}},
				Sources: []armvideoanalyzer.SourceNodeBaseClassification{
					&armvideoanalyzer.RtspSource{
						Name: to.Ptr("rtspSource"),
						Type: to.Ptr("#Microsoft.VideoAnalyzer.RtspSource"),
						Endpoint: &armvideoanalyzer.UnsecuredEndpoint{
							Type: to.Ptr("#Microsoft.VideoAnalyzer.UnsecuredEndpoint"),
							Credentials: &armvideoanalyzer.UsernamePasswordCredentials{
								Type:     to.Ptr("#Microsoft.VideoAnalyzer.UsernamePasswordCredentials"),
								Password: to.Ptr("${rtspPasswordParameter}"),
								Username: to.Ptr("username"),
							},
							URL: to.Ptr("${rtspUrlParameter}"),
						},
						Transport: to.Ptr(armvideoanalyzer.RtspTransportHTTP),
					}},
			},
			SKU: &armvideoanalyzer.SKU{
				Name: to.Ptr(armvideoanalyzer.SKUNameLiveS1),
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/videoanalyzer/resource-manager/Microsoft.Media/preview/2021-11-01-preview/examples/pipeline-topology-delete.json
func ExamplePipelineTopologiesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armvideoanalyzer.NewPipelineTopologiesClient("591e76c3-3e97-44db-879c-3e2b12961b62", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = client.Delete(ctx,
		"testrg",
		"testaccount2",
		"pipelineTopology1",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/videoanalyzer/resource-manager/Microsoft.Media/preview/2021-11-01-preview/examples/pipeline-topology-patch.json
func ExamplePipelineTopologiesClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armvideoanalyzer.NewPipelineTopologiesClient("591e76c3-3e97-44db-879c-3e2b12961b62", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.Update(ctx,
		"testrg",
		"testaccount2",
		"pipelineTopology1",
		armvideoanalyzer.PipelineTopologyUpdate{
			Properties: &armvideoanalyzer.PipelineTopologyPropertiesUpdate{
				Description: to.Ptr("Pipeline Topology 1 Description"),
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}
