//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armapimanagement

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type APIContractProperties.
func (a APIContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "apiRevision", a.APIRevision)
	populate(objectMap, "apiRevisionDescription", a.APIRevisionDescription)
	populate(objectMap, "type", a.APIType)
	populate(objectMap, "apiVersion", a.APIVersion)
	populate(objectMap, "apiVersionDescription", a.APIVersionDescription)
	populate(objectMap, "apiVersionSet", a.APIVersionSet)
	populate(objectMap, "apiVersionSetId", a.APIVersionSetID)
	populate(objectMap, "authenticationSettings", a.AuthenticationSettings)
	populate(objectMap, "contact", a.Contact)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "isCurrent", a.IsCurrent)
	populate(objectMap, "isOnline", a.IsOnline)
	populate(objectMap, "license", a.License)
	populate(objectMap, "path", a.Path)
	populate(objectMap, "protocols", a.Protocols)
	populate(objectMap, "serviceUrl", a.ServiceURL)
	populate(objectMap, "sourceApiId", a.SourceAPIID)
	populate(objectMap, "subscriptionKeyParameterNames", a.SubscriptionKeyParameterNames)
	populate(objectMap, "subscriptionRequired", a.SubscriptionRequired)
	populate(objectMap, "termsOfServiceUrl", a.TermsOfServiceURL)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type APIContractUpdateProperties.
func (a APIContractUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "apiRevision", a.APIRevision)
	populate(objectMap, "apiRevisionDescription", a.APIRevisionDescription)
	populate(objectMap, "type", a.APIType)
	populate(objectMap, "apiVersion", a.APIVersion)
	populate(objectMap, "apiVersionDescription", a.APIVersionDescription)
	populate(objectMap, "apiVersionSetId", a.APIVersionSetID)
	populate(objectMap, "authenticationSettings", a.AuthenticationSettings)
	populate(objectMap, "contact", a.Contact)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "isCurrent", a.IsCurrent)
	populate(objectMap, "isOnline", a.IsOnline)
	populate(objectMap, "license", a.License)
	populate(objectMap, "path", a.Path)
	populate(objectMap, "protocols", a.Protocols)
	populate(objectMap, "serviceUrl", a.ServiceURL)
	populate(objectMap, "subscriptionKeyParameterNames", a.SubscriptionKeyParameterNames)
	populate(objectMap, "subscriptionRequired", a.SubscriptionRequired)
	populate(objectMap, "termsOfServiceUrl", a.TermsOfServiceURL)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type APICreateOrUpdateProperties.
func (a APICreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "apiRevision", a.APIRevision)
	populate(objectMap, "apiRevisionDescription", a.APIRevisionDescription)
	populate(objectMap, "type", a.APIType)
	populate(objectMap, "apiVersion", a.APIVersion)
	populate(objectMap, "apiVersionDescription", a.APIVersionDescription)
	populate(objectMap, "apiVersionSet", a.APIVersionSet)
	populate(objectMap, "apiVersionSetId", a.APIVersionSetID)
	populate(objectMap, "authenticationSettings", a.AuthenticationSettings)
	populate(objectMap, "contact", a.Contact)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "format", a.Format)
	populate(objectMap, "isCurrent", a.IsCurrent)
	populate(objectMap, "isOnline", a.IsOnline)
	populate(objectMap, "license", a.License)
	populate(objectMap, "path", a.Path)
	populate(objectMap, "protocols", a.Protocols)
	populate(objectMap, "serviceUrl", a.ServiceURL)
	populate(objectMap, "apiType", a.SoapAPIType)
	populate(objectMap, "sourceApiId", a.SourceAPIID)
	populate(objectMap, "subscriptionKeyParameterNames", a.SubscriptionKeyParameterNames)
	populate(objectMap, "subscriptionRequired", a.SubscriptionRequired)
	populate(objectMap, "termsOfServiceUrl", a.TermsOfServiceURL)
	populate(objectMap, "value", a.Value)
	populate(objectMap, "wsdlSelector", a.WsdlSelector)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type APIReleaseContract.
func (a APIReleaseContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type APIReleaseContractProperties.
func (a APIReleaseContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "apiId", a.APIID)
	populateTimeRFC3339(objectMap, "createdDateTime", a.CreatedDateTime)
	populate(objectMap, "notes", a.Notes)
	populateTimeRFC3339(objectMap, "updatedDateTime", a.UpdatedDateTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIReleaseContractProperties.
func (a *APIReleaseContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiId":
			err = unpopulate(val, "APIID", &a.APIID)
			delete(rawMsg, key)
		case "createdDateTime":
			err = unpopulateTimeRFC3339(val, "CreatedDateTime", &a.CreatedDateTime)
			delete(rawMsg, key)
		case "notes":
			err = unpopulate(val, "Notes", &a.Notes)
			delete(rawMsg, key)
		case "updatedDateTime":
			err = unpopulateTimeRFC3339(val, "UpdatedDateTime", &a.UpdatedDateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIRevisionContract.
func (a *APIRevisionContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiId":
			err = unpopulate(val, "APIID", &a.APIID)
			delete(rawMsg, key)
		case "apiRevision":
			err = unpopulate(val, "APIRevision", &a.APIRevision)
			delete(rawMsg, key)
		case "createdDateTime":
			err = unpopulateTimeRFC3339(val, "CreatedDateTime", &a.CreatedDateTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "isCurrent":
			err = unpopulate(val, "IsCurrent", &a.IsCurrent)
			delete(rawMsg, key)
		case "isOnline":
			err = unpopulate(val, "IsOnline", &a.IsOnline)
			delete(rawMsg, key)
		case "privateUrl":
			err = unpopulate(val, "PrivateURL", &a.PrivateURL)
			delete(rawMsg, key)
		case "updatedDateTime":
			err = unpopulateTimeRFC3339(val, "UpdatedDateTime", &a.UpdatedDateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APITagResourceContractProperties.
func (a APITagResourceContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "apiRevision", a.APIRevision)
	populate(objectMap, "apiRevisionDescription", a.APIRevisionDescription)
	populate(objectMap, "type", a.APIType)
	populate(objectMap, "apiVersion", a.APIVersion)
	populate(objectMap, "apiVersionDescription", a.APIVersionDescription)
	populate(objectMap, "apiVersionSetId", a.APIVersionSetID)
	populate(objectMap, "authenticationSettings", a.AuthenticationSettings)
	populate(objectMap, "contact", a.Contact)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "isCurrent", a.IsCurrent)
	populate(objectMap, "isOnline", a.IsOnline)
	populate(objectMap, "license", a.License)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "path", a.Path)
	populate(objectMap, "protocols", a.Protocols)
	populate(objectMap, "serviceUrl", a.ServiceURL)
	populate(objectMap, "subscriptionKeyParameterNames", a.SubscriptionKeyParameterNames)
	populate(objectMap, "subscriptionRequired", a.SubscriptionRequired)
	populate(objectMap, "termsOfServiceUrl", a.TermsOfServiceURL)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type APIUpdateContract.
func (a APIUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type APIVersionSetUpdateParameters.
func (a APIVersionSetUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AccessInformationUpdateParameters.
func (a AccessInformationUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AdditionalLocation.
func (a AdditionalLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "disableGateway", a.DisableGateway)
	populate(objectMap, "gatewayRegionalUrl", a.GatewayRegionalURL)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "platformVersion", a.PlatformVersion)
	populate(objectMap, "privateIPAddresses", a.PrivateIPAddresses)
	populate(objectMap, "publicIpAddressId", a.PublicIPAddressID)
	populate(objectMap, "publicIPAddresses", a.PublicIPAddresses)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "virtualNetworkConfiguration", a.VirtualNetworkConfiguration)
	populate(objectMap, "zones", a.Zones)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApimResource.
func (a ApimResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationServerContractBaseProperties.
func (a AuthorizationServerContractBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authorizationMethods", a.AuthorizationMethods)
	populate(objectMap, "bearerTokenSendingMethods", a.BearerTokenSendingMethods)
	populate(objectMap, "clientAuthenticationMethod", a.ClientAuthenticationMethod)
	populate(objectMap, "defaultScope", a.DefaultScope)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "resourceOwnerPassword", a.ResourceOwnerPassword)
	populate(objectMap, "resourceOwnerUsername", a.ResourceOwnerUsername)
	populate(objectMap, "supportState", a.SupportState)
	populate(objectMap, "tokenBodyParameters", a.TokenBodyParameters)
	populate(objectMap, "tokenEndpoint", a.TokenEndpoint)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationServerContractProperties.
func (a AuthorizationServerContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authorizationEndpoint", a.AuthorizationEndpoint)
	populate(objectMap, "authorizationMethods", a.AuthorizationMethods)
	populate(objectMap, "bearerTokenSendingMethods", a.BearerTokenSendingMethods)
	populate(objectMap, "clientAuthenticationMethod", a.ClientAuthenticationMethod)
	populate(objectMap, "clientId", a.ClientID)
	populate(objectMap, "clientRegistrationEndpoint", a.ClientRegistrationEndpoint)
	populate(objectMap, "clientSecret", a.ClientSecret)
	populate(objectMap, "defaultScope", a.DefaultScope)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "grantTypes", a.GrantTypes)
	populate(objectMap, "resourceOwnerPassword", a.ResourceOwnerPassword)
	populate(objectMap, "resourceOwnerUsername", a.ResourceOwnerUsername)
	populate(objectMap, "supportState", a.SupportState)
	populate(objectMap, "tokenBodyParameters", a.TokenBodyParameters)
	populate(objectMap, "tokenEndpoint", a.TokenEndpoint)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationServerUpdateContract.
func (a AuthorizationServerUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationServerUpdateContractProperties.
func (a AuthorizationServerUpdateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authorizationEndpoint", a.AuthorizationEndpoint)
	populate(objectMap, "authorizationMethods", a.AuthorizationMethods)
	populate(objectMap, "bearerTokenSendingMethods", a.BearerTokenSendingMethods)
	populate(objectMap, "clientAuthenticationMethod", a.ClientAuthenticationMethod)
	populate(objectMap, "clientId", a.ClientID)
	populate(objectMap, "clientRegistrationEndpoint", a.ClientRegistrationEndpoint)
	populate(objectMap, "clientSecret", a.ClientSecret)
	populate(objectMap, "defaultScope", a.DefaultScope)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "grantTypes", a.GrantTypes)
	populate(objectMap, "resourceOwnerPassword", a.ResourceOwnerPassword)
	populate(objectMap, "resourceOwnerUsername", a.ResourceOwnerUsername)
	populate(objectMap, "supportState", a.SupportState)
	populate(objectMap, "tokenBodyParameters", a.TokenBodyParameters)
	populate(objectMap, "tokenEndpoint", a.TokenEndpoint)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BackendCredentialsContract.
func (b BackendCredentialsContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authorization", b.Authorization)
	populate(objectMap, "certificate", b.Certificate)
	populate(objectMap, "certificateIds", b.CertificateIDs)
	populate(objectMap, "header", b.Header)
	populate(objectMap, "query", b.Query)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BackendServiceFabricClusterProperties.
func (b BackendServiceFabricClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientCertificateId", b.ClientCertificateID)
	populate(objectMap, "clientCertificatethumbprint", b.ClientCertificatethumbprint)
	populate(objectMap, "managementEndpoints", b.ManagementEndpoints)
	populate(objectMap, "maxPartitionResolutionRetries", b.MaxPartitionResolutionRetries)
	populate(objectMap, "serverCertificateThumbprints", b.ServerCertificateThumbprints)
	populate(objectMap, "serverX509Names", b.ServerX509Names)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BackendUpdateParameters.
func (b BackendUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", b.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CacheUpdateParameters.
func (c CacheUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CertificateContractProperties.
func (c CertificateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "expirationDate", c.ExpirationDate)
	populate(objectMap, "keyVault", c.KeyVault)
	populate(objectMap, "subject", c.Subject)
	populate(objectMap, "thumbprint", c.Thumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateContractProperties.
func (c *CertificateContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationDate":
			err = unpopulateTimeRFC3339(val, "ExpirationDate", &c.ExpirationDate)
			delete(rawMsg, key)
		case "keyVault":
			err = unpopulate(val, "KeyVault", &c.KeyVault)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &c.Subject)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &c.Thumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateInformation.
func (c CertificateInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "expiry", c.Expiry)
	populate(objectMap, "subject", c.Subject)
	populate(objectMap, "thumbprint", c.Thumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateInformation.
func (c *CertificateInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiry":
			err = unpopulateTimeRFC3339(val, "Expiry", &c.Expiry)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &c.Subject)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &c.Thumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration.
func (c ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "headers", c.Headers)
	populate(objectMap, "method", c.Method)
	populate(objectMap, "validStatusCodes", c.ValidStatusCodes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityStatusContract.
func (c *ConnectivityStatusContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "isOptional":
			err = unpopulate(val, "IsOptional", &c.IsOptional)
			delete(rawMsg, key)
		case "lastStatusChange":
			err = unpopulateTimeRFC3339(val, "LastStatusChange", &c.LastStatusChange)
			delete(rawMsg, key)
		case "lastUpdated":
			err = unpopulateTimeRFC3339(val, "LastUpdated", &c.LastUpdated)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &c.ResourceType)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentItemContract.
func (c ContentItemContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DataMasking.
func (d DataMasking) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "headers", d.Headers)
	populate(objectMap, "queryParams", d.QueryParams)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DeletedServiceContractProperties.
func (d DeletedServiceContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "deletionDate", d.DeletionDate)
	populateTimeRFC3339(objectMap, "scheduledPurgeDate", d.ScheduledPurgeDate)
	populate(objectMap, "serviceId", d.ServiceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedServiceContractProperties.
func (d *DeletedServiceContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deletionDate":
			err = unpopulateTimeRFC3339(val, "DeletionDate", &d.DeletionDate)
			delete(rawMsg, key)
		case "scheduledPurgeDate":
			err = unpopulateTimeRFC3339(val, "ScheduledPurgeDate", &d.ScheduledPurgeDate)
			delete(rawMsg, key)
		case "serviceId":
			err = unpopulate(val, "ServiceID", &d.ServiceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticContract.
func (d DiagnosticContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type EmailTemplateContractProperties.
func (e EmailTemplateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "body", e.Body)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "isDefault", e.IsDefault)
	populate(objectMap, "parameters", e.Parameters)
	populate(objectMap, "subject", e.Subject)
	populate(objectMap, "title", e.Title)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type EmailTemplateUpdateParameterProperties.
func (e EmailTemplateUpdateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "body", e.Body)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "parameters", e.Parameters)
	populate(objectMap, "subject", e.Subject)
	populate(objectMap, "title", e.Title)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type EmailTemplateUpdateParameters.
func (e EmailTemplateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", e.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponseBody.
func (e ErrorResponseBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GatewayContract.
func (g GatewayContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GatewayTokenRequestContract.
func (g GatewayTokenRequestContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "expiry", g.Expiry)
	populate(objectMap, "keyType", g.KeyType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayTokenRequestContract.
func (g *GatewayTokenRequestContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiry":
			err = unpopulateTimeRFC3339(val, "Expiry", &g.Expiry)
			delete(rawMsg, key)
		case "keyType":
			err = unpopulate(val, "KeyType", &g.KeyType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupUpdateParameters.
func (g GroupUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", g.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type HTTPMessageDiagnostic.
func (h HTTPMessageDiagnostic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "body", h.Body)
	populate(objectMap, "dataMasking", h.DataMasking)
	populate(objectMap, "headers", h.Headers)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviderBaseParameters.
func (i IdentityProviderBaseParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedTenants", i.AllowedTenants)
	populate(objectMap, "authority", i.Authority)
	populate(objectMap, "passwordResetPolicyName", i.PasswordResetPolicyName)
	populate(objectMap, "profileEditingPolicyName", i.ProfileEditingPolicyName)
	populate(objectMap, "signinPolicyName", i.SigninPolicyName)
	populate(objectMap, "signinTenant", i.SigninTenant)
	populate(objectMap, "signupPolicyName", i.SignupPolicyName)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviderContractProperties.
func (i IdentityProviderContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedTenants", i.AllowedTenants)
	populate(objectMap, "authority", i.Authority)
	populate(objectMap, "clientId", i.ClientID)
	populate(objectMap, "clientSecret", i.ClientSecret)
	populate(objectMap, "passwordResetPolicyName", i.PasswordResetPolicyName)
	populate(objectMap, "profileEditingPolicyName", i.ProfileEditingPolicyName)
	populate(objectMap, "signinPolicyName", i.SigninPolicyName)
	populate(objectMap, "signinTenant", i.SigninTenant)
	populate(objectMap, "signupPolicyName", i.SignupPolicyName)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviderCreateContractProperties.
func (i IdentityProviderCreateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedTenants", i.AllowedTenants)
	populate(objectMap, "authority", i.Authority)
	populate(objectMap, "clientId", i.ClientID)
	populate(objectMap, "clientSecret", i.ClientSecret)
	populate(objectMap, "passwordResetPolicyName", i.PasswordResetPolicyName)
	populate(objectMap, "profileEditingPolicyName", i.ProfileEditingPolicyName)
	populate(objectMap, "signinPolicyName", i.SigninPolicyName)
	populate(objectMap, "signinTenant", i.SigninTenant)
	populate(objectMap, "signupPolicyName", i.SignupPolicyName)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviderUpdateParameters.
func (i IdentityProviderUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", i.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviderUpdateProperties.
func (i IdentityProviderUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedTenants", i.AllowedTenants)
	populate(objectMap, "authority", i.Authority)
	populate(objectMap, "clientId", i.ClientID)
	populate(objectMap, "clientSecret", i.ClientSecret)
	populate(objectMap, "passwordResetPolicyName", i.PasswordResetPolicyName)
	populate(objectMap, "profileEditingPolicyName", i.ProfileEditingPolicyName)
	populate(objectMap, "signinPolicyName", i.SigninPolicyName)
	populate(objectMap, "signinTenant", i.SigninTenant)
	populate(objectMap, "signupPolicyName", i.SignupPolicyName)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IssueCommentContractProperties.
func (i IssueCommentContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdDate", i.CreatedDate)
	populate(objectMap, "text", i.Text)
	populate(objectMap, "userId", i.UserID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssueCommentContractProperties.
func (i *IssueCommentContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &i.CreatedDate)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &i.Text)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &i.UserID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssueContractBaseProperties.
func (i IssueContractBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "apiId", i.APIID)
	populateTimeRFC3339(objectMap, "createdDate", i.CreatedDate)
	populate(objectMap, "state", i.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssueContractBaseProperties.
func (i *IssueContractBaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiId":
			err = unpopulate(val, "APIID", &i.APIID)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &i.CreatedDate)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssueContractProperties.
func (i IssueContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "apiId", i.APIID)
	populateTimeRFC3339(objectMap, "createdDate", i.CreatedDate)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "state", i.State)
	populate(objectMap, "title", i.Title)
	populate(objectMap, "userId", i.UserID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssueContractProperties.
func (i *IssueContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiId":
			err = unpopulate(val, "APIID", &i.APIID)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &i.CreatedDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &i.Title)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &i.UserID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssueUpdateContract.
func (i IssueUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", i.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IssueUpdateContractProperties.
func (i IssueUpdateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "apiId", i.APIID)
	populateTimeRFC3339(objectMap, "createdDate", i.CreatedDate)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "state", i.State)
	populate(objectMap, "title", i.Title)
	populate(objectMap, "userId", i.UserID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssueUpdateContractProperties.
func (i *IssueUpdateContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiId":
			err = unpopulate(val, "APIID", &i.APIID)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &i.CreatedDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &i.Title)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &i.UserID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultLastAccessStatusContractProperties.
func (k KeyVaultLastAccessStatusContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", k.Code)
	populate(objectMap, "message", k.Message)
	populateTimeRFC3339(objectMap, "timeStampUtc", k.TimeStampUTC)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultLastAccessStatusContractProperties.
func (k *KeyVaultLastAccessStatusContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &k.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &k.Message)
			delete(rawMsg, key)
		case "timeStampUtc":
			err = unpopulateTimeRFC3339(val, "TimeStampUTC", &k.TimeStampUTC)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoggerContractProperties.
func (l LoggerContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "credentials", l.Credentials)
	populate(objectMap, "description", l.Description)
	populate(objectMap, "isBuffered", l.IsBuffered)
	populate(objectMap, "loggerType", l.LoggerType)
	populate(objectMap, "resourceId", l.ResourceID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LoggerUpdateContract.
func (l LoggerUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", l.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LoggerUpdateParameters.
func (l LoggerUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "credentials", l.Credentials)
	populate(objectMap, "description", l.Description)
	populate(objectMap, "isBuffered", l.IsBuffered)
	populate(objectMap, "loggerType", l.LoggerType)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NamedValueContractProperties.
func (n NamedValueContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "displayName", n.DisplayName)
	populate(objectMap, "keyVault", n.KeyVault)
	populate(objectMap, "secret", n.Secret)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NamedValueCreateContractProperties.
func (n NamedValueCreateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "displayName", n.DisplayName)
	populate(objectMap, "keyVault", n.KeyVault)
	populate(objectMap, "secret", n.Secret)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NamedValueEntityBaseParameters.
func (n NamedValueEntityBaseParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "secret", n.Secret)
	populate(objectMap, "tags", n.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NamedValueUpdateParameterProperties.
func (n NamedValueUpdateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "displayName", n.DisplayName)
	populate(objectMap, "keyVault", n.KeyVault)
	populate(objectMap, "secret", n.Secret)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NamedValueUpdateParameters.
func (n NamedValueUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", n.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OpenIDAuthenticationSettingsContract.
func (o OpenIDAuthenticationSettingsContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bearerTokenSendingMethods", o.BearerTokenSendingMethods)
	populate(objectMap, "openidProviderId", o.OpenidProviderID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OpenidConnectProviderUpdateContract.
func (o OpenidConnectProviderUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OperationContractProperties.
func (o OperationContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", o.Description)
	populate(objectMap, "displayName", o.DisplayName)
	populate(objectMap, "method", o.Method)
	populate(objectMap, "policies", o.Policies)
	populate(objectMap, "request", o.Request)
	populate(objectMap, "responses", o.Responses)
	populate(objectMap, "templateParameters", o.TemplateParameters)
	populate(objectMap, "urlTemplate", o.URLTemplate)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OperationEntityBaseContract.
func (o OperationEntityBaseContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", o.Description)
	populate(objectMap, "policies", o.Policies)
	populate(objectMap, "request", o.Request)
	populate(objectMap, "responses", o.Responses)
	populate(objectMap, "templateParameters", o.TemplateParameters)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OperationResultContractProperties.
func (o OperationResultContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionLog", o.ActionLog)
	populate(objectMap, "error", o.Error)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "resultInfo", o.ResultInfo)
	populateTimeRFC3339(objectMap, "started", o.Started)
	populate(objectMap, "status", o.Status)
	populateTimeRFC3339(objectMap, "updated", o.Updated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResultContractProperties.
func (o *OperationResultContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionLog":
			err = unpopulate(val, "ActionLog", &o.ActionLog)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "resultInfo":
			err = unpopulate(val, "ResultInfo", &o.ResultInfo)
			delete(rawMsg, key)
		case "started":
			err = unpopulateTimeRFC3339(val, "Started", &o.Started)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		case "updated":
			err = unpopulateTimeRFC3339(val, "Updated", &o.Updated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationUpdateContract.
func (o OperationUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OperationUpdateContractProperties.
func (o OperationUpdateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", o.Description)
	populate(objectMap, "displayName", o.DisplayName)
	populate(objectMap, "method", o.Method)
	populate(objectMap, "policies", o.Policies)
	populate(objectMap, "request", o.Request)
	populate(objectMap, "responses", o.Responses)
	populate(objectMap, "templateParameters", o.TemplateParameters)
	populate(objectMap, "urlTemplate", o.URLTemplate)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ParameterContract.
func (p ParameterContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "defaultValue", p.DefaultValue)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "examples", p.Examples)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "required", p.Required)
	populate(objectMap, "schemaId", p.SchemaID)
	populate(objectMap, "type", p.Type)
	populate(objectMap, "typeName", p.TypeName)
	populate(objectMap, "values", p.Values)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PortalDelegationSettings.
func (p PortalDelegationSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PortalRevisionContract.
func (p PortalRevisionContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PortalRevisionContractProperties.
func (p PortalRevisionContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdDateTime", p.CreatedDateTime)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "isCurrent", p.IsCurrent)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "statusDetails", p.StatusDetails)
	populateTimeRFC3339(objectMap, "updatedDateTime", p.UpdatedDateTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalRevisionContractProperties.
func (p *PortalRevisionContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDateTime":
			err = unpopulateTimeRFC3339(val, "CreatedDateTime", &p.CreatedDateTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "isCurrent":
			err = unpopulate(val, "IsCurrent", &p.IsCurrent)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &p.StatusDetails)
			delete(rawMsg, key)
		case "updatedDateTime":
			err = unpopulateTimeRFC3339(val, "UpdatedDateTime", &p.UpdatedDateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalSigninSettings.
func (p PortalSigninSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PortalSignupSettings.
func (p PortalSignupSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionWrapperProperties.
func (p PrivateEndpointConnectionWrapperProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupIds", p.GroupIDs)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ProductUpdateParameters.
func (p ProductUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaCounterContract.
func (q *QuotaCounterContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "counterKey":
			err = unpopulate(val, "CounterKey", &q.CounterKey)
			delete(rawMsg, key)
		case "periodEndTime":
			err = unpopulateTimeRFC3339(val, "PeriodEndTime", &q.PeriodEndTime)
			delete(rawMsg, key)
		case "periodKey":
			err = unpopulate(val, "PeriodKey", &q.PeriodKey)
			delete(rawMsg, key)
		case "periodStartTime":
			err = unpopulateTimeRFC3339(val, "PeriodStartTime", &q.PeriodStartTime)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &q.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaCounterValueUpdateContract.
func (q QuotaCounterValueUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", q.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RecipientsContractProperties.
func (r RecipientsContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "emails", r.Emails)
	populate(objectMap, "users", r.Users)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReportRecordContract.
func (r *ReportRecordContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiId":
			err = unpopulate(val, "APIID", &r.APIID)
			delete(rawMsg, key)
		case "apiRegion":
			err = unpopulate(val, "APIRegion", &r.APIRegion)
			delete(rawMsg, key)
		case "apiTimeAvg":
			err = unpopulate(val, "APITimeAvg", &r.APITimeAvg)
			delete(rawMsg, key)
		case "apiTimeMax":
			err = unpopulate(val, "APITimeMax", &r.APITimeMax)
			delete(rawMsg, key)
		case "apiTimeMin":
			err = unpopulate(val, "APITimeMin", &r.APITimeMin)
			delete(rawMsg, key)
		case "bandwidth":
			err = unpopulate(val, "Bandwidth", &r.Bandwidth)
			delete(rawMsg, key)
		case "cacheHitCount":
			err = unpopulate(val, "CacheHitCount", &r.CacheHitCount)
			delete(rawMsg, key)
		case "cacheMissCount":
			err = unpopulate(val, "CacheMissCount", &r.CacheMissCount)
			delete(rawMsg, key)
		case "callCountBlocked":
			err = unpopulate(val, "CallCountBlocked", &r.CallCountBlocked)
			delete(rawMsg, key)
		case "callCountFailed":
			err = unpopulate(val, "CallCountFailed", &r.CallCountFailed)
			delete(rawMsg, key)
		case "callCountOther":
			err = unpopulate(val, "CallCountOther", &r.CallCountOther)
			delete(rawMsg, key)
		case "callCountSuccess":
			err = unpopulate(val, "CallCountSuccess", &r.CallCountSuccess)
			delete(rawMsg, key)
		case "callCountTotal":
			err = unpopulate(val, "CallCountTotal", &r.CallCountTotal)
			delete(rawMsg, key)
		case "country":
			err = unpopulate(val, "Country", &r.Country)
			delete(rawMsg, key)
		case "interval":
			err = unpopulate(val, "Interval", &r.Interval)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &r.OperationID)
			delete(rawMsg, key)
		case "productId":
			err = unpopulate(val, "ProductID", &r.ProductID)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &r.Region)
			delete(rawMsg, key)
		case "serviceTimeAvg":
			err = unpopulate(val, "ServiceTimeAvg", &r.ServiceTimeAvg)
			delete(rawMsg, key)
		case "serviceTimeMax":
			err = unpopulate(val, "ServiceTimeMax", &r.ServiceTimeMax)
			delete(rawMsg, key)
		case "serviceTimeMin":
			err = unpopulate(val, "ServiceTimeMin", &r.ServiceTimeMin)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateTimeRFC3339(val, "Timestamp", &r.Timestamp)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &r.UserID)
			delete(rawMsg, key)
		case "zip":
			err = unpopulate(val, "Zip", &r.Zip)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RepresentationContract.
func (r RepresentationContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentType", r.ContentType)
	populate(objectMap, "examples", r.Examples)
	populate(objectMap, "formParameters", r.FormParameters)
	populate(objectMap, "schemaId", r.SchemaID)
	populate(objectMap, "typeName", r.TypeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RequestContract.
func (r RequestContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", r.Description)
	populate(objectMap, "headers", r.Headers)
	populate(objectMap, "queryParameters", r.QueryParameters)
	populate(objectMap, "representations", r.Representations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestReportRecordContract.
func (r *RequestReportRecordContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiId":
			err = unpopulate(val, "APIID", &r.APIID)
			delete(rawMsg, key)
		case "apiRegion":
			err = unpopulate(val, "APIRegion", &r.APIRegion)
			delete(rawMsg, key)
		case "apiTime":
			err = unpopulate(val, "APITime", &r.APITime)
			delete(rawMsg, key)
		case "backendResponseCode":
			err = unpopulate(val, "BackendResponseCode", &r.BackendResponseCode)
			delete(rawMsg, key)
		case "cache":
			err = unpopulate(val, "Cache", &r.Cache)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &r.IPAddress)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &r.Method)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &r.OperationID)
			delete(rawMsg, key)
		case "productId":
			err = unpopulate(val, "ProductID", &r.ProductID)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &r.RequestID)
			delete(rawMsg, key)
		case "requestSize":
			err = unpopulate(val, "RequestSize", &r.RequestSize)
			delete(rawMsg, key)
		case "responseCode":
			err = unpopulate(val, "ResponseCode", &r.ResponseCode)
			delete(rawMsg, key)
		case "responseSize":
			err = unpopulate(val, "ResponseSize", &r.ResponseSize)
			delete(rawMsg, key)
		case "serviceTime":
			err = unpopulate(val, "ServiceTime", &r.ServiceTime)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateTimeRFC3339(val, "Timestamp", &r.Timestamp)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &r.URL)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &r.UserID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResponseContract.
func (r ResponseContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", r.Description)
	populate(objectMap, "headers", r.Headers)
	populate(objectMap, "representations", r.Representations)
	populate(objectMap, "statusCode", r.StatusCode)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBaseProperties.
func (s ServiceBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "apiVersionConstraint", s.APIVersionConstraint)
	populate(objectMap, "additionalLocations", s.AdditionalLocations)
	populate(objectMap, "certificates", s.Certificates)
	populateTimeRFC3339(objectMap, "createdAtUtc", s.CreatedAtUTC)
	populate(objectMap, "customProperties", s.CustomProperties)
	populate(objectMap, "developerPortalUrl", s.DeveloperPortalURL)
	populate(objectMap, "disableGateway", s.DisableGateway)
	populate(objectMap, "enableClientCertificate", s.EnableClientCertificate)
	populate(objectMap, "gatewayRegionalUrl", s.GatewayRegionalURL)
	populate(objectMap, "gatewayUrl", s.GatewayURL)
	populate(objectMap, "hostnameConfigurations", s.HostnameConfigurations)
	populate(objectMap, "managementApiUrl", s.ManagementAPIURL)
	populate(objectMap, "notificationSenderEmail", s.NotificationSenderEmail)
	populate(objectMap, "platformVersion", s.PlatformVersion)
	populate(objectMap, "portalUrl", s.PortalURL)
	populate(objectMap, "privateEndpointConnections", s.PrivateEndpointConnections)
	populate(objectMap, "privateIPAddresses", s.PrivateIPAddresses)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "publicIpAddressId", s.PublicIPAddressID)
	populate(objectMap, "publicIPAddresses", s.PublicIPAddresses)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "restore", s.Restore)
	populate(objectMap, "scmUrl", s.ScmURL)
	populate(objectMap, "targetProvisioningState", s.TargetProvisioningState)
	populate(objectMap, "virtualNetworkConfiguration", s.VirtualNetworkConfiguration)
	populate(objectMap, "virtualNetworkType", s.VirtualNetworkType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBaseProperties.
func (s *ServiceBaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersionConstraint":
			err = unpopulate(val, "APIVersionConstraint", &s.APIVersionConstraint)
			delete(rawMsg, key)
		case "additionalLocations":
			err = unpopulate(val, "AdditionalLocations", &s.AdditionalLocations)
			delete(rawMsg, key)
		case "certificates":
			err = unpopulate(val, "Certificates", &s.Certificates)
			delete(rawMsg, key)
		case "createdAtUtc":
			err = unpopulateTimeRFC3339(val, "CreatedAtUTC", &s.CreatedAtUTC)
			delete(rawMsg, key)
		case "customProperties":
			err = unpopulate(val, "CustomProperties", &s.CustomProperties)
			delete(rawMsg, key)
		case "developerPortalUrl":
			err = unpopulate(val, "DeveloperPortalURL", &s.DeveloperPortalURL)
			delete(rawMsg, key)
		case "disableGateway":
			err = unpopulate(val, "DisableGateway", &s.DisableGateway)
			delete(rawMsg, key)
		case "enableClientCertificate":
			err = unpopulate(val, "EnableClientCertificate", &s.EnableClientCertificate)
			delete(rawMsg, key)
		case "gatewayRegionalUrl":
			err = unpopulate(val, "GatewayRegionalURL", &s.GatewayRegionalURL)
			delete(rawMsg, key)
		case "gatewayUrl":
			err = unpopulate(val, "GatewayURL", &s.GatewayURL)
			delete(rawMsg, key)
		case "hostnameConfigurations":
			err = unpopulate(val, "HostnameConfigurations", &s.HostnameConfigurations)
			delete(rawMsg, key)
		case "managementApiUrl":
			err = unpopulate(val, "ManagementAPIURL", &s.ManagementAPIURL)
			delete(rawMsg, key)
		case "notificationSenderEmail":
			err = unpopulate(val, "NotificationSenderEmail", &s.NotificationSenderEmail)
			delete(rawMsg, key)
		case "platformVersion":
			err = unpopulate(val, "PlatformVersion", &s.PlatformVersion)
			delete(rawMsg, key)
		case "portalUrl":
			err = unpopulate(val, "PortalURL", &s.PortalURL)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &s.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "privateIPAddresses":
			err = unpopulate(val, "PrivateIPAddresses", &s.PrivateIPAddresses)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "publicIpAddressId":
			err = unpopulate(val, "PublicIPAddressID", &s.PublicIPAddressID)
			delete(rawMsg, key)
		case "publicIPAddresses":
			err = unpopulate(val, "PublicIPAddresses", &s.PublicIPAddresses)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "restore":
			err = unpopulate(val, "Restore", &s.Restore)
			delete(rawMsg, key)
		case "scmUrl":
			err = unpopulate(val, "ScmURL", &s.ScmURL)
			delete(rawMsg, key)
		case "targetProvisioningState":
			err = unpopulate(val, "TargetProvisioningState", &s.TargetProvisioningState)
			delete(rawMsg, key)
		case "virtualNetworkConfiguration":
			err = unpopulate(val, "VirtualNetworkConfiguration", &s.VirtualNetworkConfiguration)
			delete(rawMsg, key)
		case "virtualNetworkType":
			err = unpopulate(val, "VirtualNetworkType", &s.VirtualNetworkType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceIdentity.
func (s ServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", s.PrincipalID)
	populate(objectMap, "tenantId", s.TenantID)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "userAssignedIdentities", s.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceProperties.
func (s ServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "apiVersionConstraint", s.APIVersionConstraint)
	populate(objectMap, "additionalLocations", s.AdditionalLocations)
	populate(objectMap, "certificates", s.Certificates)
	populateTimeRFC3339(objectMap, "createdAtUtc", s.CreatedAtUTC)
	populate(objectMap, "customProperties", s.CustomProperties)
	populate(objectMap, "developerPortalUrl", s.DeveloperPortalURL)
	populate(objectMap, "disableGateway", s.DisableGateway)
	populate(objectMap, "enableClientCertificate", s.EnableClientCertificate)
	populate(objectMap, "gatewayRegionalUrl", s.GatewayRegionalURL)
	populate(objectMap, "gatewayUrl", s.GatewayURL)
	populate(objectMap, "hostnameConfigurations", s.HostnameConfigurations)
	populate(objectMap, "managementApiUrl", s.ManagementAPIURL)
	populate(objectMap, "notificationSenderEmail", s.NotificationSenderEmail)
	populate(objectMap, "platformVersion", s.PlatformVersion)
	populate(objectMap, "portalUrl", s.PortalURL)
	populate(objectMap, "privateEndpointConnections", s.PrivateEndpointConnections)
	populate(objectMap, "privateIPAddresses", s.PrivateIPAddresses)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "publicIpAddressId", s.PublicIPAddressID)
	populate(objectMap, "publicIPAddresses", s.PublicIPAddresses)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "publisherEmail", s.PublisherEmail)
	populate(objectMap, "publisherName", s.PublisherName)
	populate(objectMap, "restore", s.Restore)
	populate(objectMap, "scmUrl", s.ScmURL)
	populate(objectMap, "targetProvisioningState", s.TargetProvisioningState)
	populate(objectMap, "virtualNetworkConfiguration", s.VirtualNetworkConfiguration)
	populate(objectMap, "virtualNetworkType", s.VirtualNetworkType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceProperties.
func (s *ServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersionConstraint":
			err = unpopulate(val, "APIVersionConstraint", &s.APIVersionConstraint)
			delete(rawMsg, key)
		case "additionalLocations":
			err = unpopulate(val, "AdditionalLocations", &s.AdditionalLocations)
			delete(rawMsg, key)
		case "certificates":
			err = unpopulate(val, "Certificates", &s.Certificates)
			delete(rawMsg, key)
		case "createdAtUtc":
			err = unpopulateTimeRFC3339(val, "CreatedAtUTC", &s.CreatedAtUTC)
			delete(rawMsg, key)
		case "customProperties":
			err = unpopulate(val, "CustomProperties", &s.CustomProperties)
			delete(rawMsg, key)
		case "developerPortalUrl":
			err = unpopulate(val, "DeveloperPortalURL", &s.DeveloperPortalURL)
			delete(rawMsg, key)
		case "disableGateway":
			err = unpopulate(val, "DisableGateway", &s.DisableGateway)
			delete(rawMsg, key)
		case "enableClientCertificate":
			err = unpopulate(val, "EnableClientCertificate", &s.EnableClientCertificate)
			delete(rawMsg, key)
		case "gatewayRegionalUrl":
			err = unpopulate(val, "GatewayRegionalURL", &s.GatewayRegionalURL)
			delete(rawMsg, key)
		case "gatewayUrl":
			err = unpopulate(val, "GatewayURL", &s.GatewayURL)
			delete(rawMsg, key)
		case "hostnameConfigurations":
			err = unpopulate(val, "HostnameConfigurations", &s.HostnameConfigurations)
			delete(rawMsg, key)
		case "managementApiUrl":
			err = unpopulate(val, "ManagementAPIURL", &s.ManagementAPIURL)
			delete(rawMsg, key)
		case "notificationSenderEmail":
			err = unpopulate(val, "NotificationSenderEmail", &s.NotificationSenderEmail)
			delete(rawMsg, key)
		case "platformVersion":
			err = unpopulate(val, "PlatformVersion", &s.PlatformVersion)
			delete(rawMsg, key)
		case "portalUrl":
			err = unpopulate(val, "PortalURL", &s.PortalURL)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &s.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "privateIPAddresses":
			err = unpopulate(val, "PrivateIPAddresses", &s.PrivateIPAddresses)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "publicIpAddressId":
			err = unpopulate(val, "PublicIPAddressID", &s.PublicIPAddressID)
			delete(rawMsg, key)
		case "publicIPAddresses":
			err = unpopulate(val, "PublicIPAddresses", &s.PublicIPAddresses)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "publisherEmail":
			err = unpopulate(val, "PublisherEmail", &s.PublisherEmail)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &s.PublisherName)
			delete(rawMsg, key)
		case "restore":
			err = unpopulate(val, "Restore", &s.Restore)
			delete(rawMsg, key)
		case "scmUrl":
			err = unpopulate(val, "ScmURL", &s.ScmURL)
			delete(rawMsg, key)
		case "targetProvisioningState":
			err = unpopulate(val, "TargetProvisioningState", &s.TargetProvisioningState)
			delete(rawMsg, key)
		case "virtualNetworkConfiguration":
			err = unpopulate(val, "VirtualNetworkConfiguration", &s.VirtualNetworkConfiguration)
			delete(rawMsg, key)
		case "virtualNetworkType":
			err = unpopulate(val, "VirtualNetworkType", &s.VirtualNetworkType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResource.
func (s ServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "zones", s.Zones)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceUpdateParameters.
func (s ServiceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "zones", s.Zones)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceUpdateProperties.
func (s ServiceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "apiVersionConstraint", s.APIVersionConstraint)
	populate(objectMap, "additionalLocations", s.AdditionalLocations)
	populate(objectMap, "certificates", s.Certificates)
	populateTimeRFC3339(objectMap, "createdAtUtc", s.CreatedAtUTC)
	populate(objectMap, "customProperties", s.CustomProperties)
	populate(objectMap, "developerPortalUrl", s.DeveloperPortalURL)
	populate(objectMap, "disableGateway", s.DisableGateway)
	populate(objectMap, "enableClientCertificate", s.EnableClientCertificate)
	populate(objectMap, "gatewayRegionalUrl", s.GatewayRegionalURL)
	populate(objectMap, "gatewayUrl", s.GatewayURL)
	populate(objectMap, "hostnameConfigurations", s.HostnameConfigurations)
	populate(objectMap, "managementApiUrl", s.ManagementAPIURL)
	populate(objectMap, "notificationSenderEmail", s.NotificationSenderEmail)
	populate(objectMap, "platformVersion", s.PlatformVersion)
	populate(objectMap, "portalUrl", s.PortalURL)
	populate(objectMap, "privateEndpointConnections", s.PrivateEndpointConnections)
	populate(objectMap, "privateIPAddresses", s.PrivateIPAddresses)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "publicIpAddressId", s.PublicIPAddressID)
	populate(objectMap, "publicIPAddresses", s.PublicIPAddresses)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "publisherEmail", s.PublisherEmail)
	populate(objectMap, "publisherName", s.PublisherName)
	populate(objectMap, "restore", s.Restore)
	populate(objectMap, "scmUrl", s.ScmURL)
	populate(objectMap, "targetProvisioningState", s.TargetProvisioningState)
	populate(objectMap, "virtualNetworkConfiguration", s.VirtualNetworkConfiguration)
	populate(objectMap, "virtualNetworkType", s.VirtualNetworkType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceUpdateProperties.
func (s *ServiceUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersionConstraint":
			err = unpopulate(val, "APIVersionConstraint", &s.APIVersionConstraint)
			delete(rawMsg, key)
		case "additionalLocations":
			err = unpopulate(val, "AdditionalLocations", &s.AdditionalLocations)
			delete(rawMsg, key)
		case "certificates":
			err = unpopulate(val, "Certificates", &s.Certificates)
			delete(rawMsg, key)
		case "createdAtUtc":
			err = unpopulateTimeRFC3339(val, "CreatedAtUTC", &s.CreatedAtUTC)
			delete(rawMsg, key)
		case "customProperties":
			err = unpopulate(val, "CustomProperties", &s.CustomProperties)
			delete(rawMsg, key)
		case "developerPortalUrl":
			err = unpopulate(val, "DeveloperPortalURL", &s.DeveloperPortalURL)
			delete(rawMsg, key)
		case "disableGateway":
			err = unpopulate(val, "DisableGateway", &s.DisableGateway)
			delete(rawMsg, key)
		case "enableClientCertificate":
			err = unpopulate(val, "EnableClientCertificate", &s.EnableClientCertificate)
			delete(rawMsg, key)
		case "gatewayRegionalUrl":
			err = unpopulate(val, "GatewayRegionalURL", &s.GatewayRegionalURL)
			delete(rawMsg, key)
		case "gatewayUrl":
			err = unpopulate(val, "GatewayURL", &s.GatewayURL)
			delete(rawMsg, key)
		case "hostnameConfigurations":
			err = unpopulate(val, "HostnameConfigurations", &s.HostnameConfigurations)
			delete(rawMsg, key)
		case "managementApiUrl":
			err = unpopulate(val, "ManagementAPIURL", &s.ManagementAPIURL)
			delete(rawMsg, key)
		case "notificationSenderEmail":
			err = unpopulate(val, "NotificationSenderEmail", &s.NotificationSenderEmail)
			delete(rawMsg, key)
		case "platformVersion":
			err = unpopulate(val, "PlatformVersion", &s.PlatformVersion)
			delete(rawMsg, key)
		case "portalUrl":
			err = unpopulate(val, "PortalURL", &s.PortalURL)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &s.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "privateIPAddresses":
			err = unpopulate(val, "PrivateIPAddresses", &s.PrivateIPAddresses)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "publicIpAddressId":
			err = unpopulate(val, "PublicIPAddressID", &s.PublicIPAddressID)
			delete(rawMsg, key)
		case "publicIPAddresses":
			err = unpopulate(val, "PublicIPAddresses", &s.PublicIPAddresses)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "publisherEmail":
			err = unpopulate(val, "PublisherEmail", &s.PublisherEmail)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &s.PublisherName)
			delete(rawMsg, key)
		case "restore":
			err = unpopulate(val, "Restore", &s.Restore)
			delete(rawMsg, key)
		case "scmUrl":
			err = unpopulate(val, "ScmURL", &s.ScmURL)
			delete(rawMsg, key)
		case "targetProvisioningState":
			err = unpopulate(val, "TargetProvisioningState", &s.TargetProvisioningState)
			delete(rawMsg, key)
		case "virtualNetworkConfiguration":
			err = unpopulate(val, "VirtualNetworkConfiguration", &s.VirtualNetworkConfiguration)
			delete(rawMsg, key)
		case "virtualNetworkType":
			err = unpopulate(val, "VirtualNetworkType", &s.VirtualNetworkType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionContractProperties.
func (s SubscriptionContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowTracing", s.AllowTracing)
	populateTimeRFC3339(objectMap, "createdDate", s.CreatedDate)
	populate(objectMap, "displayName", s.DisplayName)
	populateTimeRFC3339(objectMap, "endDate", s.EndDate)
	populateTimeRFC3339(objectMap, "expirationDate", s.ExpirationDate)
	populateTimeRFC3339(objectMap, "notificationDate", s.NotificationDate)
	populate(objectMap, "ownerId", s.OwnerID)
	populate(objectMap, "primaryKey", s.PrimaryKey)
	populate(objectMap, "scope", s.Scope)
	populate(objectMap, "secondaryKey", s.SecondaryKey)
	populateTimeRFC3339(objectMap, "startDate", s.StartDate)
	populate(objectMap, "state", s.State)
	populate(objectMap, "stateComment", s.StateComment)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionContractProperties.
func (s *SubscriptionContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowTracing":
			err = unpopulate(val, "AllowTracing", &s.AllowTracing)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateTimeRFC3339(val, "CreatedDate", &s.CreatedDate)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "endDate":
			err = unpopulateTimeRFC3339(val, "EndDate", &s.EndDate)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateTimeRFC3339(val, "ExpirationDate", &s.ExpirationDate)
			delete(rawMsg, key)
		case "notificationDate":
			err = unpopulateTimeRFC3339(val, "NotificationDate", &s.NotificationDate)
			delete(rawMsg, key)
		case "ownerId":
			err = unpopulate(val, "OwnerID", &s.OwnerID)
			delete(rawMsg, key)
		case "primaryKey":
			err = unpopulate(val, "PrimaryKey", &s.PrimaryKey)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &s.Scope)
			delete(rawMsg, key)
		case "secondaryKey":
			err = unpopulate(val, "SecondaryKey", &s.SecondaryKey)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateTimeRFC3339(val, "StartDate", &s.StartDate)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "stateComment":
			err = unpopulate(val, "StateComment", &s.StateComment)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionUpdateParameterProperties.
func (s SubscriptionUpdateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowTracing", s.AllowTracing)
	populate(objectMap, "displayName", s.DisplayName)
	populateTimeRFC3339(objectMap, "expirationDate", s.ExpirationDate)
	populate(objectMap, "ownerId", s.OwnerID)
	populate(objectMap, "primaryKey", s.PrimaryKey)
	populate(objectMap, "scope", s.Scope)
	populate(objectMap, "secondaryKey", s.SecondaryKey)
	populate(objectMap, "state", s.State)
	populate(objectMap, "stateComment", s.StateComment)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionUpdateParameterProperties.
func (s *SubscriptionUpdateParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowTracing":
			err = unpopulate(val, "AllowTracing", &s.AllowTracing)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateTimeRFC3339(val, "ExpirationDate", &s.ExpirationDate)
			delete(rawMsg, key)
		case "ownerId":
			err = unpopulate(val, "OwnerID", &s.OwnerID)
			delete(rawMsg, key)
		case "primaryKey":
			err = unpopulate(val, "PrimaryKey", &s.PrimaryKey)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &s.Scope)
			delete(rawMsg, key)
		case "secondaryKey":
			err = unpopulate(val, "SecondaryKey", &s.SecondaryKey)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "stateComment":
			err = unpopulate(val, "StateComment", &s.StateComment)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionUpdateParameters.
func (s SubscriptionUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagCreateUpdateParameters.
func (t TagCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", t.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TenantConfigurationSyncStateContractProperties.
func (t TenantConfigurationSyncStateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "branch", t.Branch)
	populate(objectMap, "commitId", t.CommitID)
	populateTimeRFC3339(objectMap, "configurationChangeDate", t.ConfigurationChangeDate)
	populate(objectMap, "isExport", t.IsExport)
	populate(objectMap, "isGitEnabled", t.IsGitEnabled)
	populate(objectMap, "isSynced", t.IsSynced)
	populate(objectMap, "lastOperationId", t.LastOperationID)
	populateTimeRFC3339(objectMap, "syncDate", t.SyncDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TenantConfigurationSyncStateContractProperties.
func (t *TenantConfigurationSyncStateContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "branch":
			err = unpopulate(val, "Branch", &t.Branch)
			delete(rawMsg, key)
		case "commitId":
			err = unpopulate(val, "CommitID", &t.CommitID)
			delete(rawMsg, key)
		case "configurationChangeDate":
			err = unpopulateTimeRFC3339(val, "ConfigurationChangeDate", &t.ConfigurationChangeDate)
			delete(rawMsg, key)
		case "isExport":
			err = unpopulate(val, "IsExport", &t.IsExport)
			delete(rawMsg, key)
		case "isGitEnabled":
			err = unpopulate(val, "IsGitEnabled", &t.IsGitEnabled)
			delete(rawMsg, key)
		case "isSynced":
			err = unpopulate(val, "IsSynced", &t.IsSynced)
			delete(rawMsg, key)
		case "lastOperationId":
			err = unpopulate(val, "LastOperationID", &t.LastOperationID)
			delete(rawMsg, key)
		case "syncDate":
			err = unpopulateTimeRFC3339(val, "SyncDate", &t.SyncDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TenantSettingsContractProperties.
func (t TenantSettingsContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "settings", t.Settings)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UserContractProperties.
func (u UserContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "email", u.Email)
	populate(objectMap, "firstName", u.FirstName)
	populate(objectMap, "groups", u.Groups)
	populate(objectMap, "identities", u.Identities)
	populate(objectMap, "lastName", u.LastName)
	populate(objectMap, "note", u.Note)
	populateTimeRFC3339(objectMap, "registrationDate", u.RegistrationDate)
	populate(objectMap, "state", u.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserContractProperties.
func (u *UserContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "email":
			err = unpopulate(val, "Email", &u.Email)
			delete(rawMsg, key)
		case "firstName":
			err = unpopulate(val, "FirstName", &u.FirstName)
			delete(rawMsg, key)
		case "groups":
			err = unpopulate(val, "Groups", &u.Groups)
			delete(rawMsg, key)
		case "identities":
			err = unpopulate(val, "Identities", &u.Identities)
			delete(rawMsg, key)
		case "lastName":
			err = unpopulate(val, "LastName", &u.LastName)
			delete(rawMsg, key)
		case "note":
			err = unpopulate(val, "Note", &u.Note)
			delete(rawMsg, key)
		case "registrationDate":
			err = unpopulateTimeRFC3339(val, "RegistrationDate", &u.RegistrationDate)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &u.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserCreateParameterProperties.
func (u UserCreateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appType", u.AppType)
	populate(objectMap, "confirmation", u.Confirmation)
	populate(objectMap, "email", u.Email)
	populate(objectMap, "firstName", u.FirstName)
	populate(objectMap, "identities", u.Identities)
	populate(objectMap, "lastName", u.LastName)
	populate(objectMap, "note", u.Note)
	populate(objectMap, "password", u.Password)
	populate(objectMap, "state", u.State)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UserEntityBaseParameters.
func (u UserEntityBaseParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identities", u.Identities)
	populate(objectMap, "note", u.Note)
	populate(objectMap, "state", u.State)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UserTokenParameterProperties.
func (u UserTokenParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "expiry", u.Expiry)
	populate(objectMap, "keyType", u.KeyType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserTokenParameterProperties.
func (u *UserTokenParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiry":
			err = unpopulateTimeRFC3339(val, "Expiry", &u.Expiry)
			delete(rawMsg, key)
		case "keyType":
			err = unpopulate(val, "KeyType", &u.KeyType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserUpdateParameters.
func (u UserUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UserUpdateParametersProperties.
func (u UserUpdateParametersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "email", u.Email)
	populate(objectMap, "firstName", u.FirstName)
	populate(objectMap, "identities", u.Identities)
	populate(objectMap, "lastName", u.LastName)
	populate(objectMap, "note", u.Note)
	populate(objectMap, "password", u.Password)
	populate(objectMap, "state", u.State)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
