/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.DictNodes;
import com.oracle.graal.python.lib.PyDictSetDefaultNodeGen;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class PyDictSetDefault
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Node var2, Object var3, Object var4, Object var5);

    @CompilerDirectives.TruffleBoundary
    public static Object executeUncached(Object dict, Object key, Object defaultValue) {
        return PyDictSetDefaultNodeGen.getUncached().execute(null, null, dict, key, defaultValue);
    }

    @Specialization
    public static Object doIt(VirtualFrame frame, Node inliningTarget, Object dict, Object key, Object defaultValue, @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached DictNodes.UpdateDictStorageNode updateStorageNode, @Cached PyObjectHashNode hashNode, @Cached HashingStorageNodes.HashingStorageGetItemWithHash getItem, @Cached HashingStorageNodes.HashingStorageSetItemWithHash setItem, @Cached InlinedConditionProfile hasValue) {
        long keyHash;
        HashingStorage storage = getStorageNode.execute(inliningTarget, dict);
        Object value = getItem.execute((Frame)frame, inliningTarget, storage, key, keyHash = hashNode.execute((Frame)frame, inliningTarget, key));
        if (hasValue.profile(inliningTarget, value != null)) {
            return value;
        }
        HashingStorage newStorage = setItem.execute((Frame)frame, inliningTarget, storage, key, keyHash, defaultValue);
        updateStorageNode.execute(inliningTarget, dict, storage, newStorage);
        return defaultValue;
    }
}

