/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ordereddict;

import com.oracle.graal.python.builtins.objects.common.ObjectHashMap;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.truffle.api.object.Shape;

public final class POrderedDict
extends PDict {
    ObjectHashMap nodes = new ObjectHashMap();
    ODictNode first;
    ODictNode last;

    public POrderedDict(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    void append(ODictNode node) {
        if (this.last != null) {
            this.last.next = node;
        } else {
            this.first = node;
        }
        node.next = null;
        node.prev = this.last;
        this.last = node;
    }

    void prepend(ODictNode node) {
        if (this.first != null) {
            this.first.prev = node;
        } else {
            this.last = node;
        }
        node.next = this.first;
        node.prev = null;
        this.first = node;
    }

    void remove(ODictNode node) {
        if (this.first == node) {
            this.first = node.next;
        }
        if (this.last == node) {
            this.last = node.prev;
        }
        if (node.prev != null) {
            node.prev.next = node.next;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        }
    }

    static final class ODictNode {
        final Object key;
        final long hash;
        ODictNode prev;
        ODictNode next;

        public ODictNode(Object key, long hash, ODictNode prev, ODictNode next) {
            this.key = key;
            this.hash = hash;
            this.prev = prev;
            this.next = next;
        }
    }
}

