/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.data;

import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.StatusCode;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.data.AutoValue_ImmutableStatusData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.data.StatusData;

@AutoValue
@Immutable
abstract class ImmutableStatusData
implements StatusData {
    static final StatusData OK = ImmutableStatusData.createInternal(StatusCode.OK, "");
    static final StatusData UNSET = ImmutableStatusData.createInternal(StatusCode.UNSET, "");
    static final StatusData ERROR = ImmutableStatusData.createInternal(StatusCode.ERROR, "");

    ImmutableStatusData() {
    }

    static StatusData create(StatusCode statusCode, String description) {
        if (description == null || description.isEmpty()) {
            switch (statusCode) {
                case UNSET: {
                    return StatusData.unset();
                }
                case OK: {
                    return StatusData.ok();
                }
                case ERROR: {
                    return StatusData.error();
                }
            }
        }
        return ImmutableStatusData.createInternal(statusCode, description);
    }

    private static StatusData createInternal(StatusCode statusCode, String description) {
        return new AutoValue_ImmutableStatusData(statusCode, description);
    }
}

