/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class Base2ExponentialHistogramIndexer {
    private static final Map<Integer, Base2ExponentialHistogramIndexer> cache = new ConcurrentHashMap<Integer, Base2ExponentialHistogramIndexer>();
    private static final long EXPONENT_BIT_MASK = 0x7FF0000000000000L;
    private static final long SIGNIFICAND_BIT_MASK = 0xFFFFFFFFFFFFFL;
    private static final int EXPONENT_BIAS = 1023;
    private static final int SIGNIFICAND_WIDTH = 52;
    private static final int EXPONENT_WIDTH = 11;
    private static final double LOG_BASE2_E = 1.0 / Math.log(2.0);
    private final int scale;
    private final double scaleFactor;

    private Base2ExponentialHistogramIndexer(int scale) {
        this.scale = scale;
        this.scaleFactor = Base2ExponentialHistogramIndexer.computeScaleFactor(scale);
    }

    static Base2ExponentialHistogramIndexer get(int scale) {
        return cache.computeIfAbsent(scale, Base2ExponentialHistogramIndexer::new);
    }

    int computeIndex(double value) {
        double absValue = Math.abs(value);
        if (this.scale > 0) {
            return this.getIndexByLogarithm(absValue);
        }
        if (this.scale == 0) {
            return Base2ExponentialHistogramIndexer.mapToIndexScaleZero(absValue);
        }
        return Base2ExponentialHistogramIndexer.mapToIndexScaleZero(absValue) >> -this.scale;
    }

    private int getIndexByLogarithm(double value) {
        return (int)Math.ceil(Math.log(value) * this.scaleFactor) - 1;
    }

    private static int mapToIndexScaleZero(double value) {
        long rawBits = Double.doubleToLongBits(value);
        long rawExponent = (rawBits & 0x7FF0000000000000L) >> 52;
        long rawSignificand = rawBits & 0xFFFFFFFFFFFFFL;
        if (rawExponent == 0L) {
            rawExponent -= (long)(Long.numberOfLeadingZeros(rawSignificand - 1L) - 11 - 1);
        }
        int ieeeExponent = (int)(rawExponent - 1023L);
        if (rawSignificand == 0L) {
            return ieeeExponent - 1;
        }
        return ieeeExponent;
    }

    private static double computeScaleFactor(int scale) {
        return Math.scalb(LOG_BASE2_E, scale);
    }
}

