/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.api.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Value;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.ValueType;

final class ValueArray
implements Value<List<Value<?>>> {
    private final List<Value<?>> value;

    private ValueArray(List<Value<?>> value) {
        this.value = value;
    }

    static Value<List<Value<?>>> create(Value<?> ... value) {
        Objects.requireNonNull(value, "value must not be null");
        ArrayList list = new ArrayList(value.length);
        list.addAll(Arrays.asList(value));
        return new ValueArray(Collections.unmodifiableList(list));
    }

    static Value<List<Value<?>>> create(List<Value<?>> value) {
        return new ValueArray(Collections.unmodifiableList(value));
    }

    @Override
    public ValueType getType() {
        return ValueType.ARRAY;
    }

    @Override
    public List<Value<?>> getValue() {
        return this.value;
    }

    @Override
    public String asString() {
        return this.value.stream().map(Value::asString).collect(Collectors.joining(", ", "[", "]"));
    }

    public String toString() {
        return "ValueArray{" + this.asString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Value && Objects.equals(this.value, ((Value)o).getValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

