/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.api.baggage;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.baggage.Baggage;
import net.snowflake.client.jdbc.internal.opentelemetry.api.baggage.BaggageBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.baggage.BaggageEntry;
import net.snowflake.client.jdbc.internal.opentelemetry.api.baggage.BaggageEntryMetadata;
import net.snowflake.client.jdbc.internal.opentelemetry.api.baggage.ImmutableEntry;
import net.snowflake.client.jdbc.internal.opentelemetry.api.internal.ImmutableKeyValuePairs;

@Immutable
final class ImmutableBaggage
extends ImmutableKeyValuePairs<String, BaggageEntry>
implements Baggage {
    private static final Baggage EMPTY = new Builder().build();

    private ImmutableBaggage(Object[] data) {
        super(data, Comparator.naturalOrder());
    }

    static Baggage empty() {
        return EMPTY;
    }

    static BaggageBuilder builder() {
        return new Builder();
    }

    @Override
    @Nullable
    public String getEntryValue(String entryKey) {
        BaggageEntry entry = (BaggageEntry)this.get(entryKey);
        return entry != null ? entry.getValue() : null;
    }

    @Override
    public BaggageBuilder toBuilder() {
        return new Builder(new ArrayList<Object>(this.data()));
    }

    private static Baggage sortAndFilterToBaggage(Object[] data) {
        return new ImmutableBaggage(data);
    }

    static class Builder
    implements BaggageBuilder {
        private final List<Object> data;

        Builder() {
            this.data = new ArrayList<Object>();
        }

        Builder(List<Object> data) {
            this.data = data;
        }

        @Override
        public BaggageBuilder put(String key, String value, BaggageEntryMetadata entryMetadata) {
            if (key == null || value == null || entryMetadata == null) {
                return this;
            }
            this.data.add(key);
            this.data.add(ImmutableEntry.create(value, entryMetadata));
            return this;
        }

        @Override
        public BaggageBuilder remove(String key) {
            if (key == null) {
                return this;
            }
            this.data.add(key);
            this.data.add(null);
            return this;
        }

        @Override
        public Baggage build() {
            return ImmutableBaggage.sortAndFilterToBaggage(this.data.toArray());
        }
    }
}

