/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage.analytics;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.analytics.LogRecordStreamReader;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.Utility;

public class LogRecord {
    protected static final SimpleDateFormat REQUEST_START_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
    protected static final SimpleDateFormat LAST_MODIFIED_TIME_FORMAT = new SimpleDateFormat("E, dd-MMM-yy HH:mm:ss 'GMT'");
    private String versionNumber;
    private Date requestStartTime;
    private String operationType;
    private String requestStatus;
    private String httpStatusCode;
    private Integer endToEndLatencyInMS;
    private Integer serverLatencyInMS;
    private String authenticationType;
    private String requesterAccountName;
    private String ownerAccountName;
    private String serviceType;
    private URI requestUrl;
    private String requestedObjectKey;
    private UUID requestIdHeader;
    private Integer operationCount;
    private String requesterIPAddress;
    private String requestVersionHeader;
    private Long requestHeaderSize;
    private Long requestPacketSize;
    private Long responseHeaderSize;
    private Long responsePacketSize;
    private Long requestContentLength;
    private String requestMD5;
    private String serverMD5;
    private String eTagIdentifier;
    private Date lastModifiedTime;
    private String conditionsUsed;
    private String userAgentHeader;
    private String referrerHeader;
    private String clientRequestId;

    protected LogRecord() {
    }

    protected LogRecord(LogRecordStreamReader reader) throws IOException, ParseException, URISyntaxException {
        LAST_MODIFIED_TIME_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        REQUEST_START_TIME_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        Utility.assertNotNull("reader", reader);
        this.versionNumber = reader.readString();
        Utility.assertNotNullOrEmpty("versionNumber", this.versionNumber);
        if (!this.versionNumber.equals("1.0")) {
            throw new IllegalArgumentException(String.format("A storage log version of %s is unsupported.", this.versionNumber));
        }
        this.populateVersion1Log(reader);
    }

    private void populateVersion1Log(LogRecordStreamReader reader) throws IOException, ParseException, URISyntaxException {
        this.requestStartTime = reader.readDate(REQUEST_START_TIME_FORMAT);
        this.operationType = reader.readString();
        this.requestStatus = reader.readString();
        this.httpStatusCode = reader.readString();
        this.endToEndLatencyInMS = reader.readInteger();
        this.serverLatencyInMS = reader.readInteger();
        this.authenticationType = reader.readString();
        this.requesterAccountName = reader.readString();
        this.ownerAccountName = reader.readString();
        this.serviceType = reader.readString();
        this.requestUrl = reader.readUri();
        this.requestedObjectKey = reader.readQuotedString();
        this.requestIdHeader = reader.readUuid();
        this.operationCount = reader.readInteger();
        this.requesterIPAddress = reader.readString();
        this.requestVersionHeader = reader.readString();
        this.requestHeaderSize = reader.readLong();
        this.requestPacketSize = reader.readLong();
        this.responseHeaderSize = reader.readLong();
        this.responsePacketSize = reader.readLong();
        this.requestContentLength = reader.readLong();
        this.requestMD5 = reader.readQuotedString();
        this.serverMD5 = reader.readQuotedString();
        this.eTagIdentifier = reader.readQuotedString();
        this.lastModifiedTime = reader.readDate(LAST_MODIFIED_TIME_FORMAT);
        this.conditionsUsed = reader.readQuotedString();
        this.userAgentHeader = reader.readQuotedString();
        this.referrerHeader = reader.readQuotedString();
        this.clientRequestId = reader.readQuotedString();
        reader.endCurrentRecord();
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public Date getRequestStartTime() {
        return this.requestStartTime;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public String getRequestStatus() {
        return this.requestStatus;
    }

    public String getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public Integer getEndToEndLatencyInMS() {
        return this.endToEndLatencyInMS;
    }

    public Integer getServerLatencyInMS() {
        return this.serverLatencyInMS;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public String getRequesterAccountName() {
        return this.requesterAccountName;
    }

    public String getOwnerAccountName() {
        return this.ownerAccountName;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public URI getRequestUrl() {
        return this.requestUrl;
    }

    public String getRequestedObjectKey() {
        return this.requestedObjectKey;
    }

    public UUID getRequestIdHeader() {
        return this.requestIdHeader;
    }

    public Integer getOperationCount() {
        return this.operationCount;
    }

    public String getRequesterIPAddress() {
        return this.requesterIPAddress;
    }

    public String getRequestVersionHeader() {
        return this.requestVersionHeader;
    }

    public Long getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    public Long getRequestPacketSize() {
        return this.requestPacketSize;
    }

    public Long getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    public Long getResponsePacketSize() {
        return this.responsePacketSize;
    }

    public Long getRequestContentLength() {
        return this.requestContentLength;
    }

    public String getRequestMD5() {
        return this.requestMD5;
    }

    public String getServerMD5() {
        return this.serverMD5;
    }

    public String getETagIdentifier() {
        return this.eTagIdentifier;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String getConditionsUsed() {
        return this.conditionsUsed;
    }

    public String getUserAgentHeader() {
        return this.userAgentHeader;
    }

    public String getReferrerHeader() {
        return this.referrerHeader;
    }

    public String getClientRequestId() {
        return this.clientRequestId;
    }

    protected void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    protected void setRequestStartTime(Date requestStartTime) {
        this.requestStartTime = requestStartTime;
    }

    protected void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    protected void setRequestStatus(String requestStatus) {
        this.requestStatus = requestStatus;
    }

    protected void setHttpStatusCode(String httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    protected void setEndToEndLatencyInMS(Integer endToEndLatencyInMS) {
        this.endToEndLatencyInMS = endToEndLatencyInMS;
    }

    protected void setServerLatencyInMS(Integer serverLatencyInMS) {
        this.serverLatencyInMS = serverLatencyInMS;
    }

    protected void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    protected void setRequesterAccountName(String requesterAccountName) {
        this.requesterAccountName = requesterAccountName;
    }

    protected void setOwnerAccountName(String ownerAccountName) {
        this.ownerAccountName = ownerAccountName;
    }

    protected void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    protected void setRequestUrl(URI requestUrl) {
        this.requestUrl = requestUrl;
    }

    protected void setRequestedObjectKey(String requestedObjectKey) {
        this.requestedObjectKey = requestedObjectKey;
    }

    protected void setRequestIdHeader(UUID requestIdHeader) {
        this.requestIdHeader = requestIdHeader;
    }

    protected void setOperationCount(Integer operationCount) {
        this.operationCount = operationCount;
    }

    protected void setRequesterIPAddress(String requesterIPAddress) {
        this.requesterIPAddress = requesterIPAddress;
    }

    protected void setRequestVersionHeader(String requestVersionHeader) {
        this.requestVersionHeader = requestVersionHeader;
    }

    protected void setRequestHeaderSize(Long requestHeaderSize) {
        this.requestHeaderSize = requestHeaderSize;
    }

    protected void setRequestPacketSize(Long requestPacketSize) {
        this.requestPacketSize = requestPacketSize;
    }

    protected void setResponseHeaderSize(Long responseHeaderSize) {
        this.responseHeaderSize = responseHeaderSize;
    }

    protected void setResponsePacketSize(Long responsePacketSize) {
        this.responsePacketSize = responsePacketSize;
    }

    protected void setRequestContentLength(Long requestContentLength) {
        this.requestContentLength = requestContentLength;
    }

    protected void setRequestMD5(String requestMD5) {
        this.requestMD5 = requestMD5;
    }

    protected void setServerMD5(String serverMD5) {
        this.serverMD5 = serverMD5;
    }

    protected void setETagIdentifier(String eTagIdentifier) {
        this.eTagIdentifier = eTagIdentifier;
    }

    protected void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    protected void setConditionsUsed(String conditionsUsed) {
        this.conditionsUsed = conditionsUsed;
    }

    protected void setUserAgentHeader(String userAgentHeader) {
        this.userAgentHeader = userAgentHeader;
    }

    protected void setReferrerHeader(String referrerHeader) {
        this.referrerHeader = referrerHeader;
    }

    protected void setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
    }
}

